/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.manager.sdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Log;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.httptask.iKalaHttpUtils;
import com.ikala.android.manager.sdk.ApiError;
import com.ikala.android.manager.sdk.SdkValidationError;
import com.ikala.android.manager.sdk.SdkValidationTask;
import com.ikala.android.utils.iKalaUtils;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SdkValidator {
    private static final String a = iKalaUtils.getLogTag(SdkValidator.class.getSimpleName());
    private static final HashMap<String, String> b = new HashMap();
    private Retrofit c;
    private SdkValidationTask d;
    private Call e;

    public SdkValidator(Retrofit retrofit) {
        this.c = retrofit;
        this.d = (SdkValidationTask)retrofit.create(SdkValidationTask.class);
    }

    public void validate(final Context context, final String string, String string2, final ValidationResultListener validationResultListener) {
        boolean bl;
        if (validationResultListener == null) {
            Log.w((String)a, (String)"ValidationResultListener should not be null!! Ignore this execution.");
            return;
        }
        String string3 = b.get(string);
        if (string3 != null && (bl = this.a(context, string3, validationResultListener))) {
            validationResultListener.onSuccess();
            return;
        }
        if (this.e == null) {
            this.e = this.d.getHashKey(string, string2);
        } else {
            this.e.cancel();
            this.e = this.d.getHashKey(string, string2);
        }
        this.e.enqueue((Callback)new Callback<SdkValidationTask.HashKeyResponse>(){

            public void onResponse(Call<SdkValidationTask.HashKeyResponse> call, Response<SdkValidationTask.HashKeyResponse> response) {
                if (!response.isSuccessful()) {
                    ApiError apiError = HttpTaskError.parseError(SdkValidator.this.c, response, ApiError.class);
                    validationResultListener.onFailure(new SdkValidationError(3, "", apiError));
                    return;
                }
                String string2 = ((SdkValidationTask.HashKeyResponse)response.body()).android_certificate;
                b.put(string, string2);
                boolean bl = SdkValidator.this.a(context, string2, validationResultListener);
                if (!bl) {
                    return;
                }
                validationResultListener.onSuccess();
            }

            public void onFailure(Call<SdkValidationTask.HashKeyResponse> call, Throwable throwable) {
                validationResultListener.onFailure(new SdkValidationError(1, "", new HttpTaskError(HttpTaskError.getThrowableMappingId(call, throwable))));
            }
        });
    }

    private boolean a(Context context, String string, ValidationResultListener validationResultListener) {
        String string2 = this.a(context);
        if (string2 == null || string == null) {
            validationResultListener.onFailure(new SdkValidationError(2));
            return false;
        }
        if (!string2.equals(string)) {
            validationResultListener.onFailure(new SdkValidationError(2));
            return false;
        }
        return true;
    }

    private String a(Context context) {
        String string = "";
        Signature[] signatureArray = new Signature[]{};
        try {
            signatureArray = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        for (Signature signature : signatureArray) {
            byte[] byArray = signature.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                string = iKalaHttpUtils.generateChecksum("SHA-1", x509Certificate.getEncoded());
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return string;
    }

    public void cancel() {
        if (this.e != null) {
            this.e.cancel();
        }
    }

    public static interface ValidationResultListener {
        public void onFailure(SdkValidationError var1);

        public void onSuccess();
    }
}

