/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.httptask.error;

import com.ikala.android.interfaces.error.ErrorObject;
import com.squareup.moshi.JsonDataException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class HttpTaskError
extends ErrorObject<Void> {
    public static final int ERROR_UNDEFINED = Integer.MIN_VALUE;
    public static final int ERROR_GENERAL_ERROR = 1;
    public static final int ERROR_INVALID_DATA = 2;
    public static final int ERROR_NO_CONNECTION = 3;
    public static final int ERROR_CONNECTION_TIMEOUT = 4;
    public static final int ERROR_SOCKET_TIMEOUT = 5;
    public static final int ERROR_TASK_CANCELED = 6;
    public static final int ERROR_UNEXPECTED_TYPE = 7;
    public static final int ERROR_INVALID_SESSION = 110;
    public static final int ERROR_INVALID_CODE = 120;

    public HttpTaskError(int n, String string) {
        super(n, string);
    }

    public HttpTaskError(int n) {
        super(n, null);
    }

    public static int getThrowableMappingId(Call call, Throwable throwable) {
        if (call.isCanceled()) {
            return 6;
        }
        if (throwable instanceof UnknownHostException) {
            return 3;
        }
        if (throwable instanceof SocketTimeoutException) {
            return 5;
        }
        if (throwable instanceof IOException) {
            return 1;
        }
        if (throwable instanceof JsonDataException) {
            return 7;
        }
        return Integer.MIN_VALUE;
    }

    public static <T> T parseError(Retrofit retrofit, Response<?> response, Class<T> clazz) {
        Converter converter = retrofit.responseBodyConverter(clazz, new Annotation[0]);
        Object object = null;
        try {
            object = converter.convert((Object)response.errorBody());
        }
        catch (JsonDataException | IOException throwable) {
            return (T)object;
        }
        return (T)object;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpTaskErrorType {
    }
}

