/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector.primitive;

import java.math.BigDecimal;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.openx.data.jsonserde.objectinspector.primitive.ParsePrimitiveUtils;
import org.openx.data.jsonserde.objectinspector.primitive.TypeEntryShim;

public class JavaStringIntObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableIntObjectInspector {
    public JavaStringIntObjectInspector() {
        super(TypeEntryShim.intType);
    }

    public Object getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        return new IntWritable(this.get(o));
    }

    public int get(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        if (o instanceof Double) {
            return ((Double)o).intValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        return ParsePrimitiveUtils.parseInt(o.toString());
    }

    public Object getPrimitiveJavaObject(Object o) {
        return this.get(o);
    }

    public Object create(int value) {
        return value;
    }

    public Object set(Object o, int value) {
        return value;
    }
}

