/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector.primitive;

import java.util.Base64;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableBinaryObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.openx.data.jsonserde.objectinspector.primitive.TypeEntryShim;

public class JavaStringBinaryObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableBinaryObjectInspector {
    public JavaStringBinaryObjectInspector() {
        super(TypeEntryShim.binaryType);
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new BytesWritable(Base64.getDecoder().decode((String)o));
        }
        return new BytesWritable((byte[])o);
    }

    public byte[] getPrimitiveJavaObject(Object o) {
        if (o instanceof String) {
            return Base64.getDecoder().decode((String)o);
        }
        return (byte[])o;
    }

    public byte[] set(Object o, byte[] bb) {
        return bb == null ? null : Base64.getEncoder().encode(bb);
    }

    public byte[] set(Object o, BytesWritable bw) {
        return bw == null ? null : Base64.getEncoder().encode(bw.getBytes());
    }

    public byte[] create(byte[] bb) {
        return bb == null ? null : Base64.getEncoder().encode(bb);
    }

    public byte[] create(BytesWritable bw) {
        return bw == null ? null : Base64.getEncoder().encode(bw.getBytes());
    }
}

