/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector;

import io.starburst.openjson.JSONArray;
import io.starburst.openjson.JSONObject;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.openx.data.jsonserde.objectinspector.JsonStructOIOptions;

public class JsonUnionObjectInspector
implements UnionObjectInspector {
    JsonStructOIOptions options;
    private List<ObjectInspector> ois;

    public JsonUnionObjectInspector(List<ObjectInspector> ois, JsonStructOIOptions opts) {
        this.ois = ois;
        this.options = opts;
    }

    public List<ObjectInspector> getObjectInspectors() {
        return this.ois;
    }

    public byte getTag(Object o) {
        if (o == null) {
            return 0;
        }
        block9: for (byte i = 0; i < this.ois.size(); i = (byte)(i + 1)) {
            ObjectInspector oi = this.ois.get(i);
            switch (oi.getCategory()) {
                case LIST: {
                    if (!(o instanceof JSONArray)) continue block9;
                    return i;
                }
                case STRUCT: {
                    if (!(o instanceof JSONObject)) continue block9;
                    return i;
                }
                case MAP: {
                    if (!(o instanceof JSONObject)) continue block9;
                    return i;
                }
                case UNION: {
                    return i;
                }
                case PRIMITIVE: {
                    PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                    try {
                        poi.getPrimitiveJavaObject(o);
                        return i;
                    }
                    catch (Exception ex) {
                        continue block9;
                    }
                }
                default: {
                    throw new Error("Object Inspector " + oi.toString() + " Not supported for object " + o.toString());
                }
            }
        }
        throw new Error("No suitable Object Inspector found for object  " + o.toString() + " of class " + o.getClass().getCanonicalName());
    }

    public Object getField(Object o) {
        return o;
    }

    public String getTypeName() {
        return ObjectInspectorUtils.getStandardUnionTypeName((UnionObjectInspector)this);
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }
}

