/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import io.springlets.data.web.datatables.Datatables;
import io.springlets.data.web.datatables.DatatablesSort;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DatatablesSortHandlerMethodArgumentResolver
extends SortHandlerMethodArgumentResolver {
    private static final int MAX_ORDERED_COLUMNS = 5;
    private final int maxOrderedColumns;

    public DatatablesSortHandlerMethodArgumentResolver() {
        this(5);
    }

    public DatatablesSortHandlerMethodArgumentResolver(int maxOrderedColumns) {
        this.maxOrderedColumns = maxOrderedColumns;
    }

    public DatatablesSort resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) {
        DatatablesSort sort = new SortParametersParser(this.maxOrderedColumns, request.getParameterMap()).getSort();
        return sort;
    }

    static class SortParametersParser {
        private static final Pattern PATTERN = Pattern.compile("order\\[([0-9]*)?\\]\\[column\\]");
        private final int maxColumnCount;
        private Map<String, String[]> parameters;

        public SortParametersParser(int maxOrderedColumns, Map<String, String[]> parameters) {
            this.maxColumnCount = maxOrderedColumns;
            this.parameters = parameters;
        }

        int getColumnCount() {
            if (this.parameters == null || this.parameters.isEmpty()) {
                return 0;
            }
            int columnCount = -1;
            for (String paramName : this.parameters.keySet()) {
                int columnNumber = SortParametersParser.getColumnPosition(paramName);
                if (columnNumber <= columnCount) continue;
                columnCount = columnNumber;
            }
            return ++columnCount > this.maxColumnCount ? this.maxColumnCount : columnCount;
        }

        static int getColumnPosition(String paramName) {
            Matcher matcher = PATTERN.matcher(paramName);
            while (matcher.find()) {
                try {
                    return Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return -1;
        }

        String getPropertyNameInOrderPosition(int pos) {
            String columnPosition = this.getParameter(Datatables.orderColumnIndexParameter(pos));
            if (columnPosition == null) {
                return null;
            }
            return this.getParameter(Datatables.columnNameParameter(columnPosition));
        }

        Sort.Direction getOrderDirection(int pos) {
            String direction = this.getParameter(Datatables.orderDirectionParameter(pos));
            if ("desc".equals(direction)) {
                return Sort.Direction.DESC;
            }
            return Sort.Direction.ASC;
        }

        Sort.Order getOrderInPosition(int pos) {
            String propertyName = this.getPropertyNameInOrderPosition(pos);
            if (propertyName == null) {
                return null;
            }
            Sort.Direction direction = this.getOrderDirection(pos);
            return new Sort.Order(direction, propertyName);
        }

        public DatatablesSort getSort() {
            int columnCount = this.getColumnCount();
            if (columnCount <= 0) {
                return null;
            }
            ArrayList<Sort.Order> orderList = new ArrayList<Sort.Order>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                Sort.Order order = this.getOrderInPosition(i);
                if (order == null) continue;
                orderList.add(order);
            }
            if (orderList.size() == 0) {
                return null;
            }
            return new DatatablesSort(orderList);
        }

        private String getParameter(String name) {
            String[] values = this.parameters.get(name);
            return values == null || values.length == 0 ? null : values[0];
        }
    }
}

