/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import java.util.List;
import org.springframework.data.domain.Page;

public class DatatablesData<T> {
    private List<T> data;
    private Long recordsTotal;
    private Long recordsFiltered;
    private final Integer draw;
    private String error;

    public DatatablesData(List<T> data, Long recordsTotal, Long recordsFiltered, Integer draw) {
        this(data, recordsTotal, recordsFiltered, draw, null);
    }

    public DatatablesData(Integer draw, String error) {
        this(null, null, null, draw, error);
    }

    public DatatablesData(List<T> data, Long recordsTotal, Long recordsFiltered, Integer draw, String error) {
        this(recordsTotal, recordsFiltered, draw, error);
        this.data = data;
    }

    public DatatablesData(Page<T> dataPage, Long recordsTotal, Integer draw) {
        this(dataPage.getContent(), recordsTotal, dataPage.getTotalElements(), draw);
    }

    protected DatatablesData(Long recordsTotal, Long recordsFiltered, Integer draw, String error) {
        this.recordsTotal = recordsTotal;
        this.recordsFiltered = recordsFiltered;
        this.draw = draw;
        this.error = error;
    }

    public List<T> getData() {
        return this.data;
    }

    public Long getRecordsTotal() {
        return this.recordsTotal;
    }

    public Long getRecordsFiltered() {
        return this.recordsFiltered;
    }

    public Integer getDraw() {
        return this.draw;
    }

    public String getError() {
        return this.error;
    }
}

