/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import io.springlets.data.web.datatables.DatatablesColumns;
import io.springlets.data.web.datatables.DatatablesData;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Page;

public class ConvertedDatatablesData<T>
extends DatatablesData<Map<String, Object>> {
    private static final TypeDescriptor TYPE_STRING = TypeDescriptor.valueOf(String.class);

    public ConvertedDatatablesData(Page<T> data, Long recordsTotal, Integer draw, ConversionService conversionService) {
        this(data.getContent(), recordsTotal, data.getTotalElements(), draw, conversionService, null);
    }

    public ConvertedDatatablesData(Page<T> data, Long recordsTotal, Integer draw, ConversionService conversionService, DatatablesColumns columns) {
        this(data.getContent(), recordsTotal, data.getTotalElements(), draw, conversionService, columns);
    }

    public ConvertedDatatablesData(List<T> data, Long recordsTotal, Long recordsFiltered, Integer draw, ConversionService conversionService) {
        this(data, recordsTotal, recordsFiltered, draw, conversionService, null);
    }

    public ConvertedDatatablesData(List<T> data, Long recordsTotal, Long recordsFiltered, Integer draw, ConversionService conversionService, DatatablesColumns columns) {
        super(ConvertedDatatablesData.convertAll(data, conversionService, columns), recordsTotal, recordsFiltered, draw, null);
    }

    private static List<Map<String, Object>> convertAll(List<?> data, ConversionService conversionService, DatatablesColumns columns) {
        if (data == null) {
            return null;
        }
        ArrayList<Map<String, Object>> converted = new ArrayList<Map<String, Object>>(data.size());
        for (Object value : data) {
            Map<String, Object> convertedValue = columns == null ? ConvertedDatatablesData.convert(value, conversionService) : ConvertedDatatablesData.convert(value, conversionService, columns);
            converted.add(convertedValue);
        }
        return converted;
    }

    private static Map<String, Object> convert(Object value, ConversionService conversionService) {
        BeanWrapperImpl bean = new BeanWrapperImpl(value);
        PropertyDescriptor[] properties = bean.getPropertyDescriptors();
        HashMap<String, Object> convertedValue = new HashMap<String, Object>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i].getName();
            Object propertyValue = bean.getPropertyValue(name);
            if (propertyValue == null || !conversionService.canConvert(propertyValue.getClass(), String.class)) continue;
            TypeDescriptor source = bean.getPropertyTypeDescriptor(name);
            String convertedPropertyValue = (String)conversionService.convert(propertyValue, source, TYPE_STRING);
            convertedValue.put(name, convertedPropertyValue);
        }
        return convertedValue;
    }

    private static Map<String, Object> convert(Object value, ConversionService conversionService, DatatablesColumns columns) {
        BeanWrapperImpl bean = new BeanWrapperImpl(value);
        HashMap<String, Object> convertedValue = new HashMap<String, Object>();
        for (DatatablesColumns.Column column : columns.getColumns()) {
            String property = column.getData();
            convertedValue.put(property, ConvertedDatatablesData.convertProperty((BeanWrapper)bean, property, conversionService, convertedValue));
        }
        return convertedValue;
    }

    private static Object convertProperty(BeanWrapper parentBean, String property, ConversionService conversionService, Map<String, Object> parentValue) {
        TypeDescriptor source = parentBean.getPropertyTypeDescriptor(property);
        Object propertyValue = parentBean.getPropertyValue(property);
        int dotIndex = property.indexOf(46);
        if (dotIndex > 0) {
            String baseProperty = property.substring(0, dotIndex);
            String childProperty = property.substring(dotIndex + 1);
            Map<String, Object> childValue = ConvertedDatatablesData.getChildValue(parentValue, baseProperty, childProperty);
            BeanWrapperImpl childBean = new BeanWrapperImpl(parentBean.getPropertyValue(baseProperty));
            Object convertedProperty = ConvertedDatatablesData.convertProperty((BeanWrapper)childBean, childProperty, conversionService, childValue);
            childValue.put(childProperty, convertedProperty);
            return childValue;
        }
        String convertedPropertyValue = (String)conversionService.convert(propertyValue, source, TYPE_STRING);
        return convertedPropertyValue;
    }

    private static Map<String, Object> getChildValue(Map<String, Object> parentValue, String baseProperty, String childProperty) {
        Object value;
        Map childValue = null;
        if (parentValue.containsKey(childProperty) && (value = parentValue.get(baseProperty)) instanceof Map) {
            childValue = (Map)value;
        }
        if (childValue == null) {
            childValue = new HashMap();
            parentValue.put(baseProperty, childValue);
        }
        return childValue;
    }
}

