/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web;

import io.springlets.data.domain.GlobalSearch;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class GlobalSearchHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String DEFAULT_REGEXP_PARAMETER = "search[regex]";
    private static final String DEFAULT_SEARCH_VALUE_PARAMETER = "search[value]";
    private String searchValueParameter = "search[value]";
    private String regexpParameter = "search[regex]";

    public String getSearchValueParameter() {
        return this.searchValueParameter;
    }

    public void setSearchValueParameter(String searchValueParameter) {
        this.searchValueParameter = searchValueParameter;
    }

    public String getRegexpParameter() {
        return this.regexpParameter;
    }

    public void setRegexpParameter(String regexpParameter) {
        this.regexpParameter = regexpParameter;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return GlobalSearch.class.equals((Object)parameter.getParameterType());
    }

    public GlobalSearch resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String searchValue = webRequest.getParameter(this.getSearchValueParameter());
        if (StringUtils.isEmpty((Object)searchValue)) {
            return null;
        }
        String regexp = webRequest.getParameter(this.getRegexpParameter());
        if ("true".equalsIgnoreCase(regexp)) {
            return new GlobalSearch(searchValue, true);
        }
        if ("false".equalsIgnoreCase(regexp)) {
            return new GlobalSearch(searchValue, false);
        }
        return new GlobalSearch(searchValue);
    }
}

