/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.domain;

import org.springframework.util.Assert;

public final class GlobalSearch {
    private final String searchText;
    private final boolean regexp;

    public GlobalSearch(String text, boolean regexp) {
        Assert.hasText((String)text, (String)"The global search text must be non empty");
        this.searchText = text;
        this.regexp = regexp;
    }

    public GlobalSearch(String text) {
        this(text, false);
    }

    public String getText() {
        return this.searchText;
    }

    public boolean isRegexp() {
        return this.regexp;
    }

    public boolean matches(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        if (this.isRegexp()) {
            return text.matches(this.searchText);
        }
        return text.contains(this.searchText);
    }
}

