/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.WebFluxRequestHandler;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

@Component
@Order(value=-2147483648)
public class WebFluxRequestHandlerProvider
implements RequestHandlerProvider {
    private final List<RequestMappingInfoHandlerMapping> handlerMappings;
    private final HandlerMethodResolver methodResolver;

    @Autowired
    public WebFluxRequestHandlerProvider(HandlerMethodResolver methodResolver, List<RequestMappingInfoHandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
        this.methodResolver = methodResolver;
    }

    public List<RequestHandler> requestHandlers() {
        return BuilderDefaults.nullToEmptyList(this.handlerMappings).stream().filter(requestMappingInfoHandlerMapping -> !"org.springframework.integration.webflux.inbound.WebFluxIntegrationRequestMappingHandlerMapping".equals(requestMappingInfoHandlerMapping.getClass().getName())).map(this.toMappingEntries()).flatMap(entries -> StreamSupport.stream(entries.spliterator(), false)).map(this.toRequestHandler()).sorted(Orderings.byPatternsCondition()).collect(Collectors.toList());
    }

    private Function<RequestMappingInfoHandlerMapping, Iterable<Map.Entry<RequestMappingInfo, HandlerMethod>>> toMappingEntries() {
        return input -> input.getHandlerMethods().entrySet();
    }

    private Function<Map.Entry<RequestMappingInfo, HandlerMethod>, RequestHandler> toRequestHandler() {
        return input -> new WebFluxRequestHandler(this.methodResolver, (RequestMappingInfo)input.getKey(), (HandlerMethod)input.getValue());
    }
}

