/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.PathDecorator;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.ApiListingScannerPlugin;
import springfox.documentation.spi.service.DefaultsProviderPlugin;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spi.service.contexts.PathContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.SpringGroupingStrategy;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.DuplicateGroupsDetector;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;

@Component
public class DocumentationPluginsManager {
    @Autowired
    @Qualifier(value="documentationPluginRegistry")
    private PluginRegistry<DocumentationPlugin, DocumentationType> documentationPlugins;
    @Autowired
    @Qualifier(value="apiListingBuilderPluginRegistry")
    private PluginRegistry<ApiListingBuilderPlugin, DocumentationType> apiListingPlugins;
    @Autowired
    @Qualifier(value="parameterBuilderPluginRegistry")
    private PluginRegistry<ParameterBuilderPlugin, DocumentationType> parameterPlugins;
    @Autowired
    @Qualifier(value="expandedParameterBuilderPluginRegistry")
    private PluginRegistry<ExpandedParameterBuilderPlugin, DocumentationType> parameterExpanderPlugins;
    @Autowired
    @Qualifier(value="operationBuilderPluginRegistry")
    private PluginRegistry<OperationBuilderPlugin, DocumentationType> operationBuilderPlugins;
    @Autowired
    @Qualifier(value="resourceGroupingStrategyRegistry")
    private PluginRegistry<ResourceGroupingStrategy, DocumentationType> resourceGroupingStrategies;
    @Autowired
    @Qualifier(value="operationModelsProviderPluginRegistry")
    private PluginRegistry<OperationModelsProviderPlugin, DocumentationType> operationModelsProviders;
    @Autowired
    @Qualifier(value="defaultsProviderPluginRegistry")
    private PluginRegistry<DefaultsProviderPlugin, DocumentationType> defaultsProviders;
    @Autowired
    @Qualifier(value="pathDecoratorRegistry")
    private PluginRegistry<PathDecorator, DocumentationContext> pathDecorators;
    @Autowired
    @Qualifier(value="apiListingScannerPluginRegistry")
    private PluginRegistry<ApiListingScannerPlugin, DocumentationType> apiListingScanners;

    public Iterable<DocumentationPlugin> documentationPlugins() throws IllegalStateException {
        List plugins = this.documentationPlugins.getPlugins();
        DuplicateGroupsDetector.ensureNoDuplicateGroups(plugins);
        if (plugins.isEmpty()) {
            return Collections.singleton(this.defaultDocumentationPlugin());
        }
        return plugins;
    }

    public Parameter parameter(ParameterContext parameterContext) {
        for (ParameterBuilderPlugin each : this.parameterPlugins.getPluginsFor((Object)parameterContext.getDocumentationType())) {
            each.apply(parameterContext);
        }
        return parameterContext.parameterBuilder().build();
    }

    public Parameter expandParameter(ParameterExpansionContext context) {
        for (ExpandedParameterBuilderPlugin each : this.parameterExpanderPlugins.getPluginsFor((Object)context.getDocumentationType())) {
            each.apply(context);
        }
        return context.getParameterBuilder().build();
    }

    public Operation operation(OperationContext operationContext) {
        for (OperationBuilderPlugin each : this.operationBuilderPlugins.getPluginsFor((Object)operationContext.getDocumentationType())) {
            each.apply(operationContext);
        }
        return operationContext.operationBuilder().build();
    }

    public ApiListing apiListing(ApiListingContext context) {
        for (ApiListingBuilderPlugin each : this.apiListingPlugins.getPluginsFor((Object)context.getDocumentationType())) {
            each.apply(context);
        }
        return context.apiListingBuilder().build();
    }

    public Set<ModelContext> modelContexts(RequestMappingContext context) {
        DocumentationType documentationType = context.getDocumentationContext().getDocumentationType();
        for (OperationModelsProviderPlugin each : this.operationModelsProviders.getPluginsFor((Object)documentationType)) {
            each.apply(context);
        }
        return context.operationModelsBuilder().build();
    }

    public ResourceGroupingStrategy resourceGroupingStrategy(DocumentationType documentationType) {
        return (ResourceGroupingStrategy)this.resourceGroupingStrategies.getPluginOrDefaultFor((Object)documentationType, (Plugin)new SpringGroupingStrategy());
    }

    private DocumentationPlugin defaultDocumentationPlugin() {
        return new Docket(DocumentationType.SWAGGER_2);
    }

    public DocumentationContextBuilder createContextBuilder(DocumentationType documentationType, DefaultsProviderPlugin defaultConfiguration) {
        return ((DefaultsProviderPlugin)this.defaultsProviders.getPluginOrDefaultFor((Object)documentationType, (Plugin)defaultConfiguration)).create(documentationType).withResourceGroupingStrategy(this.resourceGroupingStrategy(documentationType));
    }

    public Function<String, String> decorator(PathContext context) {
        return input -> {
            Iterable decorators = this.pathDecorators.getPluginsFor((Object)context.documentationContext()).stream().map(each -> each.decorator(context)).collect(Collectors.toList());
            String decorated = input;
            for (Function decorator : decorators) {
                decorated = (String)decorator.apply(decorated);
            }
            return decorated;
        };
    }

    public Collection<ApiDescription> additionalListings(ApiListingScanningContext context) {
        DocumentationType documentationType = context.getDocumentationContext().getDocumentationType();
        ArrayList<ApiDescription> additional = new ArrayList<ApiDescription>();
        for (ApiListingScannerPlugin each : this.apiListingScanners.getPluginsFor((Object)documentationType)) {
            additional.addAll(each.apply(context.getDocumentationContext()));
        }
        return additional;
    }
}

