/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.io.File;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterDataTypeReader
implements ParameterBuilderPlugin {
    private final TypeNameExtractor nameExtractor;
    private final TypeResolver resolver;

    @Autowired
    public ParameterDataTypeReader(TypeNameExtractor nameExtractor, TypeResolver resolver) {
        this.nameExtractor = nameExtractor;
        this.resolver = resolver;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        ResolvedMethodParameter methodParameter = context.resolvedMethodParameter();
        ResolvedType parameterType = methodParameter.getResolvedParameterType();
        if (MultipartFile.class.isAssignableFrom((parameterType = context.alternateFor(parameterType)).getErasedType())) {
            context.parameterBuilder().type(this.resolver.resolve(File.class, new Type[0])).modelRef(new ModelRef("File"));
        } else {
            ModelContext modelContext = ModelContext.inputParam((Type)parameterType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericNamingStrategy());
            context.parameterBuilder().type(parameterType).modelRef(this.modelRef(parameterType, modelContext));
        }
    }

    private ModelRef modelRef(ResolvedType type, ModelContext modelContext) {
        if (Collections.isContainerType((ResolvedType)type)) {
            ResolvedType collectionElementType = Collections.collectionElementType((ResolvedType)type);
            if (collectionElementType != null && MultipartFile.class.isAssignableFrom(collectionElementType.getErasedType())) {
                return new ModelRef(Collections.containerType((ResolvedType)type), "File");
            }
            String elementTypeName = this.nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType));
            return new ModelRef(Collections.containerType((ResolvedType)type), elementTypeName);
        }
        if (Maps.isMapType((ResolvedType)type)) {
            String elementTypeName = this.nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)Maps.mapValueType((ResolvedType)type)));
            return new ModelRef("Map", elementTypeName, true);
        }
        String typeName = this.nameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)type));
        return new ModelRef(typeName);
    }
}

