/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spring.web.paths.Paths;

public class SpringGroupingStrategy
implements ResourceGroupingStrategy {
    public Set<ResourceGroup> getResourceGroups(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.groups(handlerMethod);
    }

    public String getResourceDescription(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return this.getDescription(handlerMethod.getBeanType());
    }

    public Integer getResourcePosition(RequestMappingInfo requestMappingInfo, HandlerMethod handlerMethod) {
        return 0;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private Set<ResourceGroup> groups(HandlerMethod handlerMethod) {
        Class controllerClass = handlerMethod.getBeanType();
        String defaultGroup = String.format("%s", Paths.splitCamelCase(controllerClass.getSimpleName(), "-"));
        Optional requestMapping = Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)controllerClass, RequestMapping.class));
        if (requestMapping.isPresent()) {
            HashSet groups = Sets.newHashSet();
            FluentIterable groupNames = FluentIterable.from(Arrays.asList(((RequestMapping)requestMapping.get()).value())).filter(this.notNullOrEmpty());
            for (String each : groupNames) {
                String groupName = Paths.maybeChompLeadingSlash(Paths.firstPathSegment(each));
                groups.add(new ResourceGroup(groupName, handlerMethod.getBeanType()));
            }
            if (groups.size() > 0) {
                return groups;
            }
        }
        return Sets.newHashSet((Object[])new ResourceGroup[]{new ResourceGroup(Paths.maybeChompLeadingSlash(defaultGroup.toLowerCase()), handlerMethod.getBeanType())});
    }

    private Predicate<String> notNullOrEmpty() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isNullOrEmpty((String)input);
            }
        };
    }

    private String getDescription(Class<?> controllerClass) {
        return Paths.splitCamelCase(controllerClass.getSimpleName(), " ");
    }
}

