/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.readers.operation.ApiOperationReader;

public class OperationsKeyGenerator
implements KeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(OperationsKeyGenerator.class);
    public static final String OPERATION_KEY_SPEL = "T(springfox.documentation.spring.web.OperationsKeyGenerator).operationKey(#outerContext)";

    public static String operationKey(RequestMappingContext context) {
        return new OperationsKeyGenerator().generate(ApiOperationReader.class, null, context).toString();
    }

    public Object generate(Object target, Method method, Object ... params) {
        Optional context = FluentIterable.from((Iterable)Lists.newArrayList((Object[])params)).filter(RequestMappingContext.class).first();
        if (context.isPresent()) {
            String key = String.format("%s.%s.%s", ((RequestMappingContext)context.get()).getRequestMappingPattern(), ((RequestMappingContext)context.get()).getHandlerMethod().getMethod().getName(), ((RequestMappingContext)context.get()).getDocumentationContext().getGenericsNamingStrategy().getClass().getSimpleName());
            LOG.info("Cache key generated: {}", (Object)key);
            return key;
        }
        throw new IllegalArgumentException("Key generator can only be used where the first Parameter is of type RequestMappingContext");
    }
}

