/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.DocumentationBuilder;
import springfox.documentation.builders.ResourceListingBuilder;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanResult;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;

@Component
public class ApiDocumentationScanner {
    private ApiListingReferenceScanner apiListingReferenceScanner;
    private ApiListingScanner apiListingScanner;

    @Autowired
    public ApiDocumentationScanner(ApiListingReferenceScanner apiListingReferenceScanner, ApiListingScanner apiListingScanner) {
        this.apiListingReferenceScanner = apiListingReferenceScanner;
        this.apiListingScanner = apiListingScanner;
    }

    public Documentation scan(DocumentationContext context) {
        ApiListingReferenceScanResult result = this.apiListingReferenceScanner.scan(context);
        List<ApiListingReference> apiListingReferences = result.getApiListingReferences();
        ApiListingScanningContext listingContext = new ApiListingScanningContext(context, result.getResourceGroupRequestMappings());
        Multimap<String, ApiListing> apiListings = this.apiListingScanner.scan(listingContext);
        DocumentationBuilder group = new DocumentationBuilder().name(context.getGroupName()).apiListingsByResourceGroupName(apiListings).produces(context.getProduces()).consumes(context.getConsumes()).schemes(context.getProtocols()).basePath(context.getPathProvider().getApplicationBasePath()).tags(this.toTags(apiListings));
        TreeSet apiReferenceSet = Sets.newTreeSet((Comparator)Orderings.listingReferencePathComparator());
        apiReferenceSet.addAll(apiListingReferences);
        ResourceListing resourceListing = new ResourceListingBuilder().apiVersion(context.getApiInfo().getVersion()).apis((List)FluentIterable.from((Iterable)apiReferenceSet).toSortedList((Comparator)context.getListingReferenceOrdering())).securitySchemes(context.getSecuritySchemes()).info(context.getApiInfo()).build();
        group.resourceListing(resourceListing);
        return group.build();
    }

    private Set<Tag> toTags(Multimap<String, ApiListing> apiListings) {
        ImmutableList tags = FluentIterable.from((Iterable)BuilderDefaults.nullToEmptyMultimap(apiListings).entries()).transform(this.fromEntry()).toList();
        TreeSet tagSet = Sets.newTreeSet(this.byTagName());
        tagSet.addAll(tags);
        return tagSet;
    }

    private Comparator<Tag> byTagName() {
        return new Comparator<Tag>(){

            @Override
            public int compare(Tag first, Tag second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }

    private Function<Map.Entry<String, ApiListing>, Tag> fromEntry() {
        return new Function<Map.Entry<String, ApiListing>, Tag>(){

            public Tag apply(Map.Entry<String, ApiListing> input) {
                return new Tag(input.getKey(), input.getValue().getDescription());
            }
        };
    }
}

