/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.web.plugins.CombinedRequestHandler;

class SpringDataRestRequestHandler
implements RequestHandler {
    private final EntityContext entityContext;
    private final ActionSpecification actionSpecification;

    SpringDataRestRequestHandler(EntityContext entityContext, ActionSpecification actionSpecification) {
        this.entityContext = entityContext;
        this.actionSpecification = actionSpecification;
    }

    public Class<?> declaringClass() {
        return (Class)this.actionSpecification.getDeclaringClass().orNull();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.findAnnotation(annotation).isPresent();
    }

    public PatternsRequestCondition getPatternsCondition() {
        return new PatternsRequestCondition(new String[]{this.actionSpecification.getPath()});
    }

    public String groupName() {
        return String.format("%s Entity", this.entityContext.getName());
    }

    public String getName() {
        return this.actionSpecification.getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return ImmutableSet.copyOf(this.actionSpecification.getSupportedMethods());
    }

    public Set<? extends MediaType> produces() {
        return this.actionSpecification.getProduces();
    }

    public Set<? extends MediaType> consumes() {
        return this.actionSpecification.getConsumes();
    }

    public Set<NameValueExpression<String>> headers() {
        return Sets.newHashSet();
    }

    public Set<NameValueExpression<String>> params() {
        return Sets.newHashSet();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        if (this.getHandlerMethod() != null) {
            return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)this.getHandlerMethod().getMethod(), annotation));
        }
        return Optional.absent();
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    public List<ResolvedMethodParameter> getParameters() {
        return new ArrayList<ResolvedMethodParameter>(this.actionSpecification.getParameters());
    }

    public ResolvedType getReturnType() {
        return this.actionSpecification.getReturnType();
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        if (this.getHandlerMethod() != null) {
            return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)this.getHandlerMethod().getBeanType(), annotation));
        }
        return Optional.absent();
    }

    public HandlerMethod getHandlerMethod() {
        return (HandlerMethod)this.actionSpecification.getHandlerMethod().orNull();
    }

    public RequestMappingInfo getRequestMapping() {
        throw new UnsupportedOperationException();
    }

    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler((RequestHandler)this, other);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SpringDataRestRequestHandler{");
        sb.append("key=").append(this.key());
        sb.append('}');
        return sb.toString();
    }
}

