/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.stereotype.Component;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.data.rest.DefaultExtractorConfiguration;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.RequestHandlerExtractorConfiguration;

@Component
class EntityServicesProvider
implements RequestHandlerProvider {
    private final RepositoryRestConfiguration configuration;
    private final ResourceMappings mappings;
    private final Repositories repositories;
    private final TypeResolver typeResolver;
    private final PersistentEntities entities;
    private final Associations associations;
    @Autowired(required=false)
    private RequestHandlerExtractorConfiguration extractorConfiguration;

    @Autowired
    public EntityServicesProvider(RepositoryRestConfiguration configuration, ResourceMappings mappings, Repositories repositories, TypeResolver typeResolver, PersistentEntities entities, Associations associations) {
        this.mappings = mappings;
        this.configuration = configuration;
        this.repositories = repositories;
        this.typeResolver = typeResolver;
        this.entities = entities;
        this.associations = associations;
    }

    @PostConstruct
    public void init() {
        if (this.extractorConfiguration == null) {
            this.extractorConfiguration = new DefaultExtractorConfiguration();
        }
    }

    public List<RequestHandler> requestHandlers() {
        ArrayList contexts = Lists.newArrayList();
        for (Class each : this.repositories) {
            RepositoryInformation repositoryInfo = this.repositories.getRepositoryInformationFor(each);
            Object repositoryInstance = this.repositories.getRepositoryFor(each);
            ResourceMetadata resource = this.mappings.getMetadataFor(each);
            if (!resource.isExported()) continue;
            contexts.add(new EntityContext(this.typeResolver, this.configuration, repositoryInfo, repositoryInstance, resource, this.mappings, this.entities, this.associations, this.extractorConfiguration));
        }
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        for (EntityContext each : contexts) {
            handlers.addAll((Collection<RequestHandler>)FluentIterable.from(this.extractorConfiguration.getEntityExtractors()).transformAndConcat(this.extractFromContext(each)).toList());
        }
        return handlers;
    }

    private Function<EntityOperationsExtractor, List<RequestHandler>> extractFromContext(final EntityContext context) {
        return new Function<EntityOperationsExtractor, List<RequestHandler>>(){

            public List<RequestHandler> apply(EntityOperationsExtractor input) {
                return input.extract(context);
            }
        };
    }
}

