/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.hateoas.Resource;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

class EntitySaveExtractor
implements EntityOperationsExtractor {
    EntitySaveExtractor() {
    }

    @Override
    public List<RequestHandler> extract(EntityContext context) {
        ArrayList handlers = Lists.newArrayList();
        PersistentEntity<?, ?> entity = context.entity();
        CrudMethods crudMethods = context.crudMethods();
        if (crudMethods.hasSaveMethod()) {
            HandlerMethod handler = new HandlerMethod(context.getRepositoryInstance(), crudMethods.getSaveMethod());
            RepositoryMetadata resource = context.getRepositoryMetadata();
            ActionSpecification put = this.saveActionSpecification(entity, Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.PUT, RequestMethod.PATCH}), String.format("%s%s/{id}", context.basePath(), context.resourcePath()), handler, context.getTypeResolver(), resource, Lists.newArrayList((Object[])new ResolvedMethodParameter[]{new ResolvedMethodParameter(0, "id", RequestExtractionUtils.pathAnnotations("id", handler), context.getTypeResolver().resolve((Type)resource.getIdType(), new Type[0])), new ResolvedMethodParameter(0, "body", RequestExtractionUtils.bodyAnnotations(handler), context.getTypeResolver().resolve((Type)resource.getDomainType(), new Type[0]))}));
            handlers.add(new SpringDataRestRequestHandler(context, put));
            ActionSpecification post = this.saveActionSpecification(entity, Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.POST}), String.format("%s%s", context.basePath(), context.resourcePath()), handler, context.getTypeResolver(), resource, Lists.newArrayList((Object[])new ResolvedMethodParameter[]{new ResolvedMethodParameter(0, "body", RequestExtractionUtils.bodyAnnotations(handler), context.getTypeResolver().resolve((Type)resource.getDomainType(), new Type[0]))}));
            handlers.add(new SpringDataRestRequestHandler(context, post));
        }
        return handlers;
    }

    private ActionSpecification saveActionSpecification(PersistentEntity<?, ?> entity, Set<RequestMethod> methods, String path, HandlerMethod handler, TypeResolver typeResolver, RepositoryMetadata repository, List<ResolvedMethodParameter> parameters) {
        return new ActionSpecification(RequestExtractionUtils.actionName(entity, handler.getMethod()), path, methods, new HashSet<MediaType>(), new HashSet<MediaType>(), handler, parameters, typeResolver.resolve(Resource.class, new Type[]{repository.getReturnedDomainClass(handler.getMethod())}));
    }
}

