/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.util.Optional;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483148)
public class PatternAnnotationPlugin
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(PatternAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        Optional<Pattern> pattern = Validators.annotationFromParameter(context, Pattern.class);
        if (pattern.isPresent()) {
            LOG.debug("@Pattern present: {}", (Object)pattern.get().regexp());
            context.parameterBuilder().pattern(pattern.get().regexp());
        }
    }
}

