/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.redis;

import org.springframework.ai.autoconfigure.vectorstore.redis.RedisConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.redis.RedisVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.RedisVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={RedisVectorStore.class, EmbeddingClient.class})
@EnableConfigurationProperties(value={RedisVectorStoreProperties.class})
public class RedisVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionDetails.class})
    public PropertiesRedisConnectionDetails redisConnectionDetails(RedisVectorStoreProperties properties) {
        return new PropertiesRedisConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisVectorStore vectorStore(EmbeddingClient embeddingClient, RedisVectorStoreProperties properties, RedisConnectionDetails redisConnectionDetails) {
        RedisVectorStore.RedisVectorStoreConfig config = RedisVectorStore.RedisVectorStoreConfig.builder().withURI(redisConnectionDetails.getUri()).withIndexName(properties.getIndex()).withPrefix(properties.getPrefix()).build();
        return new RedisVectorStore(config, embeddingClient);
    }

    private static class PropertiesRedisConnectionDetails
    implements RedisConnectionDetails {
        private final RedisVectorStoreProperties properties;

        public PropertiesRedisConnectionDetails(RedisVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getUri() {
            return this.properties.getUri();
        }
    }
}

