/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.elasticsearch;

import org.elasticsearch.client.RestClient;
import org.springframework.ai.autoconfigure.vectorstore.elasticsearch.ElasticsearchVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.ElasticsearchVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnClass(value={ElasticsearchVectorStore.class, EmbeddingClient.class, RestClient.class})
@EnableConfigurationProperties(value={ElasticsearchVectorStoreProperties.class})
class ElasticsearchVectorStoreAutoConfiguration {
    ElasticsearchVectorStoreAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ElasticsearchVectorStore vectorStore(ElasticsearchVectorStoreProperties properties, RestClient restClient, EmbeddingClient embeddingClient) {
        if (StringUtils.hasText((String)properties.getIndexName())) {
            return new ElasticsearchVectorStore(properties.getIndexName(), restClient, embeddingClient);
        }
        return new ElasticsearchVectorStore(restClient, embeddingClient);
    }
}

