/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.qwen;

import org.springframework.ai.autoconfigure.qwen.QWenAiParentProperties;
import org.springframework.ai.qwen.QWenAiChatOptions;
import org.springframework.ai.qwen.api.QWenAiApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.qwen.chat")
public class QWenAiChatProperties
extends QWenAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.qwen.chat";
    public static final String DEFAULT_CHAT_MODEL = QWenAiApi.ChatModel.QWEN_TURBO.getValue();
    private static final Double DEFAULT_TEMPERATURE = 0.7;
    private static final Float DEFAULT_TOP_P = Float.valueOf(1.0f);
    private static final Boolean IS_ENABLED = false;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private QWenAiChatOptions options = QWenAiChatOptions.builder().withModel(DEFAULT_CHAT_MODEL).withTemperature(Float.valueOf(DEFAULT_TEMPERATURE.floatValue())).withSafePrompt(Boolean.valueOf(IS_ENABLED == false)).withTopP(DEFAULT_TOP_P).build();

    public QWenAiChatProperties() {
        super.setBaseUrl("https://dashscope.aliyuncs.com");
    }

    public QWenAiChatOptions getOptions() {
        return this.options;
    }

    public void setOptions(QWenAiChatOptions options) {
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

