/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.openai;

import java.util.List;
import org.springframework.ai.autoconfigure.openai.OpenAiAudioSpeechProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiAudioTranscriptionProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiChatProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiImageProperties;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.openai.OpenAiAudioSpeechClient;
import org.springframework.ai.openai.OpenAiAudioTranscriptionClient;
import org.springframework.ai.openai.OpenAiChatClient;
import org.springframework.ai.openai.OpenAiEmbeddingClient;
import org.springframework.ai.openai.OpenAiImageClient;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={OpenAiApi.class})
@EnableConfigurationProperties(value={OpenAiConnectionProperties.class, OpenAiChatProperties.class, OpenAiEmbeddingProperties.class, OpenAiImageProperties.class, OpenAiAudioTranscriptionProperties.class, OpenAiAudioSpeechProperties.class})
public class OpenAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiChatClient openAiChatClient(OpenAiConnectionProperties commonProperties, OpenAiChatProperties chatProperties, RestClient.Builder restClientBuilder, List<FunctionCallback> toolFunctionCallbacks, FunctionCallbackContext functionCallbackContext, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        OpenAiApi openAiApi = this.openAiApi(chatProperties.getBaseUrl(), commonProperties.getBaseUrl(), chatProperties.getApiKey(), commonProperties.getApiKey(), restClientBuilder, responseErrorHandler);
        if (!CollectionUtils.isEmpty(toolFunctionCallbacks)) {
            chatProperties.getOptions().getFunctionCallbacks().addAll(toolFunctionCallbacks);
        }
        return new OpenAiChatClient(openAiApi, chatProperties.getOptions(), functionCallbackContext, retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiEmbeddingClient openAiEmbeddingClient(OpenAiConnectionProperties commonProperties, OpenAiEmbeddingProperties embeddingProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        OpenAiApi openAiApi = this.openAiApi(embeddingProperties.getBaseUrl(), commonProperties.getBaseUrl(), embeddingProperties.getApiKey(), commonProperties.getApiKey(), restClientBuilder, responseErrorHandler);
        return new OpenAiEmbeddingClient(openAiApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate);
    }

    private OpenAiApi openAiApi(String baseUrl, String commonBaseUrl, String apiKey, String commonApiKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        String resolvedBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonBaseUrl;
        Assert.hasText((String)resolvedBaseUrl, (String)"OpenAI base URL must be set");
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonApiKey;
        Assert.hasText((String)resolvedApiKey, (String)"OpenAI API key must be set");
        return new OpenAiApi(resolvedBaseUrl, resolvedApiKey, restClientBuilder, responseErrorHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiImageClient openAiImageClient(OpenAiConnectionProperties commonProperties, OpenAiImageProperties imageProperties, RestClient.Builder restClientBuilder, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        String apiKey = StringUtils.hasText((String)imageProperties.getApiKey()) ? imageProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)imageProperties.getBaseUrl()) ? imageProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"OpenAI API key must be set");
        Assert.hasText((String)baseUrl, (String)"OpenAI base URL must be set");
        OpenAiImageApi openAiImageApi = new OpenAiImageApi(baseUrl, apiKey, restClientBuilder, responseErrorHandler);
        return new OpenAiImageClient(openAiImageApi, imageProperties.getOptions(), retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenAiAudioTranscriptionClient openAiAudioTranscriptionClient(OpenAiConnectionProperties commonProperties, OpenAiAudioTranscriptionProperties transcriptionProperties, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler) {
        String apiKey = StringUtils.hasText((String)transcriptionProperties.getApiKey()) ? transcriptionProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)transcriptionProperties.getBaseUrl()) ? transcriptionProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"OpenAI API key must be set");
        Assert.hasText((String)baseUrl, (String)"OpenAI base URL must be set");
        OpenAiAudioApi openAiAudioApi = new OpenAiAudioApi(baseUrl, apiKey, RestClient.builder(), responseErrorHandler);
        OpenAiAudioTranscriptionClient openAiChatClient = new OpenAiAudioTranscriptionClient(openAiAudioApi, transcriptionProperties.getOptions(), retryTemplate);
        return openAiChatClient;
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenAiAudioSpeechClient openAiAudioSpeechClient(OpenAiConnectionProperties commonProperties, OpenAiAudioSpeechProperties speechProperties, ResponseErrorHandler responseErrorHandler) {
        String apiKey = StringUtils.hasText((String)speechProperties.getApiKey()) ? speechProperties.getApiKey() : commonProperties.getApiKey();
        String baseUrl = StringUtils.hasText((String)speechProperties.getBaseUrl()) ? speechProperties.getBaseUrl() : commonProperties.getBaseUrl();
        Assert.hasText((String)apiKey, (String)"OpenAI API key must be set");
        Assert.hasText((String)baseUrl, (String)"OpenAI base URL must be set");
        OpenAiAudioApi openAiAudioApi = new OpenAiAudioApi(baseUrl, apiKey, RestClient.builder(), responseErrorHandler);
        OpenAiAudioSpeechClient openAiSpeechClient = new OpenAiAudioSpeechClient(openAiAudioApi, speechProperties.getOptions());
        return openAiSpeechClient;
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackContext springAiFunctionManager(ApplicationContext context) {
        FunctionCallbackContext manager = new FunctionCallbackContext();
        manager.setApplicationContext(context);
        return manager;
    }
}

