/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.file;

import io.spring.nohttp.file.DirScanner;
import io.spring.nohttp.file.FilePredicates;
import io.spring.nohttp.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class PreGradle21Scanner {
    private final File dir;

    private PreGradle21Scanner(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir cannot be null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        this.dir = dir;
    }

    public static PreGradle21Scanner create(File dir) {
        return new PreGradle21Scanner(dir);
    }

    public void scan(Consumer<File> fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("fileProcessor cannot be null");
        }
        List<File> gradleRootDirs = this.findLegacyGradleRootDir(this.dir);
        if (gradleRootDirs.isEmpty()) {
            return;
        }
        for (File gradleRootDir : gradleRootDirs) {
            DirScanner.create(gradleRootDir).excludeFiles(f -> !f.getName().endsWith(".gradle")).scan(fileProcessor);
        }
    }

    private List<File> findLegacyGradleRootDir(File dir) {
        ArrayList<File> gradleRoots = new ArrayList<File>();
        DirScanner.create(dir).excludeFiles(FilePredicates.fileHasName("gradle-wrapper.properties").negate()).excludeFiles(f -> {
            String wrapperText = FileUtils.readTextFrom(f);
            return !wrapperText.contains("/gradle-0.") && !wrapperText.contains("/gradle-1.") && !wrapperText.contains("/gradle-2.0");
        }).scan(gradleWrapperPropertiesFile -> {
            File gradleRootDir = gradleWrapperPropertiesFile.getParentFile().getParentFile().getParentFile();
            gradleRoots.add(gradleRootDir);
        });
        return gradleRoots;
    }
}

