/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaFormatConfig;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpringLeadingWhitespaceCheck
extends AbstractSpringCheck {
    private static final Pattern PATTERN = Pattern.compile("^([\\ \\t]+)\\S");
    private static final Map<IndentationStyle, Pattern> INDENTATION_STYLE_PATTERN;
    private IndentationStyle indentationStyle;
    private final Deque<TextBlockPair> textBlockPairs = new ArrayDeque<TextBlockPair>();

    public int[] getAcceptableTokens() {
        return new int[]{204, 206};
    }

    public void visitToken(DetailAST ast) {
        super.visitToken(ast);
        if (ast.getType() == 204) {
            this.textBlockPairs.add(new TextBlockPair(ast));
        } else if (ast.getType() == 206) {
            this.textBlockPairs.getLast().end(ast);
        }
    }

    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        this.textBlockPairs.clear();
    }

    public void finishTree(DetailAST rootAST) {
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        File file = fileText.getFile();
        if (file == null) {
            return;
        }
        IndentationStyle indentationStyle = this.indentationStyle != null ? this.indentationStyle : JavaFormatConfig.findFrom((File)file.getParentFile()).getIndentationStyle();
        for (int i = 0; i < fileText.size(); ++i) {
            int lineNo = i + 1;
            if (this.isInTextBlock(lineNo)) continue;
            String line = fileText.get(i);
            Matcher matcher = PATTERN.matcher(line);
            boolean found = matcher.find(0);
            while (found && fileContents.hasIntersectionWithComment(lineNo, matcher.start(0), lineNo, matcher.end(0) - 1)) {
                found = matcher.find(matcher.end(0));
            }
            if (!found || INDENTATION_STYLE_PATTERN.get(indentationStyle).matcher(matcher.group(1)).matches()) continue;
            this.log(lineNo, "leadingwhitespace.incorrect", new Object[]{indentationStyle.toString().toLowerCase()});
        }
        super.finishTree(rootAST);
    }

    private boolean isInTextBlock(int lineNo) {
        return this.textBlockPairs.stream().anyMatch(textBlockPair -> textBlockPair.contains(lineNo));
    }

    public void setIndentationStyle(String indentationStyle) {
        this.indentationStyle = indentationStyle != null && !"".equals(indentationStyle) ? IndentationStyle.valueOf((String)indentationStyle.toUpperCase()) : null;
    }

    static {
        HashMap<IndentationStyle, Pattern> indentationStylePatterns = new HashMap<IndentationStyle, Pattern>();
        indentationStylePatterns.put(IndentationStyle.TABS, Pattern.compile("\\t*"));
        indentationStylePatterns.put(IndentationStyle.SPACES, Pattern.compile("\\ *"));
        INDENTATION_STYLE_PATTERN = Collections.unmodifiableMap(indentationStylePatterns);
    }

    private static class TextBlockPair {
        private final DetailAST begin;
        private DetailAST end;

        TextBlockPair(DetailAST begin) {
            this.begin = begin;
        }

        public boolean contains(int lineNo) {
            return lineNo > this.begin.getLineNo() && lineNo <= this.end.getLineNo();
        }

        void end(DetailAST end) {
            this.end = end;
        }
    }
}

