/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.release.SpringReleases;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GetNextSnapshotVersionTask
extends DefaultTask {
    public static final String TASK_NAME = "getNextSnapshotVersion";
    public static final String OUTPUT_VERSION_PATH = "next-snapshot-version.txt";

    @Input
    public abstract Property<String> getVersion();

    @OutputFile
    public abstract RegularFileProperty getNextSnapshotVersionFile();

    @TaskAction
    public void getNextSnapshotVersion() {
        String version = (String)this.getVersion().get();
        String nextVersion = SpringReleases.getNextSnapshotVersion(version);
        RegularFileUtils.writeString((RegularFile)this.getNextSnapshotVersionFile().get(), nextVersion);
        System.out.println(nextVersion);
    }

    public static void register(Project project) {
        project.getTasks().register(TASK_NAME, GetNextSnapshotVersionTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Calculates the next snapshot version based on the current version and outputs the version number");
            task.doNotTrackState("API call to GitHub needs to check for new milestones every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "currentVersion").orElse((Object)project.getRootProject().getVersion().toString());
            task.getVersion().set(versionProvider);
            task.getNextSnapshotVersionFile().set(project.getLayout().getBuildDirectory().file(OUTPUT_VERSION_PATH));
        });
    }
}

