/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GetNextReleaseMilestoneTask
extends DefaultTask {
    public static final String TASK_NAME = "getNextReleaseMilestone";
    public static final String OUTPUT_VERSION_PATH = "next-release-milestone-version.txt";

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getVersion();

    @Input
    @Optional
    public abstract Property<String> getGitHubAccessToken();

    @OutputFile
    public abstract RegularFileProperty getNextReleaseMilestoneFile();

    @TaskAction
    public void getNextReleaseMilestone() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().getOrNull();
        Repository repository = (Repository)this.getRepository().get();
        String version = (String)this.getVersion().get();
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        String nextReleaseMilestone = springReleases.getNextReleaseMilestone(repository.owner(), repository.name(), version);
        RegularFile outputFile = (RegularFile)this.getNextReleaseMilestoneFile().get();
        RegularFileUtils.writeString(outputFile, nextReleaseMilestone);
        System.out.println(nextReleaseMilestone);
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + SpringReleasePluginExtension.class);
        project.getTasks().register(TASK_NAME, GetNextReleaseMilestoneTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Calculates the next release version based on the current version and outputs the version number");
            task.doNotTrackState("API call to GitHub needs to check for new milestones every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "currentVersion").orElse((Object)project.getRootProject().getVersion().toString());
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = (String)springRelease.getRepositoryName().get();
            task.getRepository().set((Object)new Repository(owner, name));
            task.getVersion().set(versionProvider);
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            task.getNextReleaseMilestoneFile().set(project.getLayout().getBuildDirectory().file(OUTPUT_VERSION_PATH));
        });
    }
}

