/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import groovy.util.Node;
import io.spring.gradle.dependencymanagement.internal.DependencyManagement;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.Exclusion;
import io.spring.gradle.dependencymanagement.internal.pom.Coordinates;
import io.spring.gradle.dependencymanagement.internal.pom.Dependency;
import io.spring.gradle.dependencymanagement.internal.pom.Pom;
import io.spring.gradle.dependencymanagement.internal.pom.PomReference;
import io.spring.gradle.dependencymanagement.internal.pom.PomResolver;
import io.spring.gradle.dependencymanagement.internal.properties.ProjectPropertySource;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import io.spring.gradle.dependencymanagement.maven.PomDependencyManagementConfigurer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;

public class StandardPomDependencyManagementConfigurer
implements PomDependencyManagementConfigurer {
    private static final PropertySource EMPTY_PROPERTY_SOURCE = name -> null;
    private static final String NODE_NAME_DEPENDENCY_MANAGEMENT = "dependencyManagement";
    private static final String NODE_NAME_DEPENDENCIES = "dependencies";
    private static final String NODE_NAME_DEPENDENCY = "dependency";
    private static final String NODE_NAME_EXCLUSION = "exclusion";
    private static final String NODE_NAME_GROUP_ID = "groupId";
    private static final String NODE_NAME_ARTIFACT_ID = "artifactId";
    private static final String NODE_NAME_EXCLUSIONS = "exclusions";
    private static final String NODE_NAME_VERSION = "version";
    private static final String NODE_NAME_SCOPE = "scope";
    private static final String NODE_NAME_TYPE = "type";
    private static final String NODE_NAME_CLASSIFIER = "classifier";
    private final DependencyManagement dependencyManagement;
    private final DependencyManagementSettings.PomCustomizationSettings settings;
    private final PomResolver pomResolver;
    private final Project project;

    public StandardPomDependencyManagementConfigurer(DependencyManagement dependencyManagement, DependencyManagementSettings.PomCustomizationSettings settings, PomResolver pomResolver, Project project) {
        this.dependencyManagement = dependencyManagement;
        this.settings = settings;
        this.pomResolver = pomResolver;
        this.project = project;
    }

    @Override
    public void execute(XmlProvider xmlProvider) {
        this.configurePom(xmlProvider.asNode());
    }

    @Override
    public void configurePom(Node pom) {
        if (this.settings.isEnabled()) {
            this.doConfigurePom(pom);
        }
    }

    private void doConfigurePom(Node pom) {
        Node managedDependenciesNode;
        Node dependencyManagementNode = this.findChild(pom, NODE_NAME_DEPENDENCY_MANAGEMENT);
        if (dependencyManagementNode == null) {
            dependencyManagementNode = pom.appendNode((Object)NODE_NAME_DEPENDENCY_MANAGEMENT);
        }
        if ((managedDependenciesNode = this.findChild(dependencyManagementNode, NODE_NAME_DEPENDENCIES)) == null) {
            managedDependenciesNode = dependencyManagementNode.appendNode((Object)NODE_NAME_DEPENDENCIES);
        }
        this.configureBomImports(managedDependenciesNode);
        this.configureManagedDependencies(managedDependenciesNode, this.findChild(pom, NODE_NAME_DEPENDENCIES));
    }

    private Node findChild(Node node, String name) {
        for (Object childObject : node.children()) {
            if (!(childObject instanceof Node) || !((Node)childObject).name().equals(name)) continue;
            return (Node)childObject;
        }
        return null;
    }

    private void configureBomImports(Node dependencies) {
        List<PomReference> bomReferences = this.dependencyManagement.getImportedBomReferences();
        Map<String, Dependency> withoutPropertiesManagedDependencies = this.getManagedDependenciesById(bomReferences, EMPTY_PROPERTY_SOURCE);
        Map<String, Dependency> withPropertiesManagedDependencies = this.getManagedDependenciesById(bomReferences, new ProjectPropertySource(this.project));
        ArrayList<Dependency> overrides = new ArrayList<Dependency>();
        for (Map.Entry<String, Dependency> withPropertyEntry : withPropertiesManagedDependencies.entrySet()) {
            Dependency withoutPropertyDependency = withoutPropertiesManagedDependencies.get(withPropertyEntry.getKey());
            if (!this.differentVersions(withoutPropertyDependency, withPropertyEntry.getValue())) continue;
            overrides.add(withPropertyEntry.getValue());
        }
        for (Dependency override : overrides) {
            this.appendDependencyNode(dependencies, override.getCoordinates(), override.getScope(), override.getType());
        }
        ArrayList<PomReference> importOrderBomReferences = new ArrayList<PomReference>(bomReferences);
        Collections.reverse(importOrderBomReferences);
        for (PomReference bomReference : importOrderBomReferences) {
            this.addImport(dependencies, bomReference);
        }
    }

    private Map<String, Dependency> getManagedDependenciesById(List<PomReference> bomReferences, PropertySource propertySource) {
        HashMap<String, Dependency> managedDependencies = new HashMap<String, Dependency>();
        for (Pom pom : this.pomResolver.resolvePoms(bomReferences, propertySource)) {
            for (Dependency dependency : pom.getManagedDependencies()) {
                managedDependencies.put(this.createId(dependency), dependency);
            }
        }
        return managedDependencies;
    }

    private String createId(Dependency dependency) {
        Coordinates coordinates = dependency.getCoordinates();
        return String.format("%s:%s:%s:%s", coordinates.getGroupAndArtifactId(), dependency.getScope(), dependency.getType(), dependency.getClassifier());
    }

    private boolean differentVersions(Dependency dependency1, Dependency dependency2) {
        String version2;
        if (dependency1 == null) {
            return true;
        }
        String version1 = dependency1.getCoordinates().getVersion();
        return !version1.equals(version2 = dependency2.getCoordinates().getVersion());
    }

    private void addImport(Node dependencies, PomReference importedBom) {
        this.appendDependencyNode(dependencies, importedBom.getCoordinates(), "import", "pom");
    }

    private Node appendDependencyNode(Node parent, Coordinates coordinates, String scope, String type) {
        Node dependencyNode = parent.appendNode((Object)NODE_NAME_DEPENDENCY);
        dependencyNode.appendNode((Object)NODE_NAME_GROUP_ID, (Object)coordinates.getGroupId());
        dependencyNode.appendNode((Object)NODE_NAME_ARTIFACT_ID, (Object)coordinates.getArtifactId());
        dependencyNode.appendNode((Object)NODE_NAME_VERSION, (Object)coordinates.getVersion());
        if (scope != null) {
            dependencyNode.appendNode((Object)NODE_NAME_SCOPE, (Object)scope);
        }
        if (!"jar".equals(type)) {
            dependencyNode.appendNode((Object)NODE_NAME_TYPE, (Object)type);
        }
        return dependencyNode;
    }

    private void configureManagedDependencies(Node managedDependencies, Node dependencies) {
        for (Dependency managedDependency : this.dependencyManagement.getManagedDependencies()) {
            this.addManagedDependency(managedDependencies, managedDependency, null);
            if (dependencies == null) continue;
            for (String classifier : this.findClassifiers(dependencies, managedDependency)) {
                this.addManagedDependency(managedDependencies, managedDependency, classifier);
            }
        }
    }

    private void addManagedDependency(Node managedDependencies, Dependency managedDependency, String classifier) {
        Node dependencyNode = this.appendDependencyNode(managedDependencies, managedDependency.getCoordinates(), managedDependency.getScope(), managedDependency.getType());
        if (!managedDependency.getExclusions().isEmpty()) {
            Node exclusionsNode = dependencyNode.appendNode((Object)NODE_NAME_EXCLUSIONS);
            for (Exclusion exclusion : managedDependency.getExclusions()) {
                Node exclusionNode = exclusionsNode.appendNode((Object)NODE_NAME_EXCLUSION);
                exclusionNode.appendNode((Object)NODE_NAME_GROUP_ID, (Object)exclusion.getGroupId());
                exclusionNode.appendNode((Object)NODE_NAME_ARTIFACT_ID, (Object)exclusion.getArtifactId());
            }
        }
        if (classifier != null) {
            Node classifierNode = dependencyNode.appendNode((Object)NODE_NAME_CLASSIFIER);
            classifierNode.setValue((Object)classifier);
        }
    }

    private List<String> findClassifiers(Node dependencies, Dependency managedDependency) {
        ArrayList<String> classifiers = new ArrayList<String>();
        for (Object child : dependencies.children()) {
            String classifier;
            if (!(child instanceof Node) || !((Node)child).name().equals(NODE_NAME_DEPENDENCY)) continue;
            Node dependency = (Node)child;
            String groupId = this.findTextOfChild(dependency, NODE_NAME_GROUP_ID);
            String artifactId = this.findTextOfChild(dependency, NODE_NAME_ARTIFACT_ID);
            if (!managedDependency.getCoordinates().getGroupId().equals(groupId) || !managedDependency.getCoordinates().getArtifactId().equals(artifactId) || (classifier = this.findTextOfChild(dependency, NODE_NAME_CLASSIFIER)) == null || classifier.length() <= 0) continue;
            classifiers.add(classifier);
        }
        return classifiers;
    }

    private String findTextOfChild(Node node, String name) {
        Node child = this.findChild(node, name);
        return child != null ? child.text() : null;
    }
}

