/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.dsl;

import groovy.lang.Closure;
import io.spring.gradle.dependencymanagement.dsl.DependenciesHandler;
import io.spring.gradle.dependencymanagement.dsl.DependencyHandler;
import io.spring.gradle.dependencymanagement.dsl.DependencySetHandler;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.dsl.ClosureBackedAction;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardDependencyHandler;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardDependencySetHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;

class StandardDependenciesHandler
implements DependenciesHandler {
    private static final String KEY_GROUP = "group";
    private static final String KEY_NAME = "name";
    private static final String KEY_VERSION = "version";
    private final DependencyManagementContainer container;
    private final Configuration configuration;

    StandardDependenciesHandler(DependencyManagementContainer container, Configuration configuration) {
        this.container = container;
        this.configuration = configuration;
    }

    @Override
    public void dependency(String id) {
        this.dependency(id, (Action<DependencyHandler>)((Action)null));
    }

    @Override
    public void dependency(Map<String, String> id) {
        this.dependency(id, (Action<DependencyHandler>)((Action)null));
    }

    @Override
    public void dependency(String id, Closure closure) {
        this.dependency(id, new ClosureBackedAction<DependencyHandler>(closure));
    }

    @Override
    public void dependency(String id, Action<DependencyHandler> action) {
        String[] components = id.split(":");
        if (components.length != 3 || components[0].length() == 0 || components[1].length() == 0 || components[2].length() == 0) {
            throw new InvalidUserDataException("Dependency identifier '" + id + "' is malformed. The required form is 'group:name:version'");
        }
        this.configureDependency(components[0], components[1], components[2], action);
    }

    @Override
    public void dependency(Map<String, String> id, Closure closure) {
        this.dependency(id, new ClosureBackedAction<DependencyHandler>(closure));
    }

    @Override
    public void dependency(Map<String, String> id, Action<DependencyHandler> action) {
        LinkedHashSet<String> missingAttributes = new LinkedHashSet<String>(Arrays.asList(KEY_GROUP, KEY_NAME, KEY_VERSION));
        missingAttributes.removeAll(id.keySet());
        if (!missingAttributes.isEmpty()) {
            throw new InvalidUserDataException("Dependency identifier '" + id + "' did not specify " + this.toCommaSeparatedString(missingAttributes));
        }
        this.configureDependency(this.getAsString(id, KEY_GROUP), this.getAsString(id, KEY_NAME), this.getAsString(id, KEY_VERSION), action);
    }

    @Override
    public void dependencySet(String setId, Closure closure) {
        this.dependencySet(setId, new ClosureBackedAction<DependencySetHandler>(closure));
    }

    @Override
    public void dependencySet(String setId, Action<DependencySetHandler> action) {
        String[] components = setId.split(":");
        if (components.length != 2) {
            throw new InvalidUserDataException("Dependency set identifier '" + setId + "' is malformed. The required  form is 'group:version'");
        }
        this.configureDependencySet(components[0], components[1], action);
    }

    @Override
    public void dependencySet(Map<String, String> setSpecification, Closure closure) {
        this.dependencySet(setSpecification, new ClosureBackedAction<DependencySetHandler>(closure));
    }

    @Override
    public void dependencySet(Map<String, String> setSpecification, Action<DependencySetHandler> action) {
        String group = this.getAsString(setSpecification, KEY_GROUP);
        String version = this.getAsString(setSpecification, KEY_VERSION);
        if (!this.hasText(group) || !this.hasText(version)) {
            throw new GradleException("A dependency set requires both a group and a version");
        }
        this.configureDependencySet(group, version, action);
    }

    private String getAsString(Map<? extends CharSequence, ? extends CharSequence> map, String key) {
        CharSequence charSequence = map.get(key);
        return charSequence == null ? null : charSequence.toString();
    }

    private void configureDependencySet(String group, String version, Action<DependencySetHandler> action) {
        action.execute((Object)new StandardDependencySetHandler(group.toString(), version.toString(), this.container, this.configuration));
    }

    private boolean hasText(String string) {
        return string != null && string.trim().length() > 0;
    }

    private String toCommaSeparatedString(Collection<String> items) {
        StringBuilder output = new StringBuilder();
        for (String item : items) {
            if (output.length() > 0) {
                output.append(", ");
            }
            output.append(item);
        }
        return output.toString();
    }

    private void configureDependency(String group, String name, String version, Action<DependencyHandler> action) {
        StandardDependencyHandler dependencyHandler = new StandardDependencyHandler();
        if (action != null) {
            action.execute((Object)dependencyHandler);
        }
        this.container.addManagedVersion(this.configuration, group, name, version, dependencyHandler.getExclusions());
    }

    public Object propertyMissing(String name) {
        return this.container.getProject().property(name);
    }
}

