/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.apache.maven.model.plugin;

import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.ReportPlugin;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.ReportSet;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Reporting;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblemCollector;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.plugin.ReportConfigurationExpander;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.component.annotations.Component;
import io.spring.gradle.dependencymanagement.org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ReportConfigurationExpander.class)
public class DefaultReportConfigurationExpander
implements ReportConfigurationExpander {
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Reporting reporting = model.getReporting();
        if (reporting != null) {
            for (ReportPlugin reportPlugin : reporting.getPlugins()) {
                Xpp3Dom parentDom = (Xpp3Dom)reportPlugin.getConfiguration();
                if (parentDom == null) continue;
                for (ReportSet execution : reportPlugin.getReportSets()) {
                    Xpp3Dom childDom = (Xpp3Dom)execution.getConfiguration();
                    childDom = Xpp3Dom.mergeXpp3Dom(childDom, new Xpp3Dom(parentDom));
                    execution.setConfiguration(childDom);
                }
            }
        }
    }
}

