/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Repository;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.FileModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.ModelResolver;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.UnresolvableModelException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

class ConfigurationModelResolver
implements ModelResolver {
    private final Project project;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final Map<String, FileModelSource> pomCache = new HashMap<String, FileModelSource>();

    ConfigurationModelResolver(Project project, DependencyManagementConfigurationContainer configurationContainer) {
        this.project = project;
        this.configurationContainer = configurationContainer;
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        String coordinates = groupId + ":" + artifactId + ":" + version + "@pom";
        FileModelSource pom = this.pomCache.get(coordinates);
        if (pom == null) {
            pom = this.resolveModel(coordinates);
            this.pomCache.put(coordinates, pom);
        }
        return pom;
    }

    private FileModelSource resolveModel(String coordinates) {
        Dependency dependency = this.project.getDependencies().create((Object)coordinates);
        Configuration configuration = this.configurationContainer.newConfiguration(dependency);
        return new FileModelSource((File)configuration.resolve().iterator().next());
    }

    @Override
    public void addRepository(Repository repository) {
    }

    @Override
    public ModelResolver newCopy() {
        return this;
    }
}

