/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.maven;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.maven.ConfigurationModelResolver;
import io.spring.gradle.dependencymanagement.internal.maven.PropertiesModelInterpolator;
import io.spring.gradle.dependencymanagement.internal.maven.RelaxedModelValidator;
import io.spring.gradle.dependencymanagement.internal.properties.PropertySource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.Model;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuilder;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuilderFactory;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.DefaultModelBuildingRequest;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.FileModelSource;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingException;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelBuildingResult;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.building.ModelProblem;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.resolution.ModelResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EffectiveModelBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EffectiveModelBuilder.class);
    private final ModelResolver modelResolver;

    EffectiveModelBuilder(Project project, DependencyManagementConfigurationContainer configurationContainer) {
        this.modelResolver = new ConfigurationModelResolver(project, configurationContainer);
    }

    Model buildModel(File pom, PropertySource properties) {
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setSystemProperties(System.getProperties());
        request.setModelSource(new FileModelSource(pom));
        request.setModelResolver(this.modelResolver);
        try {
            ModelBuildingResult result = this.createModelBuilder(properties).build(request);
            List<ModelProblem> errors = this.extractErrors(result.getProblems());
            if (!errors.isEmpty()) {
                this.reportErrors(errors, pom);
            }
            return result.getEffectiveModel();
        }
        catch (ModelBuildingException ex) {
            logger.debug("Model building failed", (Throwable)ex);
            this.reportErrors(this.extractErrors(ex.getProblems()), pom);
            return ex.getResult().getEffectiveModel();
        }
    }

    private List<ModelProblem> extractErrors(List<ModelProblem> problems) {
        ArrayList<ModelProblem> errors = new ArrayList<ModelProblem>();
        for (ModelProblem problem : problems) {
            if (problem.getSeverity() != ModelProblem.Severity.ERROR) continue;
            errors.add(problem);
        }
        return errors;
    }

    private void reportErrors(List<ModelProblem> errors, File file) {
        StringBuilder message = new StringBuilder("Errors occurred while build effective model from " + file + ":");
        for (ModelProblem error : errors) {
            message.append("\n    " + error.getMessage() + " in " + error.getModelId());
        }
        logger.error(message.toString());
    }

    private DefaultModelBuilder createModelBuilder(PropertySource properties) {
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        modelBuilder.setModelInterpolator(new PropertiesModelInterpolator(properties));
        modelBuilder.setModelValidator(new RelaxedModelValidator());
        return modelBuilder;
    }
}

