/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement;

import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.internal.bridge.InternalComponents;
import io.spring.gradle.dependencymanagement.maven.PomDependencyManagementConfigurer;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.tasks.Upload;

public class DependencyManagementPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        InternalComponents internalComponents = new InternalComponents(project);
        DependencyManagementExtension dependencyManagementExtension = internalComponents.getDependencyManagementExtension();
        project.getExtensions().add("dependencyManagement", (Object)dependencyManagementExtension);
        internalComponents.createDependencyManagementReportTask("dependencyManagement");
        project.getConfigurations().all(internalComponents.getImplicitDependencyManagementCollector());
        project.getConfigurations().all(internalComponents.getDependencyManagementApplier());
        this.configurePomCustomization(project, dependencyManagementExtension);
    }

    private void configurePomCustomization(final Project project, DependencyManagementExtension dependencyManagementExtension) {
        final PomDependencyManagementConfigurer pomConfigurer = dependencyManagementExtension.getPomConfigurer();
        if (this.classIsPresent("org.gradle.api.tasks.Upload")) {
            project.getTasks().withType(Upload.class, (Action)new UploadPomConfigurationAction(pomConfigurer));
        }
        project.getPlugins().withType(MavenPublishPlugin.class, (Action)new Action<MavenPublishPlugin>(){

            public void execute(MavenPublishPlugin mavenPublishPlugin) {
                DependencyManagementPlugin.this.configurePublishingExtension(project, pomConfigurer);
            }
        });
    }

    private boolean classIsPresent(String name) {
        try {
            ClassLoader classLoader = DependencyManagementPlugin.class.getClassLoader();
            Class.forName(name, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void configurePublishingExtension(Project project, final PomDependencyManagementConfigurer extension) {
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension publishingExtension) {
                DependencyManagementPlugin.this.configurePublications(publishingExtension, extension);
            }
        });
    }

    private void configurePublications(PublishingExtension publishingExtension, final PomDependencyManagementConfigurer extension) {
        publishingExtension.getPublications().withType(MavenPublication.class, (Action)new Action<MavenPublication>(){

            public void execute(MavenPublication mavenPublication) {
                mavenPublication.getPom().withXml((Action)extension);
            }
        });
    }

    private static final class UploadPomConfigurationAction
    implements Action<Upload> {
        private final PomDependencyManagementConfigurer pomConfigurer;

        private UploadPomConfigurationAction(PomDependencyManagementConfigurer pomConfigurer) {
            this.pomConfigurer = pomConfigurer;
        }

        public void execute(final Upload upload) {
            upload.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    upload.getRepositories().withType(MavenResolver.class, (Action)new Action<MavenResolver>(){

                        public void execute(MavenResolver mavenResolver) {
                            mavenResolver.getPom().withXml((Action)UploadPomConfigurationAction.this.pomConfigurer);
                        }
                    });
                }
            });
        }
    }
}

