/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.org.apache.maven.model;

import io.spring.gradle.dependencymanagement.org.apache.maven.model.InputLocation;
import io.spring.gradle.dependencymanagement.org.apache.maven.model.InputLocationTracker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailingList
implements Serializable,
Cloneable,
InputLocationTracker {
    private String name;
    private String subscribe;
    private String unsubscribe;
    private String post;
    private String archive;
    private List<String> otherArchives;
    private Map<Object, InputLocation> locations;

    public void addOtherArchive(String string) {
        this.getOtherArchives().add(string);
    }

    public MailingList clone() {
        try {
            MailingList copy = (MailingList)super.clone();
            if (this.otherArchives != null) {
                copy.otherArchives = new ArrayList<String>();
                copy.otherArchives.addAll(this.otherArchives);
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArchive() {
        return this.archive;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOtherArchives() {
        if (this.otherArchives == null) {
            this.otherArchives = new ArrayList<String>();
        }
        return this.otherArchives;
    }

    public String getPost() {
        return this.post;
    }

    public String getSubscribe() {
        return this.subscribe;
    }

    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    public void removeOtherArchive(String string) {
        this.getOtherArchives().remove(string);
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOtherArchives(List<String> otherArchives) {
        this.otherArchives = otherArchives;
    }

    public void setPost(String post) {
        this.post = post;
    }

    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    public void setUnsubscribe(String unsubscribe) {
        this.unsubscribe = unsubscribe;
    }
}

