/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import split.org.apache.hc.client5.http.HttpRoute;
import split.org.apache.hc.client5.http.classic.BackoffManager;
import split.org.apache.hc.client5.http.classic.ConnectionBackoffStrategy;
import split.org.apache.hc.client5.http.classic.ExecChain;
import split.org.apache.hc.client5.http.classic.ExecChainHandler;
import split.org.apache.hc.core5.annotation.Contract;
import split.org.apache.hc.core5.annotation.Experimental;
import split.org.apache.hc.core5.annotation.ThreadingBehavior;
import split.org.apache.hc.core5.http.ClassicHttpRequest;
import split.org.apache.hc.core5.http.ClassicHttpResponse;
import split.org.apache.hc.core5.http.HttpException;
import split.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
@Experimental
public final class BackoffStrategyExec
implements ExecChainHandler {
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpResponse response;
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        HttpRoute route = scope.route;
        try {
            response = chain.proceed(request, scope);
        }
        catch (IOException | HttpException ex) {
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                this.backoffManager.backOff(route);
            }
            throw ex;
        }
        if (this.connectionBackoffStrategy.shouldBackoff(response)) {
            this.backoffManager.backOff(route);
        } else {
            this.backoffManager.probe(route);
        }
        return response;
    }
}

