/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.adapters;

import io.split.client.dtos.KeyImpression;
import io.split.client.dtos.Metadata;
import io.split.client.impressions.ImpressionsStorageProducer;
import io.split.storages.pluggable.domain.ImpressionConsumer;
import io.split.storages.pluggable.domain.PrefixAdapter;
import io.split.storages.pluggable.domain.SafeUserStorageWrapper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import pluggable.CustomStorageWrapper;
import split.com.google.common.base.Preconditions;
import split.com.google.gson.Gson;
import split.com.google.gson.GsonBuilder;
import split.com.google.gson.JsonPrimitive;

public class UserCustomImpressionAdapterProducer
implements ImpressionsStorageProducer {
    private final SafeUserStorageWrapper _safeUserStorageWrapper;
    private final Gson _json = new GsonBuilder().serializeNulls().excludeFieldsWithModifiers(8).registerTypeAdapter((Type)((Object)Double.class), (src, typeOfSrc, context) -> {
        if (src == (double)src.longValue()) {
            return new JsonPrimitive(src.longValue());
        }
        return new JsonPrimitive((Number)src);
    }).create();
    private Metadata _metadata;

    public UserCustomImpressionAdapterProducer(CustomStorageWrapper customStorageWrapper, Metadata metadata) {
        this._safeUserStorageWrapper = new SafeUserStorageWrapper(Preconditions.checkNotNull(customStorageWrapper));
        this._metadata = metadata;
    }

    @Override
    public long put(List<KeyImpression> imps) {
        List<String> impressions = imps.stream().map(keyImp -> this._json.toJson(new ImpressionConsumer(this._metadata, (KeyImpression)keyImp))).collect(Collectors.toList());
        return this._safeUserStorageWrapper.pushItems(PrefixAdapter.buildImpressions(), impressions);
    }
}

