/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.workers;

import io.split.engine.common.Synchronizer;
import io.split.engine.sse.workers.SplitsWorker;
import io.split.engine.sse.workers.Worker;
import split.com.google.common.base.Preconditions;

public class SplitsWorkerImp
extends Worker<Long>
implements SplitsWorker {
    private final Synchronizer _synchronizer;

    public SplitsWorkerImp(Synchronizer synchronizer) {
        super("Splits");
        this._synchronizer = Preconditions.checkNotNull(synchronizer);
    }

    @Override
    public void killSplit(long changeNumber, String splitName, String defaultTreatment) {
        try {
            this._synchronizer.localKillSplit(splitName, defaultTreatment, changeNumber);
            _log.debug(String.format("Kill split: %s, changeNumber: %s, defaultTreatment: %s", splitName, changeNumber, defaultTreatment));
        }
        catch (Exception ex) {
            _log.warn(String.format("Exception on SplitWorker killSplit: %s", ex.getMessage()));
        }
    }

    @Override
    protected void executeRefresh(Long changeNumber) {
        this._synchronizer.refreshSplits(changeNumber);
    }
}

