/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.matchers.Matcher;
import java.util.Map;
import split.com.google.common.base.Preconditions;

public class UserDefinedSegmentMatcher
implements Matcher {
    private final String _segmentName;

    public UserDefinedSegmentMatcher(String segmentName) {
        this._segmentName = Preconditions.checkNotNull(segmentName);
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        if (!(matchValue instanceof String)) {
            return false;
        }
        return evaluationContext.getSegmentCache().isInSegment(this._segmentName, (String)matchValue);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._segmentName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserDefinedSegmentMatcher)) {
            return false;
        }
        UserDefinedSegmentMatcher other = (UserDefinedSegmentMatcher)obj;
        return this._segmentName.equals(other._segmentName);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in segment ");
        bldr.append(this._segmentName);
        return bldr.toString();
    }

    public String getSegmentName() {
        return this._segmentName;
    }
}

