/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKReadinessGates {
    private static final Logger _log = LoggerFactory.getLogger(SDKReadinessGates.class);
    private final CountDownLatch _internalReady = new CountDownLatch(1);

    public boolean waitUntilInternalReady(long milliseconds) throws InterruptedException {
        return this._internalReady.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    public boolean isSDKReady() {
        return this._internalReady.getCount() == 0L;
    }

    public void sdkInternalReady() {
        this._internalReady.countDown();
    }
}

