/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionListener;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class AsynchronousImpressionListener
implements ImpressionListener {
    private static final Logger _log = LoggerFactory.getLogger(AsynchronousImpressionListener.class);
    private final ImpressionListener _delegate;
    private final ExecutorService _executor;

    public static AsynchronousImpressionListener build(ImpressionListener delegate, int capacity) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("impression-listener-wrapper-%d").build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(capacity), threadFactory);
        return new AsynchronousImpressionListener(delegate, executor);
    }

    public AsynchronousImpressionListener(ImpressionListener delegate, ExecutorService executor) {
        this._delegate = delegate;
        this._executor = executor;
    }

    @Override
    public void log(Impression impression) {
        try {
            this._executor.execute(() -> this._delegate.log(impression));
        }
        catch (Exception e) {
            _log.warn("Unable to send impression to impression listener", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this._executor.shutdown();
            this._delegate.close();
        }
        catch (Exception e) {
            _log.warn("Unable to close AsynchronousImpressionListener", (Throwable)e);
        }
    }
}

