/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.dtos;

import io.split.client.impressions.ImpressionCounter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import split.com.google.gson.annotations.SerializedName;

public class ImpressionCount {
    private static final String FIELD_PER_FEATURE_COUNTS = "pf";
    @SerializedName(value="pf")
    public final List<CountPerFeature> perFeature;

    public ImpressionCount(List<CountPerFeature> cs) {
        this.perFeature = cs;
    }

    public static ImpressionCount fromImpressionCounterData(Map<ImpressionCounter.Key, Integer> raw) {
        return new ImpressionCount(raw.entrySet().stream().map(e -> new CountPerFeature(((ImpressionCounter.Key)e.getKey()).featureName(), ((ImpressionCounter.Key)e.getKey()).timeFrame(), (Integer)e.getValue())).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(this.perFeature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImpressionCount c = (ImpressionCount)o;
        return Objects.equals(this.perFeature, c.perFeature);
    }

    public static class CountPerFeature {
        private static final String FIELD_FEATURE = "f";
        private static final String FIELD_TIMEFRAME = "m";
        private static final String FIELD_COUNT = "rc";
        @SerializedName(value="f")
        public final String feature;
        @SerializedName(value="m")
        public final long timeframe;
        @SerializedName(value="rc")
        public final int count;

        public CountPerFeature(String f, long t, int c) {
            this.feature = f;
            this.timeframe = t;
            this.count = c;
        }

        public int hashCode() {
            return Objects.hash(this.feature, this.timeframe, this.count);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountPerFeature c = (CountPerFeature)o;
            return Objects.equals(this.feature, c.feature) && Objects.equals(this.timeframe, c.timeframe) && Objects.equals(this.count, c.count);
        }
    }
}

