/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.v2;

import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager;
import com.netflix.spinnaker.kork.plugins.SpringPluginStatusProvider;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.kork.plugins.api.spring.PrivilegedSpringPlugin;
import com.netflix.spinnaker.kork.plugins.events.ExtensionCreated;
import com.netflix.spinnaker.kork.plugins.proxy.LazyExtensionInvocationProxy;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect;
import com.netflix.spinnaker.kork.plugins.update.SpinnakerUpdateManager;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.provider.PluginInfoReleaseProvider;
import com.netflix.spinnaker.kork.plugins.v2.DslKt;
import com.netflix.spinnaker.kork.plugins.v2.PluginContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Plugin;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/kork/plugins/v2/SpinnakerPluginService;", "", "pluginManager", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "updateManager", "Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;", "pluginInfoReleaseProvider", "Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;", "springPluginStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;", "invocationAspects", "", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationAspect;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;Ljava/util/List;Lorg/springframework/context/ApplicationEventPublisher;)V", "initialized", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "initialize", "", "registerProxies", "container", "Lcom/netflix/spinnaker/kork/plugins/v2/PluginContainer;", "registry", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;", "initializerBeanName", "", "startPlugins", "withTiming", "task", "callback", "Lkotlin/Function0;", "kork-plugins"})
public final class SpinnakerPluginService {
    private final Logger log;
    private boolean initialized;
    private final SpinnakerPluginManager pluginManager;
    private final SpinnakerUpdateManager updateManager;
    private final PluginInfoReleaseProvider pluginInfoReleaseProvider;
    private final SpringPluginStatusProvider springPluginStatusProvider;
    private final List<InvocationAspect<?>> invocationAspects;
    private final ApplicationEventPublisher applicationEventPublisher;

    public final void initialize() {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"Plugin framework has already been initialized");
        this.withTiming("initializing plugins", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SpinnakerPluginService this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$filterTo$iv$iv;
                SpinnakerPluginService.access$getPluginManager$p(this.this$0).loadPlugins();
                Iterable $this$filter$iv = SpinnakerPluginService.access$getUpdateManager$p(this.this$0).getPlugins();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    SpinnakerPluginInfo it = (SpinnakerPluginInfo)((Object)element$iv$iv);
                    boolean bl = false;
                    SpringPluginStatusProvider springPluginStatusProvider = SpinnakerPluginService.access$getSpringPluginStatusProvider$p(this.this$0);
                    String string = it.id;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
                    if (!springPluginStatusProvider.isPluginEnabled(string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                boolean bl = false;
                Iterable enabledPlugins = $this$filter$iv;
                boolean bl2 = false;
                Set<PluginInfoRelease> releases = SpinnakerPluginService.access$getPluginInfoReleaseProvider$p(this.this$0).getReleases((List<SpinnakerPluginInfo>)enabledPlugins);
                Iterable $this$forEach$iv = SpinnakerPluginService.access$getUpdateManager$p(this.this$0).downloadPluginReleases$kork_plugins(releases);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Path pluginPath = (Path)element$iv;
                    boolean bl3 = false;
                    SpinnakerPluginService.access$getPluginManager$p(this.this$0).loadPlugin(pluginPath);
                }
            }
            {
                this.this$0 = spinnakerPluginService;
                super(0);
            }
        }));
    }

    public final void startPlugins(@NotNull BeanDefinitionRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.withTiming("starting plugins", (Function0<Unit>)((Function0)new Function0<Unit>(this, registry){
            final /* synthetic */ SpinnakerPluginService this$0;
            final /* synthetic */ BeanDefinitionRegistry $registry;

            public final void invoke() {
                SpinnakerPluginService.access$getPluginManager$p(this.this$0).startPlugins();
                List list = SpinnakerPluginService.access$getPluginManager$p(this.this$0).getStartedPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pluginManager.startedPlugins");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PluginWrapper pluginWrapper = (PluginWrapper)element$iv;
                    boolean bl = false;
                    PluginWrapper pluginWrapper2 = pluginWrapper;
                    Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper2, (String)"pluginWrapper");
                    Plugin p = pluginWrapper2.getPlugin();
                    if (p instanceof PrivilegedSpringPlugin) {
                        ((PrivilegedSpringPlugin)p).registerBeanDefinitions(this.$registry);
                    }
                    if (!(p instanceof PluginContainer)) continue;
                    String initializerBeanName = ((PluginContainer)p).registerInitializer(this.$registry);
                    SpinnakerPluginService.access$registerProxies(this.this$0, (PluginContainer)p, this.$registry, initializerBeanName);
                }
            }
            {
                this.this$0 = spinnakerPluginService;
                this.$registry = beanDefinitionRegistry;
                super(0);
            }
        }));
    }

    private final void registerProxies(PluginContainer container, BeanDefinitionRegistry registry, String initializerBeanName) {
        GenericApplicationContext pluginContext = container.getPluginContext$kork_plugins();
        PluginWrapper pluginWrapper = container.getWrapper();
        Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper, (String)"container.wrapper");
        PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"container.wrapper.descriptor");
        String pluginId = pluginDescriptor.getPluginId();
        ClassPathScanningCandidateComponentProvider classPathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        boolean bl = false;
        boolean bl2 = false;
        ClassPathScanningCandidateComponentProvider $this$apply = classPathScanningCandidateComponentProvider;
        boolean bl3 = false;
        $this$apply.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SpinnakerExtensionPoint.class));
        PluginWrapper pluginWrapper2 = container.getWrapper();
        Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper2, (String)"container.wrapper");
        $this$apply.setResourceLoader((ResourceLoader)new DefaultResourceLoader(pluginWrapper2.getPluginClassLoader()));
        Set set = classPathScanningCandidateComponentProvider.findCandidateComponents(DslKt.getBasePackageName(container.getActual()));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ClassPathScanningCandida\u2026r.actual.basePackageName)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class<?> extensionBeanClass;
            BeanDefinition extensionBeanDefinition = (BeanDefinition)element$iv;
            boolean bl4 = false;
            PluginWrapper pluginWrapper3 = container.getWrapper();
            Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper3, (String)"container.wrapper");
            ClassLoader classLoader = pluginWrapper3.getPluginClassLoader();
            BeanDefinition beanDefinition = extensionBeanDefinition;
            Intrinsics.checkNotNullExpressionValue((Object)beanDefinition, (String)"extensionBeanDefinition");
            if (classLoader.loadClass(beanDefinition.getBeanClassName()) == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint>");
            }
            String pluginContextBeanName = AnnotationBeanNameGenerator.INSTANCE.generateBeanName(extensionBeanDefinition, (BeanDefinitionRegistry)pluginContext);
            Lazy lazy = LazyKt.lazy((Function0)((Function0)new Function0<SpinnakerExtensionPoint>(pluginContextBeanName, this, container, pluginContext, initializerBeanName, pluginId, registry){
                final /* synthetic */ String $pluginContextBeanName;
                final /* synthetic */ SpinnakerPluginService this$0;
                final /* synthetic */ PluginContainer $container$inlined;
                final /* synthetic */ GenericApplicationContext $pluginContext$inlined;
                final /* synthetic */ String $initializerBeanName$inlined;
                final /* synthetic */ String $pluginId$inlined;
                final /* synthetic */ BeanDefinitionRegistry $registry$inlined;
                {
                    this.$pluginContextBeanName = string;
                    this.this$0 = spinnakerPluginService;
                    this.$container$inlined = pluginContainer;
                    this.$pluginContext$inlined = genericApplicationContext;
                    this.$initializerBeanName$inlined = string2;
                    this.$pluginId$inlined = string3;
                    this.$registry$inlined = beanDefinitionRegistry;
                    super(0);
                }

                @NotNull
                public final SpinnakerExtensionPoint invoke() {
                    block5: {
                        block4: {
                            ApplicationContext applicationContext = this.$pluginContext$inlined.getParent();
                            if (applicationContext == null) break block4;
                            ApplicationContext applicationContext2 = applicationContext;
                            boolean bl = false;
                            boolean bl2 = false;
                            ApplicationContext it = applicationContext2;
                            boolean bl3 = false;
                            it.getBean(this.$initializerBeanName$inlined);
                            applicationContext = applicationContext2;
                            if (applicationContext != null) break block5;
                        }
                        throw (Throwable)new IllegalStateException("Plugin context for \"" + this.$pluginId$inlined + "\" was not configured with a parent context");
                    }
                    Object object = this.$pluginContext$inlined.getBean(this.$pluginContextBeanName);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint");
                    }
                    return (SpinnakerExtensionPoint)object;
                }
            }));
            List<InvocationAspect<?>> list = this.invocationAspects;
            if (list == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect<com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationState>>");
            }
            PluginWrapper pluginWrapper4 = container.getWrapper();
            Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper4, (String)"container.wrapper");
            PluginDescriptor pluginDescriptor2 = pluginWrapper4.getDescriptor();
            if (pluginDescriptor2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor");
            }
            Object proxy = LazyExtensionInvocationProxy.Companion.proxy((Lazy<? extends SpinnakerExtensionPoint>)lazy, extensionBeanClass, list, (SpinnakerPluginDescriptor)pluginDescriptor2);
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition();
            Intrinsics.checkNotNullExpressionValue((Object)beanDefinitionBuilder, (String)"BeanDefinitionBuilder.genericBeanDefinition()");
            AbstractBeanDefinition abstractBeanDefinition = beanDefinitionBuilder.getBeanDefinition();
            boolean bl5 = false;
            boolean bl6 = false;
            AbstractBeanDefinition $this$apply2 = abstractBeanDefinition;
            boolean bl7 = false;
            $this$apply2.setInstanceSupplier((Supplier)new Supplier<Object>(proxy, extensionBeanClass){
                final /* synthetic */ Object $proxy$inlined;
                final /* synthetic */ Class $extensionBeanClass$inlined;
                {
                    this.$proxy$inlined = object;
                    this.$extensionBeanClass$inlined = clazz;
                }

                @NotNull
                public final Object get() {
                    return this.$proxy$inlined;
                }
            });
            $this$apply2.setBeanClass(extensionBeanClass);
            AbstractBeanDefinition proxyBeanDefinition = abstractBeanDefinition;
            StringBuilder stringBuilder = new StringBuilder().append(pluginId).append('_');
            String string = extensionBeanClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionBeanClass.simpleName");
            registry.registerBeanDefinition(stringBuilder.append(StringsKt.decapitalize((String)string)).toString(), (BeanDefinition)proxyBeanDefinition);
            String string2 = pluginContextBeanName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluginContextBeanName");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ExtensionCreated(this, string2, proxy, extensionBeanClass));
        }
    }

    private final void withTiming(String task, Function0<Unit> callback) {
        long start = System.currentTimeMillis();
        this.log.debug(StringsKt.capitalize((String)task));
        callback.invoke();
        this.log.debug("Finished " + task + " in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    public SpinnakerPluginService(@NotNull SpinnakerPluginManager pluginManager, @NotNull SpinnakerUpdateManager updateManager, @NotNull PluginInfoReleaseProvider pluginInfoReleaseProvider, @NotNull SpringPluginStatusProvider springPluginStatusProvider, @NotNull List<? extends InvocationAspect<?>> invocationAspects, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginManager), (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)((Object)updateManager), (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)pluginInfoReleaseProvider, (String)"pluginInfoReleaseProvider");
        Intrinsics.checkNotNullParameter((Object)springPluginStatusProvider, (String)"springPluginStatusProvider");
        Intrinsics.checkNotNullParameter(invocationAspects, (String)"invocationAspects");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.pluginManager = pluginManager;
        this.updateManager = updateManager;
        this.pluginInfoReleaseProvider = pluginInfoReleaseProvider;
        this.springPluginStatusProvider = springPluginStatusProvider;
        this.invocationAspects = invocationAspects;
        this.applicationEventPublisher = applicationEventPublisher;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ SpinnakerPluginManager access$getPluginManager$p(SpinnakerPluginService $this) {
        return $this.pluginManager;
    }

    public static final /* synthetic */ SpinnakerUpdateManager access$getUpdateManager$p(SpinnakerPluginService $this) {
        return $this.updateManager;
    }

    public static final /* synthetic */ SpringPluginStatusProvider access$getSpringPluginStatusProvider$p(SpinnakerPluginService $this) {
        return $this.springPluginStatusProvider;
    }

    public static final /* synthetic */ PluginInfoReleaseProvider access$getPluginInfoReleaseProvider$p(SpinnakerPluginService $this) {
        return $this.pluginInfoReleaseProvider;
    }

    public static final /* synthetic */ void access$registerProxies(SpinnakerPluginService $this, PluginContainer container, BeanDefinitionRegistry registry, String initializerBeanName) {
        $this.registerProxies(container, registry, initializerBeanName);
    }
}

