/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.release.source;

import com.netflix.spinnaker.kork.plugins.update.ServerGroupLocationResolver;
import com.netflix.spinnaker.kork.plugins.update.ServerGroupNameResolver;
import com.netflix.spinnaker.kork.plugins.update.internal.Front50Service;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.source.PluginInfoReleaseSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001e*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J*\u0010\u001f\u001a\u00020\u001b*\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020 0\u001ej\u0002`!2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/release/source/Front50PluginInfoReleaseSource;", "Lcom/netflix/spinnaker/kork/plugins/update/release/source/PluginInfoReleaseSource;", "front50Service", "Lcom/netflix/spinnaker/kork/plugins/update/internal/Front50Service;", "serverGroupNameResolver", "Lcom/netflix/spinnaker/kork/plugins/update/ServerGroupNameResolver;", "serverGroupLocationResolver", "Lcom/netflix/spinnaker/kork/plugins/update/ServerGroupLocationResolver;", "serviceName", "", "(Lcom/netflix/spinnaker/kork/plugins/update/internal/Front50Service;Lcom/netflix/spinnaker/kork/plugins/update/ServerGroupNameResolver;Lcom/netflix/spinnaker/kork/plugins/update/ServerGroupLocationResolver;Ljava/lang/String;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getOrder", "", "getReleases", "", "Lcom/netflix/spinnaker/kork/plugins/update/release/PluginInfoRelease;", "pluginInfo", "", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo;", "processReleases", "", "pluginInfoReleases", "toVersionMap", "", "updateReleases", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo$SpinnakerPluginRelease;", "Lcom/netflix/spinnaker/kork/plugins/update/internal/PinnedVersions;", "kork-plugins"})
public final class Front50PluginInfoReleaseSource
implements PluginInfoReleaseSource {
    private final Lazy log$delegate;
    private final Front50Service front50Service;
    private final ServerGroupNameResolver serverGroupNameResolver;
    private final ServerGroupLocationResolver serverGroupLocationResolver;
    private final String serviceName;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Front50PluginInfoReleaseSource front50PluginInfoReleaseSource = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<PluginInfoRelease> getReleases(@NotNull List<SpinnakerPluginInfo> pluginInfo) {
        Intrinsics.checkNotNullParameter(pluginInfo, (String)"pluginInfo");
        boolean bl = false;
        return new LinkedHashSet();
    }

    @Override
    public void processReleases(@NotNull Set<PluginInfoRelease> pluginInfoReleases) {
        block5: {
            Response response2;
            Response response3;
            Intrinsics.checkNotNullParameter(pluginInfoReleases, (String)"pluginInfoReleases");
            String serverGroupName = (String)this.serverGroupNameResolver.get();
            if (serverGroupName == null) {
                this.getLog().warn("Could not resolve server group name: Skipping front50 plugin version resolution");
                return;
            }
            String serverGroupLocation = (String)this.serverGroupLocationResolver.get();
            if (serverGroupLocation == null) {
                this.getLog().warn("Could not resolve server group location: Skipping front50 plugin version resolution");
                return;
            }
            try {
                response3 = this.front50Service.pinVersions(serverGroupName, this.serviceName, serverGroupLocation, this.toVersionMap(pluginInfoReleases)).execute();
            }
            catch (IOException e) {
                this.getLog().error("Failed pinning versions in front50, falling back to locally-sourced plugin versions", (Throwable)e);
                return;
            }
            Response response4 = response2 = response3;
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"response");
            if (!response4.isSuccessful()) {
                this.getLog().error("Failed pinning plugin versions in front50, falling back to locally-sourced plugin versions: {}", (Object)response2.message());
                return;
            }
            Map map = (Map)response2.body();
            if (map == null) break block5;
            this.updateReleases(map, pluginInfoReleases);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> toVersionMap(Set<PluginInfoRelease> $this$toVersionMap) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toVersionMap;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginInfoRelease pluginInfoRelease = (PluginInfoRelease)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getPluginId(), (Object)it.getProps().version);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateReleases(Map<String, SpinnakerPluginInfo.SpinnakerPluginRelease> $this$updateReleases, Set<PluginInfoRelease> pluginInfoReleases) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pluginInfoReleases;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Unit unit;
            void it;
            PluginInfoRelease pluginInfoRelease = (PluginInfoRelease)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if ($this$updateReleases.get(it.getPluginId()) != null) {
                SpinnakerPluginInfo.SpinnakerPluginRelease spinnakerPluginRelease;
                boolean bl2 = false;
                boolean bl3 = false;
                SpinnakerPluginInfo.SpinnakerPluginRelease release = spinnakerPluginRelease;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)it.getProps().version, (Object)release.version) ^ true) {
                    this.getLog().info("Aligning plugin '" + it.getPluginId() + "' to pinned version: " + it.getProps().version + " -> " + release.version);
                    it.setProps(release);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
            collection.add(unit2);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Front50PluginInfoReleaseSource(@NotNull Front50Service front50Service, @NotNull ServerGroupNameResolver serverGroupNameResolver, @NotNull ServerGroupLocationResolver serverGroupLocationResolver, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)front50Service, (String)"front50Service");
        Intrinsics.checkNotNullParameter((Object)serverGroupNameResolver, (String)"serverGroupNameResolver");
        Intrinsics.checkNotNullParameter((Object)serverGroupLocationResolver, (String)"serverGroupLocationResolver");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        this.front50Service = front50Service;
        this.serverGroupNameResolver = serverGroupNameResolver;
        this.serverGroupLocationResolver = serverGroupLocationResolver;
        this.serviceName = serviceName;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Front50PluginInfoReleaseSource this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = front50PluginInfoReleaseSource;
                super(0);
            }
        }));
    }
}

