/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.sdk.httpclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClient;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientConfig;
import com.netflix.spinnaker.kork.plugins.api.httpclient.HttpClientRegistry;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.Ok3HttpClient;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.Ok3HttpClientRegistry;
import com.netflix.spinnaker.kork.plugins.sdk.httpclient.OkHttp3ClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0011\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0096\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0016R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00160\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClientRegistry;", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientRegistry;", "pluginId", "", "environment", "Lorg/springframework/core/env/Environment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "okHttp3ClientFactory", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;", "okHttp3ClientConfiguration", "Lcom/netflix/spinnaker/config/OkHttp3ClientConfiguration;", "(Ljava/lang/String;Lorg/springframework/core/env/Environment;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/OkHttp3ClientFactory;Lcom/netflix/spinnaker/config/OkHttp3ClientConfiguration;)V", "clients", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClient;", "getClients$kork_plugins", "()Ljava/util/Map;", "internalServicesClient", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "okClients", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClientConfig;", "getOkClients$kork_plugins", "configure", "", "name", "baseUrl", "config", "findInternalServiceBaseUrl", "get", "Lcom/netflix/spinnaker/kork/plugins/api/httpclient/HttpClient;", "getInternalService", "Companion", "kork-plugins"})
public final class Ok3HttpClientRegistry
implements HttpClientRegistry {
    private final Lazy log$delegate;
    private final OkHttpClient internalServicesClient;
    @NotNull
    private final Map<HttpClientConfig, OkHttpClient> okClients;
    @NotNull
    private final Map<String, Ok3HttpClient> clients;
    private final String pluginId;
    private final Environment environment;
    private final ObjectMapper objectMapper;
    private final OkHttp3ClientFactory okHttp3ClientFactory;
    private static final String serviceNamePlaceholder = "SERVICE_NAME";
    private static final List<String> baseUrlPaths;
    @NotNull
    public static final Companion Companion;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Ok3HttpClientRegistry ok3HttpClientRegistry = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Map<HttpClientConfig, OkHttpClient> getOkClients$kork_plugins() {
        return this.okClients;
    }

    @NotNull
    public final Map<String, Ok3HttpClient> getClients$kork_plugins() {
        return this.clients;
    }

    public void configure(@NotNull String name, @NotNull String baseUrl, @NotNull HttpClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.clients.computeIfAbsent(this.pluginId + '.' + name, new Function<String, Ok3HttpClient>(this, name, config, baseUrl){
            final /* synthetic */ Ok3HttpClientRegistry this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ HttpClientConfig $config;
            final /* synthetic */ String $baseUrl;

            @NotNull
            public final Ok3HttpClient apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Ok3HttpClientRegistry.access$getLog$p(this.this$0).info("Configuring HTTP client for '" + Ok3HttpClientRegistry.access$getPluginId$p(this.this$0) + "' named '" + this.$name + '\'');
                OkHttpClient okHttpClient = this.this$0.getOkClients$kork_plugins().computeIfAbsent(this.$config, new Function<HttpClientConfig, OkHttpClient>(this){
                    final /* synthetic */ configure.1 this$0;

                    @NotNull
                    public final OkHttpClient apply(@NotNull HttpClientConfig it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Ok3HttpClientRegistry.access$getLog$p(this.this$0.this$0).info("No existing OkHttpClient with a matching config requested by '" + Ok3HttpClientRegistry.access$getPluginId$p(this.this$0.this$0) + '.' + this.this$0.$name + "', creating one");
                        return Ok3HttpClientRegistry.access$getOkHttp3ClientFactory$p(this.this$0.this$0).create(this.this$0.$baseUrl, this.this$0.$config);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"okClients.computeIfAbsen\u2026(baseUrl, config)\n      }");
                OkHttpClient okClient2 = okHttpClient;
                return new Ok3HttpClient(Ok3HttpClientRegistry.access$getPluginId$p(this.this$0) + '.' + this.$name, Ok3HttpClientRegistry.access$getOkHttp3ClientFactory$p(this.this$0).normalizeBaseUrl(this.$baseUrl), okClient2, Ok3HttpClientRegistry.access$getObjectMapper$p(this.this$0));
            }
            {
                this.this$0 = ok3HttpClientRegistry;
                this.$name = string;
                this.$config = httpClientConfig;
                this.$baseUrl = string2;
            }
        });
    }

    @NotNull
    public HttpClient get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Ok3HttpClient ok3HttpClient = this.clients.get(this.pluginId + '.' + name);
        if (ok3HttpClient == null) {
            throw (Throwable)new IntegrationException("No client configured for '" + name + '\'');
        }
        return ok3HttpClient;
    }

    @NotNull
    public HttpClient getInternalService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Ok3HttpClient ok3HttpClient = this.clients.computeIfAbsent("internal." + name, new Function<String, Ok3HttpClient>(this, name){
            final /* synthetic */ Ok3HttpClientRegistry this$0;
            final /* synthetic */ String $name;

            @NotNull
            public final Ok3HttpClient apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = "internal." + this.$name;
                String string2 = Ok3HttpClientRegistry.access$findInternalServiceBaseUrl(this.this$0, this.$name);
                OkHttpClient okHttpClient = Ok3HttpClientRegistry.access$getInternalServicesClient$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"internalServicesClient");
                return new Ok3HttpClient(string, string2, okHttpClient, Ok3HttpClientRegistry.access$getObjectMapper$p(this.this$0));
            }
            {
                this.this$0 = ok3HttpClientRegistry;
                this.$name = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)ok3HttpClient, (String)"clients.computeIfAbsent(\u2026ient, objectMapper)\n    }");
        return ok3HttpClient;
    }

    /*
     * WARNING - void declaration
     */
    private final String findInternalServiceBaseUrl(String name) {
        void $this$mapTo$iv$iv;
        String string = name;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String normalized = string3;
        Iterable $this$map$iv = baseUrlPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string4 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string5 = StringsKt.replace$default((String)it, (String)serviceNamePlaceholder, (String)normalized, (boolean)false, (int)4, null);
            collection.add(string5);
        }
        List paths = (List)destination$iv$iv;
        for (String path : paths) {
            String baseUrl = this.environment.getProperty(path);
            if (baseUrl == null) continue;
            return baseUrl;
        }
        throw (Throwable)new IntegrationException("Unknown service '" + name + "': No baseUrl config property set for service");
    }

    public Ok3HttpClientRegistry(@NotNull String pluginId, @NotNull Environment environment, @NotNull ObjectMapper objectMapper, @NotNull OkHttp3ClientFactory okHttp3ClientFactory, @NotNull OkHttp3ClientConfiguration okHttp3ClientConfiguration) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)okHttp3ClientFactory, (String)"okHttp3ClientFactory");
        Intrinsics.checkNotNullParameter((Object)okHttp3ClientConfiguration, (String)"okHttp3ClientConfiguration");
        this.pluginId = pluginId;
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.okHttp3ClientFactory = okHttp3ClientFactory;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Ok3HttpClientRegistry this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = ok3HttpClientRegistry;
                super(0);
            }
        }));
        this.internalServicesClient = okHttp3ClientConfiguration.create().build();
        this.okClients = new ConcurrentHashMap();
        this.clients = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        baseUrlPaths = CollectionsKt.listOf((Object[])new String[]{"SERVICE_NAME.baseUrl", "services.SERVICE_NAME.baseUrl"});
    }

    public static final /* synthetic */ Logger access$getLog$p(Ok3HttpClientRegistry $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ String access$getPluginId$p(Ok3HttpClientRegistry $this) {
        return $this.pluginId;
    }

    public static final /* synthetic */ OkHttp3ClientFactory access$getOkHttp3ClientFactory$p(Ok3HttpClientRegistry $this) {
        return $this.okHttp3ClientFactory;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(Ok3HttpClientRegistry $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ String access$findInternalServiceBaseUrl(Ok3HttpClientRegistry $this, String name) {
        return $this.findInternalServiceBaseUrl(name);
    }

    public static final /* synthetic */ OkHttpClient access$getInternalServicesClient$p(Ok3HttpClientRegistry $this) {
        return $this.internalServicesClient;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/kork/plugins/sdk/httpclient/Ok3HttpClientRegistry$Companion;", "", "()V", "baseUrlPaths", "", "", "serviceNamePlaceholder", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

