/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.api.httpclient;

import com.netflix.spinnaker.kork.annotations.Beta;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

@Beta
public class HttpClientConfig {
    private final SecurityConfig security = new SecurityConfig();
    private final ConnectionConfig connection = new ConnectionConfig();
    private final ConnectionPoolConfig connectionPool = new ConnectionPoolConfig();
    private final LoggingConfig logging = new LoggingConfig();

    public SecurityConfig getSecurity() {
        return this.security;
    }

    public ConnectionConfig getConnection() {
        return this.connection;
    }

    public ConnectionPoolConfig getConnectionPool() {
        return this.connectionPool;
    }

    public LoggingConfig getLogging() {
        return this.logging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientConfig that = (HttpClientConfig)o;
        if (!this.security.equals(that.security)) {
            return false;
        }
        if (!this.connection.equals(that.connection)) {
            return false;
        }
        return this.connectionPool.equals(that.connectionPool);
    }

    public int hashCode() {
        int result = this.security.hashCode();
        result = 31 * result + this.connection.hashCode();
        result = 31 * result + this.connectionPool.hashCode();
        return result;
    }

    public static class LoggingConfig {
        private LoggingLevel level = LoggingLevel.BASIC;

        public LoggingLevel getLevel() {
            return this.level;
        }

        public void setLevel(LoggingLevel level) {
            this.level = level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoggingConfig that = (LoggingConfig)o;
            return this.level == that.level;
        }

        public int hashCode() {
            return this.level != null ? this.level.hashCode() : 0;
        }

        public static enum LoggingLevel {
            NONE,
            BASIC,
            HEADERS,
            BODY;

        }
    }

    public static class ConnectionPoolConfig {
        private Integer maxIdleConnections = 5;
        private Duration keepAlive = Duration.ofSeconds(60L);

        public Integer getMaxIdleConnections() {
            return this.maxIdleConnections;
        }

        public void setMaxIdleConnections(Integer maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionPoolConfig that = (ConnectionPoolConfig)o;
            if (!Objects.equals(this.maxIdleConnections, that.maxIdleConnections)) {
                return false;
            }
            return Objects.equals(this.keepAlive, that.keepAlive);
        }

        public int hashCode() {
            int result = this.maxIdleConnections != null ? this.maxIdleConnections.hashCode() : 0;
            result = 31 * result + (this.keepAlive != null ? this.keepAlive.hashCode() : 0);
            return result;
        }
    }

    public static class ConnectionConfig {
        private Duration connectTimeout = Duration.ofSeconds(10L);
        private Duration readTimeout = Duration.ofSeconds(30L);
        private boolean retryOnConnectionFailure = true;

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public ConnectionConfig setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public ConnectionConfig setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public boolean isRetryOnConnectionFailure() {
            return this.retryOnConnectionFailure;
        }

        public ConnectionConfig setRetryOnConnectionFailure(boolean retryOnConnectionFailure) {
            this.retryOnConnectionFailure = retryOnConnectionFailure;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionConfig that = (ConnectionConfig)o;
            if (this.retryOnConnectionFailure != that.retryOnConnectionFailure) {
                return false;
            }
            if (!Objects.equals(this.connectTimeout, that.connectTimeout)) {
                return false;
            }
            return Objects.equals(this.readTimeout, that.readTimeout);
        }

        public int hashCode() {
            int result = this.connectTimeout != null ? this.connectTimeout.hashCode() : 0;
            result = 31 * result + (this.readTimeout != null ? this.readTimeout.hashCode() : 0);
            result = 31 * result + (this.retryOnConnectionFailure ? 1 : 0);
            return result;
        }
    }

    public static class SecurityConfig {
        private static final String DEFAULT_TYPE = "PKCS12";
        private Path keyStorePath;
        private String keyStorePassword;
        private String keyStoreType = "PKCS12";
        private Path trustStorePath;
        private String trustStorePassword;
        private String trustStoreType = "PKCS12";
        private List<String> tlsVersions;
        private List<String> cipherSuites;

        public Path getKeyStorePath() {
            return this.keyStorePath;
        }

        public SecurityConfig setKeyStorePath(Path keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Path getTrustStorePath() {
            return this.trustStorePath;
        }

        public SecurityConfig setTrustStorePath(Path trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public SecurityConfig setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public SecurityConfig setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public SecurityConfig setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public SecurityConfig setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public List<String> getTlsVersions() {
            return this.tlsVersions;
        }

        public SecurityConfig setTlsVersions(List<String> tlsVersions) {
            this.tlsVersions = tlsVersions;
            return this;
        }

        public List<String> getCipherSuites() {
            return this.cipherSuites;
        }

        public SecurityConfig setCipherSuites(List<String> cipherSuites) {
            this.cipherSuites = cipherSuites;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityConfig that = (SecurityConfig)o;
            if (!Objects.equals(this.keyStorePath, that.keyStorePath)) {
                return false;
            }
            if (!Objects.equals(this.keyStorePassword, that.keyStorePassword)) {
                return false;
            }
            if (!Objects.equals(this.keyStoreType, that.keyStoreType)) {
                return false;
            }
            if (!Objects.equals(this.trustStorePath, that.trustStorePath)) {
                return false;
            }
            if (!Objects.equals(this.trustStorePassword, that.trustStorePassword)) {
                return false;
            }
            if (!Objects.equals(this.trustStoreType, that.trustStoreType)) {
                return false;
            }
            if (!Objects.equals(this.tlsVersions, that.tlsVersions)) {
                return false;
            }
            return Objects.equals(this.cipherSuites, that.cipherSuites);
        }

        public int hashCode() {
            int result = this.keyStorePath != null ? this.keyStorePath.hashCode() : 0;
            result = 31 * result + (this.keyStorePassword != null ? this.keyStorePassword.hashCode() : 0);
            result = 31 * result + (this.keyStoreType != null ? this.keyStoreType.hashCode() : 0);
            result = 31 * result + (this.trustStorePath != null ? this.trustStorePath.hashCode() : 0);
            result = 31 * result + (this.trustStorePassword != null ? this.trustStorePassword.hashCode() : 0);
            result = 31 * result + (this.trustStoreType != null ? this.trustStoreType.hashCode() : 0);
            result = 31 * result + (this.tlsVersions != null ? this.tlsVersions.hashCode() : 0);
            result = 31 * result + (this.cipherSuites != null ? this.cipherSuites.hashCode() : 0);
            return result;
        }
    }
}

