/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.keel.api.Resource;
import com.netflix.spinnaker.keel.api.ResourceKind;
import com.netflix.spinnaker.keel.api.ResourceSpec;
import com.netflix.spinnaker.keel.core.api.UIDKt;
import com.netflix.spinnaker.keel.events.ApplicationEvent;
import com.netflix.spinnaker.keel.events.PersistentEvent;
import com.netflix.spinnaker.keel.events.ResourceEvent;
import com.netflix.spinnaker.keel.events.ResourceHistoryEvent;
import com.netflix.spinnaker.keel.pause.PauseScope;
import com.netflix.spinnaker.keel.persistence.NoSuchResourceId;
import com.netflix.spinnaker.keel.persistence.ResourceHeader;
import com.netflix.spinnaker.keel.persistence.ResourceRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.resources.ResourceSpecIdentifier;
import com.netflix.spinnaker.keel.resources.SpecMigrator;
import com.netflix.spinnaker.keel.sql.JooqKt;
import com.netflix.spinnaker.keel.sql.ResourceFactory;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlResourceRepository;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import com.netflix.spinnaker.keel.telemetry.AboutToBeChecked;
import de.huxhorn.sulky.ulid.ULID;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record3;
import org.jooq.Record6;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectLimitPercentStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TransactionalRunnable;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020#0%H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020*H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020)0\t2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020)0\t2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J\u001c\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e03022\u0006\u00104\u001a\u00020\u001eH\u0002J\u0010\u00105\u001a\u00020#2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0018\u00106\u001a\u00020#2\u0006\u0010(\u001a\u0002072\u0006\u00108\u001a\u00020\u001eH\u0002J\u001e\u00109\u001a\b\u0012\u0004\u0012\u00020:0\t2\u0006\u00104\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001f2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\u001f2\u0006\u00104\u001a\u00020\u001eH\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001e0\t2\u0006\u0010,\u001a\u00020\u001eH\u0016J\u000e\u0010?\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001eJ\u001a\u0010@\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\t2\u0006\u0010,\u001a\u00020\u001eH\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010,\u001a\u00020\u001eH\u0016J$\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u001f0D2\u0006\u0010E\u001a\u00020F2\u0006\u0010/\u001a\u000200H\u0016J<\u0010G\u001a\b\u0012\u0004\u0012\u00020<0\u001f2\u0006\u00104\u001a\u00020\u001e2$\u0010$\u001a \u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u001f0HH\u0002J&\u0010I\u001a\b\u0012\u0004\u0012\u0002HJ0\u001f\"\b\b\u0000\u0010J*\u00020<2\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0\u001fH\u0016J\u0018\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u00020\u001e*\u0006\u0012\u0002\b\u00030\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006N"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlResourceRepository;", "Lcom/netflix/spinnaker/keel/persistence/ResourceRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "resourceSpecIdentifier", "Lcom/netflix/spinnaker/keel/resources/ResourceSpecIdentifier;", "specMigrators", "", "Lcom/netflix/spinnaker/keel/resources/SpecMigrator;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spinnaker/keel/resources/ResourceSpecIdentifier;Ljava/util/List;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/keel/sql/SqlRetry;Lorg/springframework/context/ApplicationEventPublisher;)V", "getClock", "()Ljava/time/Clock;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "resourceFactory", "Lcom/netflix/spinnaker/keel/sql/ResourceFactory;", "uid", "", "Lcom/netflix/spinnaker/keel/api/Resource;", "getUid", "(Lcom/netflix/spinnaker/keel/api/Resource;)Ljava/lang/String;", "allResources", "", "callback", "Lkotlin/Function1;", "Lcom/netflix/spinnaker/keel/persistence/ResourceHeader;", "appendHistory", "event", "Lcom/netflix/spinnaker/keel/events/ApplicationEvent;", "Lcom/netflix/spinnaker/keel/events/ResourceEvent;", "applicationEventHistory", "application", "after", "Ljava/time/Instant;", "limit", "", "applicationForId", "Lorg/jooq/Select;", "Lorg/jooq/Record1;", "id", "delete", "doAppendHistory", "Lcom/netflix/spinnaker/keel/events/PersistentEvent;", "ref", "eventHistory", "Lcom/netflix/spinnaker/keel/events/ResourceHistoryEvent;", "get", "Lcom/netflix/spinnaker/keel/api/ResourceSpec;", "getRaw", "getResourceIdsByApplication", "getResourceUid", "getResourcesByApplication", "hasManagedResources", "", "itemsDueForCheck", "", "minTimeSinceLastCheck", "Ljava/time/Duration;", "readResource", "Lkotlin/Function3;", "store", "T", "resource", "triggerResourceRecheck", "environmentName", "keel-sql"})
public class SqlResourceRepository
implements ResourceRepository {
    private final Lazy log$delegate;
    private final ResourceFactory resourceFactory;
    private final DSLContext jooq;
    @NotNull
    private final Clock clock;
    private final ResourceSpecIdentifier resourceSpecIdentifier;
    private final List<SpecMigrator<?, ?>> specMigrators;
    private final ObjectMapper objectMapper;
    private final SqlRetry sqlRetry;
    private final ApplicationEventPublisher publisher;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SqlResourceRepository sqlResourceRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void allResources(@NotNull Function1<? super ResourceHeader, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Unit>(this, callback){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ Function1 $callback;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                List list = SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.RESOURCE.KIND, (SelectField)Tables.RESOURCE.ID).from((TableLike)Tables.RESOURCE).fetch().map((RecordMapper)allResources.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(RES\u2026arseKind(kind))\n        }");
                Iterable iterable = list;
                Function1 action$iv = this.$callback;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    action$iv.invoke(element$iv);
                }
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$callback = function1;
                super(0);
            }
        });
    }

    @NotNull
    public Resource<ResourceSpec> get(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.readResource(id2, (Function3<? super String, ? super String, ? super String, ? extends Resource<? extends ResourceSpec>>)((Function3)new Function3<String, String, String, Resource<? extends ResourceSpec>>(this){
            final /* synthetic */ SqlResourceRepository this$0;

            @NotNull
            public final Resource<ResourceSpec> invoke(@NotNull String kind, @NotNull String metadata, @NotNull String spec) {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                return SqlResourceRepository.access$getResourceFactory$p(this.this$0).invoke(kind, metadata, spec);
            }
            {
                this.this$0 = sqlResourceRepository;
                super(3);
            }
        }));
    }

    @NotNull
    public Resource<ResourceSpec> getRaw(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.readResource(id2, (Function3<? super String, ? super String, ? super String, ? extends Resource<? extends ResourceSpec>>)((Function3)new Function3<String, String, String, Resource<? extends ResourceSpec>>(this){
            final /* synthetic */ SqlResourceRepository this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Resource<ResourceSpec> invoke(@NotNull String kind, @NotNull String metadata, @NotNull String spec) {
                void $this$readValue$iv;
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                ResourceKind resourceKind = ResourceKind.Companion.parseKind(kind);
                boolean bl = false;
                boolean bl2 = false;
                ResourceKind it = resourceKind;
                boolean bl3 = false;
                ObjectMapper objectMapper = SqlResourceRepository.access$getObjectMapper$p(this.this$0);
                String content$iv = metadata;
                boolean $i$f$readValue = false;
                String string = content$iv;
                void var13_13 = $this$readValue$iv;
                boolean $i$f$jacksonTypeRef = false;
                TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
                return new Resource(it, JooqKt.asResourceMetadata((Map)var13_13.readValue(string, typeReference)), (ResourceSpec)SqlResourceRepository.access$getObjectMapper$p(this.this$0).readValue(spec, SqlResourceRepository.access$getResourceSpecIdentifier$p(this.this$0).identify(it)));
            }
            {
                this.this$0 = sqlResourceRepository;
                super(3);
            }
        }));
    }

    private final Resource<ResourceSpec> readResource(String id2, Function3<? super String, ? super String, ? super String, ? extends Resource<? extends ResourceSpec>> callback) {
        return (Resource)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Resource<? extends ResourceSpec>>(this, id2, callback){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ Function3 $callback;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Resource<ResourceSpec> invoke() {
                Record3 record3;
                block3: {
                    block2: {
                        void metadata;
                        void kind;
                        record3 = (Record3)SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.RESOURCE_WITH_METADATA.KIND, (SelectField)Tables.RESOURCE_WITH_METADATA.METADATA, (SelectField)Tables.RESOURCE_WITH_METADATA.SPEC).from((TableLike)Tables.RESOURCE_WITH_METADATA).where(Tables.RESOURCE_WITH_METADATA.ID.eq((Object)this.$id)).fetchOne();
                        if (record3 == null) break block2;
                        Record3 record32 = record3;
                        boolean bl = false;
                        boolean bl2 = false;
                        Record3 $dstr$kind$metadata$spec = record32;
                        boolean bl3 = false;
                        String string = (String)$dstr$kind$metadata$spec.component1();
                        String string2 = (String)$dstr$kind$metadata$spec.component2();
                        String spec = (String)$dstr$kind$metadata$spec.component3();
                        void v1 = kind;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"kind");
                        void v2 = metadata;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"metadata");
                        String string3 = spec;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"spec");
                        record3 = (Resource)this.$callback.invoke((Object)v1, (Object)v2, (Object)string3);
                        if (record3 != null) break block3;
                    }
                    throw (Throwable)new NoSuchResourceId(this.$id);
                }
                return record3;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                this.$callback = function3;
                super(0);
            }
        });
    }

    @NotNull
    public List<Resource<?>> getResourcesByApplication(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<Resource<? extends ResourceSpec>>>(this, application2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $application;

            public final List<Resource<ResourceSpec>> invoke() {
                return SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.RESOURCE_WITH_METADATA.KIND, (SelectField)Tables.RESOURCE_WITH_METADATA.METADATA, (SelectField)Tables.RESOURCE_WITH_METADATA.SPEC).from((TableLike)Tables.RESOURCE_WITH_METADATA).where(Tables.RESOURCE_WITH_METADATA.APPLICATION.eq((Object)this.$application)).fetch().map((RecordMapper)new RecordMapper<Record3<String, String, String>, Resource<? extends ResourceSpec>>(this){
                    final /* synthetic */ getResourcesByApplication.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Resource<ResourceSpec> map(Record3<String, String, String> $dstr$kind$metadata$spec) {
                        void metadata;
                        void kind;
                        String string = (String)$dstr$kind$metadata$spec.component1();
                        String string2 = (String)$dstr$kind$metadata$spec.component2();
                        String spec = (String)$dstr$kind$metadata$spec.component3();
                        ResourceFactory resourceFactory = SqlResourceRepository.access$getResourceFactory$p(this.this$0.this$0);
                        void v1 = kind;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"kind");
                        void v2 = metadata;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"metadata");
                        String string3 = spec;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"spec");
                        return resourceFactory.invoke((String)v1, (String)v2, string3);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$application = string;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026ta, spec)\n        }\n    }");
        return (List)t;
    }

    public boolean hasManagedResources(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        return (Boolean)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Boolean>(this, application2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $application;

            public final boolean invoke() {
                return ((Number)((Record1)SqlResourceRepository.access$getJooq$p(this.this$0).selectCount().from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.APPLICATION.eq((Object)this.$application)).fetchSingle()).value1()).intValue() > 0;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$application = string;
                super(0);
            }
        });
    }

    @NotNull
    public List<String> getResourceIdsByApplication(@NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<String>>(this, application2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $application;

            public final List<String> invoke() {
                return SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.RESOURCE.ID).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.APPLICATION.eq((Object)this.$application)).fetch((Field)Tables.RESOURCE.ID);
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$application = string;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026.fetch(RESOURCE.ID)\n    }");
        return (List)t;
    }

    @NotNull
    public <T extends ResourceSpec> Resource<T> store(@NotNull Resource<? extends T> resource) {
        String string;
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Integer version = (Integer)this.jooq.select((SelectField)DSL.coalesce((Field)((Field)DSL.max((Field)((Field)Tables.RESOURCE_VERSION.VERSION))), (Field[])new Field[]{(Field)DSL.value((int)0)})).from((TableLike)Tables.RESOURCE_VERSION).join((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.UID.eq((Field)Tables.RESOURCE_VERSION.RESOURCE_UID)).where(Tables.RESOURCE.ID.eq((Object)resource.getId())).fetchOneInto(Integer.TYPE);
        if (version > 0) {
            string = this.getResourceUid(resource.getId());
        } else {
            String string2 = UIDKt.randomUID().toString();
            boolean bl = false;
            boolean bl2 = false;
            String uid2 = string2;
            boolean bl3 = false;
            this.jooq.insertInto((Table)Tables.RESOURCE).set((Field)Tables.RESOURCE.UID, (Object)uid2).set((Field)Tables.RESOURCE.KIND, (Object)resource.getKind().toString()).set((Field)Tables.RESOURCE.ID, (Object)resource.getId()).set((Field)Tables.RESOURCE.APPLICATION, (Object)resource.getApplication()).execute();
            String string3 = string2;
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUID().toString()\n \u2026     .execute()\n        }");
        }
        String uid3 = string;
        this.jooq.insertInto((Table)Tables.RESOURCE_VERSION).set((Field)Tables.RESOURCE_VERSION.RESOURCE_UID, (Object)uid3).set((Field)Tables.RESOURCE_VERSION.VERSION, (Object)(version + 1)).set((Field)Tables.RESOURCE_VERSION.SPEC, (Object)this.objectMapper.writeValueAsString((Object)resource.getSpec())).set((Field)Tables.RESOURCE_VERSION.CREATED_AT, (Object)this.getClock().instant()).execute();
        this.jooq.insertInto((Table)Tables.RESOURCE_LAST_CHECKED).set((Field)Tables.RESOURCE_LAST_CHECKED.RESOURCE_UID, (Object)uid3).set((Field)Tables.RESOURCE_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).onDuplicateKeyUpdate().set((Field)Tables.RESOURCE_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).execute();
        return Resource.copy$default(resource, null, (Map)MapsKt.plus((Map)resource.getMetadata(), (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"uid", (Object)uid3), TuplesKt.to((Object)"version", (Object)(version + 1))})), null, (int)5, null);
    }

    @NotNull
    public List<ApplicationEvent> applicationEventHistory(@NotNull String application2, int limit) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        boolean bl = limit > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "limit must be a positive integer";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends ApplicationEvent>>(this, application2, limit){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $application;
            final /* synthetic */ int $limit;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ApplicationEvent> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                List list = SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.EVENT.JSON).from((TableLike)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.APPLICATION)).and(Tables.EVENT.REF.eq((Object)this.$application)).orderBy((OrderField)Tables.EVENT.TIMESTAMP.desc()).limit(this.$limit).fetch((Field)Tables.EVENT.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(EVE\u2026       .fetch(EVENT.JSON)");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ApplicationEvent)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$application = string;
                this.$limit = n;
                super(0);
            }
        });
    }

    @NotNull
    public List<ApplicationEvent> applicationEventHistory(@NotNull String application2, @NotNull Instant after) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends ApplicationEvent>>(this, application2, after){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $application;
            final /* synthetic */ Instant $after;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ApplicationEvent> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                List list = SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.EVENT.JSON).from((TableLike)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.APPLICATION)).and(Tables.EVENT.REF.eq((Object)this.$application)).and(Tables.EVENT.TIMESTAMP.greaterOrEqual((Object)this.$after)).orderBy((OrderField)Tables.EVENT.TIMESTAMP.desc()).fetch((Field)Tables.EVENT.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(EVE\u2026       .fetch(EVENT.JSON)");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ApplicationEvent)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$application = string;
                this.$after = instant;
                super(0);
            }
        });
    }

    @NotNull
    public List<ResourceHistoryEvent> eventHistory(@NotNull String id2, int limit) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        boolean bl = limit > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "limit must be a positive integer";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends ResourceHistoryEvent>>(this, id2, limit){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ int $limit;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ResourceHistoryEvent> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                List list = SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.EVENT.JSON).from((TableLike)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.RESOURCE).and(Tables.EVENT.REF.eq((Object)this.$id))).or(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.APPLICATION).and(Tables.EVENT.APPLICATION.eq(SqlResourceRepository.access$applicationForId(this.this$0, this.$id)))).orderBy((OrderField)Tables.EVENT.TIMESTAMP.desc()).limit(this.$limit).fetch((Field)Tables.EVENT.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(EVE\u2026       .fetch(EVENT.JSON)");
                Iterable $this$filterIsInstance$iv = list;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ResourceHistoryEvent)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                this.$limit = n;
                super(0);
            }
        });
    }

    public void appendHistory(@NotNull ResourceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String ref = this.getResourceUid(event.getRef());
        this.doAppendHistory((PersistentEvent)event, ref);
    }

    public void appendHistory(@NotNull ApplicationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.doAppendHistory((PersistentEvent)event, event.getApplication());
    }

    private final void doAppendHistory(PersistentEvent event, String ref) {
        this.getLog().debug("Appending event: " + event);
        if (event.getIgnoreRepeatedInHistory()) {
            PersistentEvent previousEvent2 = (PersistentEvent)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<PersistentEvent>(this, event){
                final /* synthetic */ SqlResourceRepository this$0;
                final /* synthetic */ PersistentEvent $event;

                public final PersistentEvent invoke() {
                    return (PersistentEvent)SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.EVENT.JSON).from((TableLike)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.RESOURCE).and(Tables.EVENT.REF.eq((Object)this.$event.getRef()))).or(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.APPLICATION).and(Tables.EVENT.APPLICATION.eq((Object)this.$event.getApplication()))).orderBy((OrderField)Tables.EVENT.TIMESTAMP.desc()).limit(1).fetchOne((Field)Tables.EVENT.JSON);
                }
                {
                    this.this$0 = sqlResourceRepository;
                    this.$event = persistentEvent;
                    super(0);
                }
            });
            PersistentEvent persistentEvent = previousEvent2;
            if (Intrinsics.areEqual(event.getClass(), persistentEvent != null ? persistentEvent.getClass() : null)) {
                return;
            }
        }
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, event){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ PersistentEvent $event;

            public final int invoke() {
                return SqlResourceRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.EVENT).set((Field)Tables.EVENT.UID, (Object)new ULID().nextULID(this.$event.getTimestamp().toEpochMilli())).set((Field)Tables.EVENT.SCOPE, (Object)this.$event.getScope()).set((Field)Tables.EVENT.JSON, (Object)this.$event).execute();
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$event = persistentEvent;
                super(0);
            }
        });
    }

    public void delete(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, id2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;

            public final int invoke() {
                int n = SqlResourceRepository.access$getJooq$p(this.this$0).deleteFrom((Table)Tables.RESOURCE).where(Tables.RESOURCE.ID.eq((Object)this.$id)).execute();
                boolean bl = false;
                boolean bl2 = false;
                int count2 = n;
                boolean bl3 = false;
                if (count2 == 0) {
                    throw (Throwable)new NoSuchResourceId(this.$id);
                }
                return n;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                super(0);
            }
        });
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, id2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;

            public final int invoke() {
                return SqlResourceRepository.access$getJooq$p(this.this$0).deleteFrom((Table)Tables.EVENT).where(Tables.EVENT.SCOPE.eq((Object)PersistentEvent.EventScope.RESOURCE)).and(Tables.EVENT.REF.eq((Object)this.$id)).execute();
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                super(0);
            }
        });
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, id2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;

            public final int invoke() {
                return SqlResourceRepository.access$getJooq$p(this.this$0).deleteFrom((Table)Tables.DIFF_FINGERPRINT).where(Tables.DIFF_FINGERPRINT.ENTITY_ID.eq((Object)this.$id)).execute();
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                super(0);
            }
        });
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, id2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;

            public final int invoke() {
                return SqlResourceRepository.access$getJooq$p(this.this$0).deleteFrom((Table)Tables.PAUSED).where(Tables.PAUSED.SCOPE.eq((Object)PauseScope.RESOURCE)).and(Tables.PAUSED.NAME.eq((Object)this.$id)).execute();
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                super(0);
            }
        });
    }

    @NotNull
    public Collection<Resource<ResourceSpec>> itemsDueForCheck(@NotNull Duration minTimeSinceLastCheck, int limit) {
        Intrinsics.checkNotNullParameter((Object)minTimeSinceLastCheck, (String)"minTimeSinceLastCheck");
        Instant now = this.getClock().instant();
        Instant cutoff = now.minus(minTimeSinceLastCheck);
        Object t = this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<List<Resource<? extends ResourceSpec>>>(this, cutoff, limit, now){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ Instant $cutoff;
            final /* synthetic */ int $limit;
            final /* synthetic */ Instant $now;

            public final List<Resource<ResourceSpec>> invoke() {
                return ((Result)JooqKt.inTransaction(SqlResourceRepository.access$getJooq$p(this.this$0), (Function1)new Function1<DSLContext, Result<Record6<String, String, String, String, String, Instant>>>(this){
                    final /* synthetic */ itemsDueForCheck.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Result<Record6<String, String, String, String, String, Instant>> invoke(@NotNull DSLContext $this$inTransaction) {
                        Intrinsics.checkNotNullParameter((Object)$this$inTransaction, (String)"$receiver");
                        Result result = $this$inTransaction.select((SelectField)Tables.RESOURCE_WITH_METADATA.UID, (SelectField)Tables.RESOURCE_WITH_METADATA.KIND, (SelectField)Tables.RESOURCE_WITH_METADATA.METADATA, (SelectField)Tables.RESOURCE_WITH_METADATA.SPEC, (SelectField)Tables.RESOURCE_WITH_METADATA.APPLICATION, (SelectField)Tables.RESOURCE_LAST_CHECKED.AT).from(new TableLike[]{(TableLike)Tables.RESOURCE_WITH_METADATA, (TableLike)Tables.RESOURCE_LAST_CHECKED}).where(Tables.RESOURCE_WITH_METADATA.UID.eq((Field)Tables.RESOURCE_LAST_CHECKED.RESOURCE_UID)).and(Tables.RESOURCE_LAST_CHECKED.AT.lessOrEqual((Object)this.this$0.$cutoff)).and(Tables.RESOURCE_LAST_CHECKED.IGNORE.notEqual((Object)true)).orderBy((OrderField)Tables.RESOURCE_LAST_CHECKED.AT).limit(this.this$0.$limit).forUpdate().fetch();
                        boolean bl = false;
                        boolean bl2 = false;
                        Result it = result;
                        boolean bl3 = false;
                        Result result2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"it");
                        Iterable $this$forEach$iv = (Iterable)result2;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void application2;
                            void uid2;
                            Record6 $dstr$uid$_u24__u24$_u24__u24$_u24__u24$application$lastCheckedAt = (Record6)element$iv;
                            boolean bl4 = false;
                            String string = (String)$dstr$uid$_u24__u24$_u24__u24$_u24__u24$application$lastCheckedAt.component1();
                            String string2 = (String)$dstr$uid$_u24__u24$_u24__u24$_u24__u24$application$lastCheckedAt.component5();
                            Instant lastCheckedAt = (Instant)$dstr$uid$_u24__u24$_u24__u24$_u24__u24$application$lastCheckedAt.component6();
                            $this$inTransaction.insertInto((Table)Tables.RESOURCE_LAST_CHECKED).set((Field)Tables.RESOURCE_LAST_CHECKED.RESOURCE_UID, (Object)uid2).set((Field)Tables.RESOURCE_LAST_CHECKED.AT, (Object)this.this$0.$now).onDuplicateKeyUpdate().set((Field)Tables.RESOURCE_LAST_CHECKED.AT, (Object)this.this$0.$now).execute();
                            ApplicationEventPublisher applicationEventPublisher = SqlResourceRepository.access$getPublisher$p(this.this$0.this$0);
                            Instant instant = lastCheckedAt;
                            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastCheckedAt");
                            applicationEventPublisher.publishEvent((Object)new AboutToBeChecked(instant, "resource", "application:" + (String)application2));
                        }
                        return result;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })).map((RecordMapper)new RecordMapper<Record6<String, String, String, String, String, Instant>, Resource<? extends ResourceSpec>>(this){
                    final /* synthetic */ itemsDueForCheck.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final Resource<ResourceSpec> map(Record6<String, String, String, String, String, Instant> $dstr$uid$kind$metadata$spec) {
                        Resource<ResourceSpec> resource;
                        String string = (String)$dstr$uid$kind$metadata$spec.component1();
                        String string2 = (String)$dstr$uid$kind$metadata$spec.component2();
                        String string3 = (String)$dstr$uid$kind$metadata$spec.component3();
                        String spec = (String)$dstr$uid$kind$metadata$spec.component4();
                        try {
                            void metadata;
                            void kind;
                            ResourceFactory resourceFactory = SqlResourceRepository.access$getResourceFactory$p(this.this$0.this$0);
                            void v1 = kind;
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"kind");
                            void v2 = metadata;
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"metadata");
                            String string4 = spec;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"spec");
                            resource = resourceFactory.invoke((String)v1, (String)v2, string4);
                        }
                        catch (Exception e) {
                            void uid2;
                            SqlResourceRepository.access$getJooq$p(this.this$0.this$0).insertInto((Table)Tables.RESOURCE_LAST_CHECKED).set((Field)Tables.RESOURCE_LAST_CHECKED.RESOURCE_UID, (Object)uid2).set((Field)Tables.RESOURCE_LAST_CHECKED.IGNORE, (Object)true).onDuplicateKeyUpdate().set((Field)Tables.RESOURCE_LAST_CHECKED.IGNORE, (Object)true).execute();
                            throw (Throwable)e;
                        }
                        return resource;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$cutoff = instant;
                this.$limit = n;
                this.$now = instant2;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(WRITE\u2026        }\n        }\n    }");
        return (Collection)t;
    }

    public void triggerResourceRecheck(@NotNull String environmentName, @NotNull String application2) {
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        this.getLog().debug("Triggering recheck for environment " + environmentName + " in application " + application2);
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, environmentName, application2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $application;

            public final void invoke() {
                SqlResourceRepository.access$getJooq$p(this.this$0).transaction(new TransactionalRunnable(this){
                    final /* synthetic */ triggerResourceRecheck.1 this$0;

                    public final void run(Configuration config) {
                        DSLContext txn = DSL.using((Configuration)config);
                        Result resourceUids = txn.select((SelectField)Tables.ENVIRONMENT_RESOURCE.RESOURCE_UID).from((TableLike)Tables.ENVIRONMENT_RESOURCE).innerJoin((TableLike)Tables.LATEST_ENVIRONMENT).on(Tables.LATEST_ENVIRONMENT.UID.eq((Field)Tables.ENVIRONMENT_RESOURCE.ENVIRONMENT_UID)).innerJoin((TableLike)Tables.DELIVERY_CONFIG).on(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).where(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)this.this$0.$environmentName)).and(Tables.DELIVERY_CONFIG.APPLICATION.eq((Object)this.this$0.$application)).fetch();
                        SqlResourceRepository.access$getLog$p(this.this$0.this$0).debug("Triggering recheck for resources " + resourceUids + " in environment " + this.this$0.$environmentName + " in application " + this.this$0.$application);
                        txn.update((Table)Tables.RESOURCE_LAST_CHECKED).set((Field)Tables.RESOURCE_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).where(Tables.RESOURCE_LAST_CHECKED.RESOURCE_UID.in(resourceUids)).execute();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$environmentName = string;
                this.$application = string2;
                super(0);
            }
        });
    }

    @NotNull
    public final String getResourceUid(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, id2){
            final /* synthetic */ SqlResourceRepository this$0;
            final /* synthetic */ String $id;

            @NotNull
            public final String invoke() {
                String string = (String)SqlResourceRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.RESOURCE.UID).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.ID.eq((Object)this.$id)).fetchOne((Field)Tables.RESOURCE.UID);
                if (string == null) {
                    throw (Throwable)new IllegalStateException("Resource with id " + this.$id + " not found. Retrying.");
                }
                return string;
            }
            {
                this.this$0 = sqlResourceRepository;
                this.$id = string;
                super(0);
            }
        });
    }

    private final Select<Record1<String>> applicationForId(String id2) {
        SelectLimitPercentStep selectLimitPercentStep = DSL.select((SelectField)((SelectField)Tables.RESOURCE.APPLICATION)).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.ID.eq((Object)id2)).limit(1);
        Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"select(RESOURCE.APPLICAT\u2026D.eq(id))\n      .limit(1)");
        return (Select)selectLimitPercentStep;
    }

    private final String getUid(Resource<?> $this$uid) {
        return this.getResourceUid($this$uid.getId());
    }

    @NotNull
    public Clock getClock() {
        return this.clock;
    }

    public SqlResourceRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ResourceSpecIdentifier resourceSpecIdentifier, @NotNull List<? extends SpecMigrator<?, ?>> specMigrators, @NotNull ObjectMapper objectMapper, @NotNull SqlRetry sqlRetry, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)resourceSpecIdentifier, (String)"resourceSpecIdentifier");
        Intrinsics.checkNotNullParameter(specMigrators, (String)"specMigrators");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        this.jooq = jooq;
        this.clock = clock;
        this.resourceSpecIdentifier = resourceSpecIdentifier;
        this.specMigrators = specMigrators;
        this.objectMapper = objectMapper;
        this.sqlRetry = sqlRetry;
        this.publisher = publisher;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlResourceRepository this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = sqlResourceRepository;
                super(0);
            }
        }));
        this.resourceFactory = new ResourceFactory(this.objectMapper, this.resourceSpecIdentifier, this.specMigrators);
    }

    @Nullable
    public ResourceHistoryEvent lastEvent(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return ResourceRepository.DefaultImpls.lastEvent((ResourceRepository)this, (String)id2);
    }

    public void markCheckComplete(@NotNull Resource<? extends ResourceSpec> deliveryConfig) {
        Intrinsics.checkNotNullParameter(deliveryConfig, (String)"deliveryConfig");
        ResourceRepository.DefaultImpls.markCheckComplete((ResourceRepository)this, deliveryConfig);
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlResourceRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ ResourceFactory access$getResourceFactory$p(SqlResourceRepository $this) {
        return $this.resourceFactory;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(SqlResourceRepository $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ ResourceSpecIdentifier access$getResourceSpecIdentifier$p(SqlResourceRepository $this) {
        return $this.resourceSpecIdentifier;
    }

    public static final /* synthetic */ Select access$applicationForId(SqlResourceRepository $this, String id2) {
        return $this.applicationForId(id2);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(SqlResourceRepository $this) {
        return $this.publisher;
    }

    public static final /* synthetic */ Logger access$getLog$p(SqlResourceRepository $this) {
        return $this.getLog();
    }
}

