/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.keel.api.artifacts.DeliveryArtifact;
import com.netflix.spinnaker.keel.lifecycle.LifecycleEvent;
import com.netflix.spinnaker.keel.lifecycle.LifecycleEventRepository;
import com.netflix.spinnaker.keel.lifecycle.LifecycleEventStatus;
import com.netflix.spinnaker.keel.lifecycle.LifecycleEventStatusKt;
import com.netflix.spinnaker.keel.lifecycle.LifecycleStep;
import com.netflix.spinnaker.keel.lifecycle.StartMonitoringEvent;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlLifecycleEventRepository;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import de.huxhorn.sulky.ulid.ULID;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TransactionalRunnable;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\"\u001a\u00020#J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0016\u0010&\u001a\u00020'2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eH\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u001aH\u0016J\u0014\u0010*\u001a\n \u0012*\u0004\u0018\u00010\u000e0\u000e*\u00020\u001aH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rt\u0010\u0017\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00190\u0019 \u0012*.\u0012(\u0012&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00190\u0019\u0018\u00010\u00180\u0018*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlLifecycleEventRepository;", "Lcom/netflix/spinnaker/keel/lifecycle/LifecycleEventRepository;", "clock", "Ljava/time/Clock;", "jooq", "Lorg/jooq/DSLContext;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "spectator", "Lcom/netflix/spectator/api/Registry;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Ljava/time/Clock;Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/keel/sql/SqlRetry;Lcom/netflix/spectator/api/Registry;Lorg/springframework/context/ApplicationEventPublisher;)V", "LIFECYCLE_STEP_CALCULATION_ALL_DURATION_ID", "", "LIFECYCLE_STEP_CALCULATION_DURATION_ID", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "artifactUid", "Lorg/jooq/SelectConditionStep;", "Lorg/jooq/Record1;", "Lcom/netflix/spinnaker/keel/lifecycle/LifecycleEvent;", "getArtifactUid", "(Lcom/netflix/spinnaker/keel/lifecycle/LifecycleEvent;)Lorg/jooq/SelectConditionStep;", "calculateSteps", "", "Lcom/netflix/spinnaker/keel/lifecycle/LifecycleStep;", "events", "getEvents", "artifact", "Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;", "artifactVersion", "getSteps", "retriggerMonitoring", "", "saveEvent", "event", "getUid", "keel-sql"})
public final class SqlLifecycleEventRepository
implements LifecycleEventRepository {
    private final Lazy log$delegate;
    private final String LIFECYCLE_STEP_CALCULATION_DURATION_ID;
    private final String LIFECYCLE_STEP_CALCULATION_ALL_DURATION_ID;
    private final Clock clock;
    private final DSLContext jooq;
    private final SqlRetry sqlRetry;
    private final Registry spectator;
    private final ApplicationEventPublisher publisher;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SqlLifecycleEventRepository sqlLifecycleEventRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String saveEvent(@NotNull LifecycleEvent event) {
        void eventUid;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Instant instant = event.getTimestamp();
        if (instant == null) {
            instant = this.clock.instant();
        }
        Instant timestamp = instant;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = new ULID().nextULID(this.clock.millis());
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, event, (Ref.ObjectRef)eventUid, timestamp){
            final /* synthetic */ SqlLifecycleEventRepository this$0;
            final /* synthetic */ LifecycleEvent $event;
            final /* synthetic */ Ref.ObjectRef $eventUid;
            final /* synthetic */ Instant $timestamp;

            public final void invoke() {
                SqlLifecycleEventRepository.access$getJooq$p(this.this$0).transaction(new TransactionalRunnable(this){
                    final /* synthetic */ saveEvent.1 this$0;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final void run(Configuration config) {
                        DSLContext txn = DSL.using((Configuration)config);
                        boolean eventExists = false;
                        Result result = txn.select((SelectField)Tables.LIFECYCLE_EVENT.UID, (SelectField)Tables.LIFECYCLE_EVENT.JSON).from((TableLike)Tables.LIFECYCLE_EVENT).where(Tables.LIFECYCLE_EVENT.SCOPE.eq((Object)this.this$0.$event.getScope().name())).and(Tables.LIFECYCLE_EVENT.DELIVERY_CONFIG_NAME.eq((Object)this.this$0.$event.getDeliveryConfigName())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_REFERENCE.eq((Object)this.this$0.$event.getArtifactReference())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_VERSION.eq((Object)this.this$0.$event.getArtifactVersion())).and(Tables.LIFECYCLE_EVENT.TYPE.eq((Object)this.this$0.$event.getType())).and(Tables.LIFECYCLE_EVENT.ID.eq((Object)this.this$0.$event.getId())).and(Tables.LIFECYCLE_EVENT.STATUS.eq((Object)this.this$0.$event.getStatus())).limit(1).fetch();
                        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"txn.select(LIFECYCLE_EVE\u2026mit(1)\n          .fetch()");
                        Record2 record2 = (Record2)CollectionsKt.firstOrNull((List)((List)result));
                        if (record2 != null) {
                            void uid2;
                            Record2 record22 = record2;
                            boolean bl = false;
                            boolean bl2 = false;
                            Record2 $dstr$uid$savedEvent = record22;
                            boolean bl3 = false;
                            String string = (String)$dstr$uid$savedEvent.component1();
                            LifecycleEvent savedEvent = (LifecycleEvent)$dstr$uid$savedEvent.component2();
                            eventExists = true;
                            this.this$0.$eventUid.element = uid2;
                            try {
                                if (Intrinsics.areEqual((Object)this.this$0.$event, (Object)LifecycleEvent.copy$default((LifecycleEvent)savedEvent, null, null, null, null, null, null, null, null, null, (Instant)this.this$0.$event.getTimestamp(), (boolean)false, null, (int)3583, null))) {
                                    txn.update((Table)Tables.LIFECYCLE_EVENT).set((Field)Tables.LIFECYCLE_EVENT.TIMESTAMP, (Object)this.this$0.$timestamp).where(Tables.LIFECYCLE_EVENT.UID.eq((Object)uid2)).execute();
                                }
                            }
                            catch (JsonMappingException jsonMappingException) {
                            }
                        }
                        if (!eventExists) {
                            txn.insertInto((Table)Tables.LIFECYCLE_EVENT).set((Field)Tables.LIFECYCLE_EVENT.UID, (Object)((String)this.this$0.$eventUid.element)).set((Field)Tables.LIFECYCLE_EVENT.SCOPE, (Object)this.this$0.$event.getScope().name()).set((Field)Tables.LIFECYCLE_EVENT.DELIVERY_CONFIG_NAME, (Object)this.this$0.$event.getDeliveryConfigName()).set((Field)Tables.LIFECYCLE_EVENT.ARTIFACT_REFERENCE, (Object)this.this$0.$event.getArtifactReference()).set((Field)Tables.LIFECYCLE_EVENT.ARTIFACT_VERSION, (Object)this.this$0.$event.getArtifactVersion()).set((Field)Tables.LIFECYCLE_EVENT.TYPE, (Object)this.this$0.$event.getType()).set((Field)Tables.LIFECYCLE_EVENT.ID, (Object)this.this$0.$event.getId()).set((Field)Tables.LIFECYCLE_EVENT.STATUS, (Object)this.this$0.$event.getStatus()).set((Field)Tables.LIFECYCLE_EVENT.TIMESTAMP, (Object)this.this$0.$timestamp).set((Field)Tables.LIFECYCLE_EVENT.JSON, (Object)this.this$0.$event).execute();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlLifecycleEventRepository;
                this.$event = lifecycleEvent;
                this.$eventUid = objectRef;
                this.$timestamp = instant;
                super(0);
            }
        });
        String string = (String)eventUid.element;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eventUid");
        return string;
    }

    private final SelectConditionStep<Record1<String>> getArtifactUid(LifecycleEvent $this$artifactUid) {
        return DSL.select((SelectField)((SelectField)Tables.DELIVERY_ARTIFACT.UID)).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)$this$artifactUid.getDeliveryConfigName())).and(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)$this$artifactUid.getArtifactReference()));
    }

    @NotNull
    public List<LifecycleEvent> getEvents(@NotNull DeliveryArtifact artifact, @NotNull String artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        return (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends LifecycleEvent>>(this, artifact, artifactVersion){
            final /* synthetic */ SqlLifecycleEventRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $artifactVersion;

            @NotNull
            public final List<LifecycleEvent> invoke() {
                List list = SqlLifecycleEventRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.LIFECYCLE_EVENT.JSON, (SelectField)Tables.LIFECYCLE_EVENT.TIMESTAMP).from((TableLike)Tables.LIFECYCLE_EVENT).where(Tables.LIFECYCLE_EVENT.DELIVERY_CONFIG_NAME.eq((Object)this.$artifact.getDeliveryConfigName())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_REFERENCE.eq((Object)this.$artifact.getReference())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_VERSION.eq((Object)this.$artifactVersion)).orderBy((OrderField)Tables.LIFECYCLE_EVENT.TIMESTAMP.asc()).fetch().map((RecordMapper)getEvents.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(LIFECYCLE_EV\u2026mp = timestamp)\n        }");
                return CollectionsKt.filterNotNull((Iterable)list);
            }
            {
                this.this$0 = sqlLifecycleEventRepository;
                this.$artifact = deliveryArtifact;
                this.$artifactVersion = string;
                super(0);
            }
        });
    }

    @NotNull
    public final List<LifecycleEvent> getEvents(@NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends LifecycleEvent>>(this, artifact){
            final /* synthetic */ SqlLifecycleEventRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;

            @NotNull
            public final List<LifecycleEvent> invoke() {
                List list = SqlLifecycleEventRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.LIFECYCLE_EVENT.JSON, (SelectField)Tables.LIFECYCLE_EVENT.TIMESTAMP).from((TableLike)Tables.LIFECYCLE_EVENT).where(Tables.LIFECYCLE_EVENT.DELIVERY_CONFIG_NAME.eq((Object)this.$artifact.getDeliveryConfigName())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_REFERENCE.eq((Object)this.$artifact.getReference())).orderBy((OrderField)Tables.LIFECYCLE_EVENT.TIMESTAMP.asc()).fetch().map((RecordMapper)getEvents.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(LIFECYCLE_EV\u2026tamp = timestamp)\n      }");
                return CollectionsKt.filterNotNull((Iterable)list);
            }
            {
                this.this$0 = sqlLifecycleEventRepository;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    @NotNull
    public List<LifecycleStep> getSteps(@NotNull DeliveryArtifact artifact, @NotNull String artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        Instant startTime = this.clock.instant();
        List<LifecycleEvent> events = this.getEvents(artifact, artifactVersion);
        List<LifecycleStep> steps = this.calculateSteps(events);
        this.spectator.timer(this.LIFECYCLE_STEP_CALCULATION_DURATION_ID, (Iterable)CollectionsKt.listOf((Object)new BasicTag("artifactRef", artifact.getDeliveryConfigName() + ':' + artifact.getReference()))).record(Duration.between(startTime, this.clock.instant()));
        return steps;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LifecycleStep> calculateSteps(List<LifecycleEvent> events) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$associateByTo$iv$iv2;
        String string;
        Map map;
        void $this$associateByTo$iv$iv3;
        void $this$associateBy$iv2;
        boolean bl = false;
        List steps = new ArrayList();
        Iterable $this$sortedByDescending$iv = events;
        boolean $i$f$sortedByDescending = false;
        boolean bl2 = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LifecycleEvent it = (LifecycleEvent)b;
                boolean bl2 = false;
                Comparable comparable = it.getTimestamp();
                it = (LifecycleEvent)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Instant instant = it.getTimestamp();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
            }
        });
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        void var7_10 = $this$associateBy$iv2;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv3) {
            void it;
            LifecycleEvent lifecycleEvent = (LifecycleEvent)element$iv$iv;
            map = destination$iv$iv;
            boolean bl3 = false;
            string = it.getId();
            map.put(string, element$iv$iv);
        }
        Map firstEventById = destination$iv$iv;
        Iterable $this$associateBy$iv3 = events;
        boolean $i$f$associateBy2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv3, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv3;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            LifecycleEvent bl3 = (LifecycleEvent)element$iv$iv;
            map = destination$iv$iv2;
            boolean bl4 = false;
            string = it.getId();
            map.put(string, element$iv$iv);
        }
        Map lastEventById = destination$iv$iv2;
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LifecycleEvent it = (LifecycleEvent)element$iv$iv;
            boolean bl5 = false;
            if (!LifecycleEventStatusKt.isEndingStatus((LifecycleEventStatus)it.getStatus())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy3 = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LifecycleEvent bl5 = (LifecycleEvent)element$iv$iv;
            map = destination$iv$iv3;
            boolean bl6 = false;
            string = it.getId();
            map.put(string, element$iv$iv);
        }
        Map endingEventsById = destination$iv$iv3;
        Map $this$forEach$iv = firstEventById;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl7 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            LifecycleEvent lastEvent;
            void id2;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Map.Entry element$iv;
            Map.Entry $dstr$id$event = element$iv = iterator.next();
            boolean bl8 = false;
            Object it = $dstr$id$event;
            boolean bl6 = false;
            String string2 = (String)it.getKey();
            it = $dstr$id$event;
            bl6 = false;
            LifecycleEvent event = (LifecycleEvent)it.getValue();
            it = events;
            SqlLifecycleEventRepository sqlLifecycleEventRepository = this;
            boolean $i$f$filter2 = false;
            String string3 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                LifecycleEvent it2 = (LifecycleEvent)element$iv$iv;
                boolean bl9 = false;
                if (!Intrinsics.areEqual((Object)it2.getId(), (Object)id2)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv4;
            sqlLifecycleEventRepository.retriggerMonitoring(list);
            LifecycleStep step = event.toStep();
            LifecycleEvent lifecycleEvent = (LifecycleEvent)endingEventsById.get(id2);
            if (lifecycleEvent == null) {
                lifecycleEvent = lastEvent = (LifecycleEvent)lastEventById.get(id2);
            }
            if (lastEvent != null) {
                String it3;
                boolean bl10;
                if (LifecycleEventStatusKt.isEndingStatus((LifecycleEventStatus)lastEvent.getStatus())) {
                    step = LifecycleStep.copy$default((LifecycleStep)step, null, null, null, null, null, null, null, (Instant)lastEvent.getTimestamp(), null, (int)383, null);
                }
                String string4 = lastEvent.getText();
                if (string4 != null) {
                    string3 = string4;
                    boolean bl11 = false;
                    bl10 = false;
                    it3 = string3;
                    boolean bl12 = false;
                    step = LifecycleStep.copy$default((LifecycleStep)step, null, null, null, null, (String)it3, null, null, null, null, (int)495, null);
                }
                String string5 = lastEvent.getLink();
                if (string5 != null) {
                    string3 = string5;
                    boolean bl13 = false;
                    bl10 = false;
                    it3 = string3;
                    boolean bl14 = false;
                    step = LifecycleStep.copy$default((LifecycleStep)step, null, null, null, null, null, (String)it3, null, null, null, (int)479, null);
                }
                step = LifecycleStep.copy$default((LifecycleStep)step, null, null, null, (LifecycleEventStatus)lastEvent.getStatus(), null, null, null, null, null, (int)503, null);
            }
            String string6 = step.getLink();
            if (string6 == null) continue;
            if (!StringsKt.startsWith$default((String)string6, (String)"http", (boolean)false, (int)2, null)) continue;
            steps.add(step);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)steps);
        boolean $i$f$sortedBy = false;
        boolean bl15 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LifecycleStep it = (LifecycleStep)a;
                boolean bl2 = false;
                Comparable comparable = it.getStartedAt();
                it = (LifecycleStep)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Instant instant = it.getStartedAt();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
            }
        });
    }

    @NotNull
    public List<LifecycleStep> getSteps(@NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Instant startTime = this.clock.instant();
        List<LifecycleEvent> events = this.getEvents(artifact);
        List<LifecycleStep> steps = this.calculateSteps(events);
        this.spectator.timer(this.LIFECYCLE_STEP_CALCULATION_ALL_DURATION_ID, (Iterable)CollectionsKt.listOf((Object)new BasicTag("artifactRef", artifact.getDeliveryConfigName() + ':' + artifact.getReference()))).record(Duration.between(startTime, this.clock.instant()));
        return steps;
    }

    private final void retriggerMonitoring(List<LifecycleEvent> events) {
        if (events.size() != 1) {
            return;
        }
        LifecycleEvent event = (LifecycleEvent)CollectionsKt.first(events);
        Instant now = this.clock.instant();
        Instant instant = event.getTimestamp();
        if (instant == null) {
            return;
        }
        Instant eventTimestamp = instant;
        Duration age = Duration.between(eventTimestamp, now);
        if (event.getStartMonitoring() && !LifecycleEventStatusKt.isEndingStatus((LifecycleEventStatus)event.getStatus()) && age.compareTo(Duration.ofMinutes(5L)) > 0) {
            String uid2;
            this.getLog().info("Re-triggering monitoring for event " + event);
            String string = uid2 = this.getUid(event);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uid");
            this.publisher.publishEvent((Object)new StartMonitoringEvent(string, event));
        }
    }

    private final String getUid(LifecycleEvent $this$getUid) {
        return (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, $this$getUid){
            final /* synthetic */ SqlLifecycleEventRepository this$0;
            final /* synthetic */ LifecycleEvent $this_getUid;

            public final String invoke() {
                List list = SqlLifecycleEventRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.LIFECYCLE_EVENT.UID).from((TableLike)Tables.LIFECYCLE_EVENT).where(Tables.LIFECYCLE_EVENT.SCOPE.eq((Object)this.$this_getUid.getScope().name())).and(Tables.LIFECYCLE_EVENT.TYPE.eq((Object)this.$this_getUid.getType())).and(Tables.LIFECYCLE_EVENT.DELIVERY_CONFIG_NAME.eq((Object)this.$this_getUid.getDeliveryConfigName())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_REFERENCE.eq((Object)this.$this_getUid.getArtifactReference())).and(Tables.LIFECYCLE_EVENT.ARTIFACT_VERSION.eq((Object)this.$this_getUid.getArtifactVersion())).and(Tables.LIFECYCLE_EVENT.ID.eq((Object)this.$this_getUid.getId())).and(Tables.LIFECYCLE_EVENT.STATUS.eq((Object)this.$this_getUid.getStatus())).fetch((Field)Tables.LIFECYCLE_EVENT.UID);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(LIFECYCLE_EV\u2026etch(LIFECYCLE_EVENT.UID)");
                return (String)CollectionsKt.first((List)list);
            }
            {
                this.this$0 = sqlLifecycleEventRepository;
                this.$this_getUid = lifecycleEvent;
                super(0);
            }
        });
    }

    public SqlLifecycleEventRepository(@NotNull Clock clock, @NotNull DSLContext jooq, @NotNull SqlRetry sqlRetry, @NotNull Registry spectator, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        Intrinsics.checkNotNullParameter((Object)spectator, (String)"spectator");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        this.clock = clock;
        this.jooq = jooq;
        this.sqlRetry = sqlRetry;
        this.spectator = spectator;
        this.publisher = publisher;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlLifecycleEventRepository this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = sqlLifecycleEventRepository;
                super(0);
            }
        }));
        this.LIFECYCLE_STEP_CALCULATION_DURATION_ID = "keel.lifecycle.step.calculation.duration";
        this.LIFECYCLE_STEP_CALCULATION_ALL_DURATION_ID = "keel.lifecycle.step.calculation.all.duration";
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlLifecycleEventRepository $this) {
        return $this.jooq;
    }
}

