/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.keel.artifacts.BakedImage;
import com.netflix.spinnaker.keel.artifacts.DebianArtifact;
import com.netflix.spinnaker.keel.persistence.BakedImageRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlBakedImageRepository;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import java.time.Clock;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.RecordMapper;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlBakedImageRepository;", "Lcom/netflix/spinnaker/keel/persistence/BakedImageRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/keel/sql/SqlRetry;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getByArtifactVersion", "Lcom/netflix/spinnaker/keel/artifacts/BakedImage;", "version", "", "artifact", "Lcom/netflix/spinnaker/keel/artifacts/DebianArtifact;", "store", "", "image", "keel-sql"})
public final class SqlBakedImageRepository
implements BakedImageRepository {
    private final Lazy log$delegate;
    private final DSLContext jooq;
    private final Clock clock;
    private final ObjectMapper objectMapper;
    private final SqlRetry sqlRetry;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SqlBakedImageRepository sqlBakedImageRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public void store(@NotNull BakedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.getLog().debug("Storing baked image " + image);
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, image){
            final /* synthetic */ SqlBakedImageRepository this$0;
            final /* synthetic */ BakedImage $image;

            public final int invoke() {
                return SqlBakedImageRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.BAKED_IMAGES).set((Field)Tables.BAKED_IMAGES.IMAGE, (Object)SqlBakedImageRepository.access$getObjectMapper$p(this.this$0).writeValueAsString((Object)this.$image)).set((Field)Tables.BAKED_IMAGES.TIME_DETECTED, (Object)SqlBakedImageRepository.access$getClock$p(this.this$0).instant()).onDuplicateKeyUpdate().set((Field)Tables.BAKED_IMAGES.IMAGE, (Object)SqlBakedImageRepository.access$getObjectMapper$p(this.this$0).writeValueAsString((Object)this.$image)).set((Field)Tables.BAKED_IMAGES.TIME_DETECTED, (Object)SqlBakedImageRepository.access$getClock$p(this.this$0).instant()).execute();
            }
            {
                this.this$0 = sqlBakedImageRepository;
                this.$image = bakedImage;
                super(0);
            }
        });
    }

    @Nullable
    public BakedImage getByArtifactVersion(@NotNull String version, @NotNull DebianArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return (BakedImage)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<BakedImage>(this, version, artifact){
            final /* synthetic */ SqlBakedImageRepository this$0;
            final /* synthetic */ String $version;
            final /* synthetic */ DebianArtifact $artifact;

            @Nullable
            public final BakedImage invoke() {
                List list = SqlBakedImageRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.BAKED_IMAGES.IMAGE).from((TableLike)Tables.BAKED_IMAGES).where(Tables.BAKED_IMAGES.PACKAGE_VERSION.eq((Object)this.$version)).and(Tables.BAKED_IMAGES.CLOUD_PROVIDER.eq((Object)"aws")).and(Tables.BAKED_IMAGES.BASE_OS.eq((Object)this.$artifact.getVmOptions().getBaseOs())).and(Tables.BAKED_IMAGES.BASE_LABEL.eq((Object)this.$artifact.getVmOptions().getBaseLabel().name())).fetch((RecordMapper)new RecordMapper<Record1<String>, BakedImage>(this){
                    final /* synthetic */ getByArtifactVersion.1 this$0;

                    public final BakedImage map(Record1<String> $dstr$image) {
                        String image = (String)$dstr$image.component1();
                        return (BakedImage)SqlBakedImageRepository.access$getObjectMapper$p(this.this$0.this$0).readValue(image, BakedImage.class);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(BAK\u2026ge::class.java)\n        }");
                return (BakedImage)CollectionsKt.firstOrNull((List)list);
            }
            {
                this.this$0 = sqlBakedImageRepository;
                this.$version = string;
                this.$artifact = debianArtifact;
                super(0);
            }
        });
    }

    public SqlBakedImageRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper objectMapper, @NotNull SqlRetry sqlRetry) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        this.jooq = jooq;
        this.clock = clock;
        this.objectMapper = objectMapper;
        this.sqlRetry = sqlRetry;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlBakedImageRepository this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = sqlBakedImageRepository;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlBakedImageRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(SqlBakedImageRepository $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlBakedImageRepository $this) {
        return $this.clock;
    }
}

