/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.keel.api.DeliveryConfig;
import com.netflix.spinnaker.keel.api.Environment;
import com.netflix.spinnaker.keel.api.artifacts.ArtifactMetadata;
import com.netflix.spinnaker.keel.api.artifacts.ArtifactStatus;
import com.netflix.spinnaker.keel.api.artifacts.BuildMetadata;
import com.netflix.spinnaker.keel.api.artifacts.DeliveryArtifact;
import com.netflix.spinnaker.keel.api.artifacts.GitMetadata;
import com.netflix.spinnaker.keel.api.artifacts.PublishedArtifact;
import com.netflix.spinnaker.keel.api.plugins.ArtifactSupplier;
import com.netflix.spinnaker.keel.api.plugins.ArtifactSupplierKt;
import com.netflix.spinnaker.keel.artifacts.DockerArtifact;
import com.netflix.spinnaker.keel.core.api.ActionMetadata;
import com.netflix.spinnaker.keel.core.api.ArtifactSummaryInEnvironment;
import com.netflix.spinnaker.keel.core.api.ArtifactVersionStatus;
import com.netflix.spinnaker.keel.core.api.ArtifactVersions;
import com.netflix.spinnaker.keel.core.api.EnvironmentArtifactPin;
import com.netflix.spinnaker.keel.core.api.EnvironmentArtifactVeto;
import com.netflix.spinnaker.keel.core.api.EnvironmentArtifactVetoes;
import com.netflix.spinnaker.keel.core.api.EnvironmentSummary;
import com.netflix.spinnaker.keel.core.api.PinnedEnvironment;
import com.netflix.spinnaker.keel.core.api.PromotionStatus;
import com.netflix.spinnaker.keel.core.api.PublishedArtifactInEnvironment;
import com.netflix.spinnaker.keel.core.api.UIDKt;
import com.netflix.spinnaker.keel.persistence.ArtifactNotFoundException;
import com.netflix.spinnaker.keel.persistence.ArtifactRepository;
import com.netflix.spinnaker.keel.persistence.NoSuchArtifactException;
import com.netflix.spinnaker.keel.persistence.NoSuchArtifactVersionException;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ArtifactVersionsRecord;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentArtifactVersionsRecord;
import com.netflix.spinnaker.keel.services.StatusInfoForArtifactInEnvironment;
import com.netflix.spinnaker.keel.sql.ArtifactUtilsKt;
import com.netflix.spinnaker.keel.sql.JooqKt;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlArtifactRepository;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import com.netflix.spinnaker.keel.telemetry.AboutToBeChecked;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.xml.bind.DatatypeConverter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.InsertValuesStep6;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.Record11;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record7;
import org.jooq.Record9;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.SelectLimitPercentStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TransactionalRunnable;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.jooq.util.mysql.MySQLDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u001eH\u0016J\u0018\u0010+\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001aH\u0016J \u0010+\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001aH\u0016J\u0018\u0010+\u001a\u00020*2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001aH\u0002J(\u0010/\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J,\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a012\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001eH\u0002J(\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001aH\u0002J*\u00106\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u00103\u001a\u00020\u001a2\n\u00104\u001a\u00060\u001aj\u0002`72\u0006\u00105\u001a\u00020\u001aH\u0016J,\u00106\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u001a2\n\u00104\u001a\u00060\u001aj\u0002`72\u0006\u0010,\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001aH\u0016J\u0018\u00106\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001aH\u0016J(\u00108\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u000e\u00104\u001a\n\u0018\u00010\u001aj\u0004\u0018\u0001`72\b\u00103\u001a\u0004\u0018\u00010\u001aH\u0016J&\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u000b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001aH\u0016J*\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001aH\u0016J4\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u000b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u001a2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000bH\u0016J*\u0010C\u001a\u0004\u0018\u00010@2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0016J$\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J4\u0010H\u001a\u0004\u0018\u00010E2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020>2\b\u0010'\u001a\u0004\u0018\u00010\u001aH\u0016J,\u0010J\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001a2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020>0\u000bH\u0016J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u000b2\u0006\u0010%\u001a\u00020\u001bH\u0016J(\u0010N\u001a\u00020O2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0016J&\u0010P\u001a\b\u0012\u0004\u0012\u00020:0\u000b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001aH\u0002J&\u0010Q\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u001aH\u0016J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000b2\u0006\u0010%\u001a\u00020\u001bH\u0016J\"\u0010T\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u001aH\u0016J\u001a\u0010U\u001a\u0004\u0018\u00010G2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001aH\u0016J&\u0010V\u001a\b\u0012\u0004\u0012\u00020W0\u000b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001eH\u0016J\u001e\u0010X\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\u0006\u0010Y\u001a\u00020O2\u0006\u0010Z\u001a\u00020[H\u0016J(\u0010\\\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J(\u0010]\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0018\u0010^\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001aH\u0016J \u0010_\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0002J\u001c\u0010`\u001a\u00020$2\u0006\u00103\u001a\u00020\u001a2\n\u00104\u001a\u00060\u001aj\u0002`7H\u0016J\u001e\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001e0b2\u0006\u0010c\u001a\u00020[2\u0006\u0010Y\u001a\u00020OH\u0016J\"\u0010d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0016J(\u0010e\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J2\u0010f\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001a2\b\u0010g\u001a\u0004\u0018\u00010\u001aH\u0016J(\u0010h\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J \u0010i\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020$H\u0016J\u0018\u0010m\u001a\u00020*2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010n\u001a\u00020oH\u0016J\"\u0010p\u001a\u0004\u0018\u00010\u001a2\u0006\u0010q\u001a\u00020\u001a2\u0006\u0010r\u001a\u00020\u001a2\u0006\u0010s\u001a\u00020\u001aH\u0002J\u0010\u0010t\u001a\u00020*2\u0006\u0010&\u001a\u00020\u001eH\u0016J4\u0010u\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010v\u001a\u00020\u001a2\b\u0010s\u001a\u0004\u0018\u00010EJ,\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190x2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0002J\u0010\u0010y\u001a\u00020$2\u0006\u0010z\u001a\u00020EH\u0016J\u0018\u0010{\u001a\u00020*2\u0006\u0010&\u001a\u00020E2\u0006\u0010|\u001a\u00020}H\u0016J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020E0\u000b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020OH\u0016J\u0018\u0010~\u001a\u00020\u001a2\u0006\u0010\u007f\u001a\u00020\u001a2\u0006\u0010r\u001a\u00020\u001aH\u0002J\u0018\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\u000b2\u0006\u0010%\u001a\u00020\u001bH\u0016J)\u0010\u0082\u0001\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001aH\u0016J%\u0010\u0083\u0001\u001a\u00020**\u00020\u00032\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010j\u001a\u00020kH\u0002J\r\u0010\u0084\u0001\u001a\u00020\u001a*\u00020\u001eH\u0002J\u0016\u0010\u0085\u0001\u001a\u00030\u0086\u0001*\u00020\u001b2\u0006\u00103\u001a\u00020\u001aH\u0002J\f\u00102\u001a\u00020\u001a*\u00020\u001eH\u0002J#\u0010\u0087\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018*\u00020\u001b2\b\u0010\u0088\u0001\u001a\u00030\u0086\u0001H\u0002J!\u0010\u0087\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018*\u00020\u001b2\u0006\u0010<\u001a\u00020\u001aH\u0002J\u0017\u0010\u0089\u0001\u001a\u00020\u001a*\u00020\u001b2\b\u0010\u0088\u0001\u001a\u00030\u0086\u0001H\u0002J.\u0010\u008a\u0001\u001a\u00020**\u00020\u00032\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0007\u0010\u008b\u0001\u001a\u00020\u001aH\u0002J0\u0010\u008c\u0001\u001a\u00020**\u00020\u00032\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u001a2\u0006\u0010j\u001a\u00020k2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001aH\u0002R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001fR\u0018\u0010 \u001a\u00020\u001a*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006\u008d\u0001"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlArtifactRepository;", "Lcom/netflix/spinnaker/keel/persistence/ArtifactRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "artifactSuppliers", "", "Lcom/netflix/spinnaker/keel/api/plugins/ArtifactSupplier;", "publisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/keel/sql/SqlRetry;Ljava/util/List;Lorg/springframework/context/ApplicationEventPublisher;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "uid", "Lorg/jooq/Select;", "Lorg/jooq/Record1;", "", "Lcom/netflix/spinnaker/keel/api/DeliveryConfig;", "getUid", "(Lcom/netflix/spinnaker/keel/api/DeliveryConfig;)Lorg/jooq/Select;", "Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;", "(Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;)Lorg/jooq/Select;", "uidString", "getUidString", "(Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;)Ljava/lang/String;", "approveVersionFor", "", "deliveryConfig", "artifact", "version", "targetEnvironment", "delete", "", "deletePin", "reference", "envUid", "artUid", "deleteVeto", "environmentAndArtifactIds", "Lkotlin/Pair;", "fingerprint", "name", "type", "deliveryConfigName", "get", "Lcom/netflix/spinnaker/keel/api/artifacts/ArtifactType;", "getAll", "getAllVersionsForEnvironment", "Lcom/netflix/spinnaker/keel/core/api/PublishedArtifactInEnvironment;", "config", "environmentName", "getArtifactPromotionStatus", "Lcom/netflix/spinnaker/keel/core/api/PromotionStatus;", "getArtifactSummariesInEnvironment", "Lcom/netflix/spinnaker/keel/core/api/ArtifactSummaryInEnvironment;", "artifactReference", "versions", "getArtifactSummaryInEnvironment", "getArtifactVersion", "Lcom/netflix/spinnaker/keel/api/artifacts/PublishedArtifact;", "status", "Lcom/netflix/spinnaker/keel/api/artifacts/ArtifactStatus;", "getArtifactVersionByPromotionStatus", "promotionStatus", "getArtifactVersionsByStatus", "statuses", "getEnvironmentSummaries", "Lcom/netflix/spinnaker/keel/core/api/EnvironmentSummary;", "getNumPendingToBePromoted", "", "getPendingVersions", "getPendingVersionsInEnvironment", "getPinnedEnvironments", "Lcom/netflix/spinnaker/keel/core/api/PinnedEnvironment;", "getPinnedVersion", "getReleaseStatus", "getVersionInfoInEnvironment", "Lcom/netflix/spinnaker/keel/services/StatusInfoForArtifactInEnvironment;", "getVersionsWithoutMetadata", "limit", "maxAge", "Ljava/time/Duration;", "isApprovedFor", "isCurrentlyDeployedTo", "isDeployingTo", "isPinned", "isRegistered", "itemsDueForCheck", "", "minTimeSinceLastCheck", "latestVersionApprovedIn", "markAsDeployingTo", "markAsSkipped", "supersededByVersion", "markAsSuccessfullyDeployedTo", "markAsVetoedIn", "veto", "Lcom/netflix/spinnaker/keel/core/api/EnvironmentArtifactVeto;", "force", "pinEnvironment", "environmentArtifactPin", "Lcom/netflix/spinnaker/keel/core/api/EnvironmentArtifactPin;", "priorVersionDeployedIn", "environmentId", "artifactId", "currentVersion", "register", "removeExtra", "mjVersion", "selectPromotionReference", "Lorg/jooq/SelectConditionStep;", "storeArtifactVersion", "artifactVersion", "updateArtifactMetadata", "artifactMetadata", "Lcom/netflix/spinnaker/keel/api/artifacts/ArtifactMetadata;", "vetoKey", "envName", "vetoedEnvironmentVersions", "Lcom/netflix/spinnaker/keel/core/api/EnvironmentArtifactVetoes;", "wasSuccessfullyDeployedTo", "addRecordToEnvironmentArtifactVetoTable", "detailsAsJson", "environmentNamed", "Lcom/netflix/spinnaker/keel/api/Environment;", "getUidFor", "environment", "getUidStringFor", "setPromotionReference", "prior", "upsertAsVetoedInEnvironmentArtifactVersionsTable", "keel-sql"})
public final class SqlArtifactRepository
implements ArtifactRepository {
    private final Lazy log$delegate;
    private final DSLContext jooq;
    private final Clock clock;
    private final ObjectMapper objectMapper;
    private final SqlRetry sqlRetry;
    private final List<ArtifactSupplier<?, ?>> artifactSuppliers;
    private final ApplicationEventPublisher publisher;

    public void register(@NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String string = (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final String invoke() {
                return (String)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.DELIVERY_ARTIFACT.UID).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$artifact.getName()).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$artifact.getType())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$artifact.getDeliveryConfigName())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$artifact.getReference()))).fetchOne((Field)Tables.DELIVERY_ARTIFACT.UID);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
        if (string == null) {
            String string2 = UIDKt.randomUID().toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUID().toString()");
        }
        String id2 = string;
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, id2, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final int invoke() {
                SqlArtifactRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.DELIVERY_ARTIFACT).set((Field)Tables.DELIVERY_ARTIFACT.UID, (Object)this.$id).set((Field)Tables.DELIVERY_ARTIFACT.FINGERPRINT, (Object)SqlArtifactRepository.access$fingerprint(this.this$0, this.$artifact)).set((Field)Tables.DELIVERY_ARTIFACT.NAME, (Object)this.$artifact.getName()).set((Field)Tables.DELIVERY_ARTIFACT.TYPE, (Object)this.$artifact.getType()).set((Field)Tables.DELIVERY_ARTIFACT.REFERENCE, (Object)this.$artifact.getReference()).set((Field)Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME, (Object)this.$artifact.getDeliveryConfigName()).set((Field)Tables.DELIVERY_ARTIFACT.DETAILS, (Object)SqlArtifactRepository.access$detailsAsJson(this.this$0, this.$artifact)).onDuplicateKeyUpdate().set((Field)Tables.DELIVERY_ARTIFACT.REFERENCE, (Object)this.$artifact.getReference()).set((Field)Tables.DELIVERY_ARTIFACT.DETAILS, (Object)SqlArtifactRepository.access$detailsAsJson(this.this$0, this.$artifact)).execute();
                return SqlArtifactRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.ARTIFACT_LAST_CHECKED).set((Field)Tables.ARTIFACT_LAST_CHECKED.ARTIFACT_UID, (Object)this.$id).set((Field)Tables.ARTIFACT_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).onDuplicateKeyUpdate().set((Field)Tables.ARTIFACT_LAST_CHECKED.AT, (Object)Instant.EPOCH.plusSeconds(1L)).execute();
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$id = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    private final String detailsAsJson(DeliveryArtifact $this$detailsAsJson) {
        ObjectMapper $this$convertValue$iv = this.objectMapper;
        boolean $i$f$convertValue = false;
        DeliveryArtifact deliveryArtifact = $this$detailsAsJson;
        ObjectMapper objectMapper = $this$convertValue$iv;
        boolean $i$f$jacksonTypeRef = false;
        TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
        Map map = MapsKt.toMutableMap((Map)((Map)objectMapper.convertValue((Object)deliveryArtifact, typeReference)));
        boolean bl = false;
        boolean bl2 = false;
        Map it = map;
        boolean bl3 = false;
        it.remove("name");
        it.remove("deliveryConfigName");
        it.remove("type");
        it.remove("reference");
        Map details = map;
        String string = this.objectMapper.writeValueAsString((Object)details);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueAsString(details)");
        return string;
    }

    @NotNull
    public List<DeliveryArtifact> get(@NotNull String name, @NotNull String type, @NotNull String deliveryConfigName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        List list = (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<DeliveryArtifact>>(this, name, type, deliveryConfigName){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $type;
            final /* synthetic */ String $deliveryConfigName;

            public final List<DeliveryArtifact> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.DELIVERY_ARTIFACT.DETAILS, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$name)).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$type)).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$deliveryConfigName)).fetch((RecordMapper)new RecordMapper<Record2<String, String>, DeliveryArtifact>(this){
                    final /* synthetic */ get.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final DeliveryArtifact map(Record2<String, String> $dstr$details$reference) {
                        void details;
                        String string = (String)$dstr$details$reference.component1();
                        String reference = (String)$dstr$details$reference.component2();
                        ArtifactSupplier artifactSupplier = ArtifactSupplierKt.supporting((List)SqlArtifactRepository.access$getArtifactSuppliers$p(this.this$0.this$0), (String)this.this$0.$type);
                        String string2 = this.this$0.$name;
                        String string3 = this.this$0.$type;
                        void v3 = details;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"details");
                        String string4 = reference;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"reference");
                        return ArtifactUtilsKt.mapToArtifact(artifactSupplier, string2, string3, (String)v3, string4, this.this$0.$deliveryConfigName);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$name = string;
                this.$type = string2;
                this.$deliveryConfigName = string3;
                super(0);
            }
        });
        if (list == null) {
            throw (Throwable)new NoSuchArtifactException(name, type);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DeliveryArtifact get(@NotNull String name, @NotNull String type, @NotNull String reference, @NotNull String deliveryConfigName) {
        Record2 record2;
        block3: {
            block2: {
                void details;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
                record2 = (Record2)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Record2<String, String>>(this, name, type, deliveryConfigName, reference){
                    final /* synthetic */ SqlArtifactRepository this$0;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $type;
                    final /* synthetic */ String $deliveryConfigName;
                    final /* synthetic */ String $reference;

                    public final Record2<String, String> invoke() {
                        return (Record2)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.DELIVERY_ARTIFACT.DETAILS, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$name)).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$type)).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$deliveryConfigName)).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$reference)).fetchOne();
                    }
                    {
                        this.this$0 = sqlArtifactRepository;
                        this.$name = string;
                        this.$type = string2;
                        this.$deliveryConfigName = string3;
                        this.$reference = string4;
                        super(0);
                    }
                });
                if (record2 == null) break block2;
                Record2 record22 = record2;
                boolean bl = false;
                boolean bl2 = false;
                Record2 $dstr$details$reference = record22;
                boolean bl3 = false;
                String string = (String)$dstr$details$reference.component1();
                String reference2 = (String)$dstr$details$reference.component2();
                ArtifactSupplier artifactSupplier = ArtifactSupplierKt.supporting(this.artifactSuppliers, (String)type);
                void v2 = details;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"details");
                String string2 = reference2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reference");
                record2 = ArtifactUtilsKt.mapToArtifact(artifactSupplier, name, type, (String)v2, string2, deliveryConfigName);
                if (record2 != null) break block3;
            }
            throw (Throwable)new ArtifactNotFoundException(reference, deliveryConfigName);
        }
        return record2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DeliveryArtifact get(@NotNull String deliveryConfigName, @NotNull String reference) {
        Record4 record4;
        block3: {
            block2: {
                void reference2;
                void details;
                void name;
                String type;
                Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                record4 = (Record4)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Record4<String, String, String, String>>(this, deliveryConfigName, reference){
                    final /* synthetic */ SqlArtifactRepository this$0;
                    final /* synthetic */ String $deliveryConfigName;
                    final /* synthetic */ String $reference;

                    public final Record4<String, String, String, String> invoke() {
                        return (Record4)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.DELIVERY_ARTIFACT.NAME, (SelectField)Tables.DELIVERY_ARTIFACT.DETAILS, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE, (SelectField)Tables.DELIVERY_ARTIFACT.TYPE).from((TableLike)Tables.DELIVERY_ARTIFACT).where(new Condition[]{Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$deliveryConfigName), Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$reference)}).fetchOne();
                    }
                    {
                        this.this$0 = sqlArtifactRepository;
                        this.$deliveryConfigName = string;
                        this.$reference = string2;
                        super(0);
                    }
                });
                if (record4 == null) break block2;
                Record4 record42 = record4;
                boolean bl = false;
                boolean bl2 = false;
                Record4 $dstr$name$details$reference$type = record42;
                boolean bl3 = false;
                String string = (String)$dstr$name$details$reference$type.component1();
                String string2 = (String)$dstr$name$details$reference$type.component2();
                String string3 = (String)$dstr$name$details$reference$type.component3();
                String string4 = type = (String)$dstr$name$details$reference$type.component4();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"type");
                ArtifactSupplier artifactSupplier = ArtifactSupplierKt.supporting(this.artifactSuppliers, (String)string4);
                void v3 = name;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"name");
                void v4 = details;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"details");
                void v5 = reference2;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"reference");
                record4 = ArtifactUtilsKt.mapToArtifact(artifactSupplier, (String)v3, type, (String)v4, (String)v5, deliveryConfigName);
                if (record4 != null) break block3;
            }
            throw (Throwable)new ArtifactNotFoundException(reference, deliveryConfigName);
        }
        return record4;
    }

    public void delete(@NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String string = artifact.getDeliveryConfigName();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Error removing artifact - it has no delivery config!";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.jooq.transaction(new TransactionalRunnable(this, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final void run(Configuration config) {
                DSLContext txn = DSL.using((Configuration)config);
                txn.deleteFrom((Table)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).execute();
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
            }
        });
    }

    public boolean isRegistered(@NotNull String name, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return ((Number)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Integer>(this, name, type){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ String $type;

            public final Integer invoke() {
                return (Integer)((Record1)SqlArtifactRepository.access$getJooq$p(this.this$0).selectCount().from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$name)).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$type)).fetchSingle()).value1();
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$name = string;
                this.$type = string2;
                super(0);
            }
        })).intValue() > 0;
    }

    @NotNull
    public List<DeliveryArtifact> getAll(@Nullable String type, @Nullable String name) {
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<DeliveryArtifact>>(this, type, name){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $type;
            final /* synthetic */ String $name;

            public final List<DeliveryArtifact> invoke() {
                SelectJoinStep selectJoinStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.DELIVERY_ARTIFACT.NAME, (SelectField)Tables.DELIVERY_ARTIFACT.TYPE, (SelectField)Tables.DELIVERY_ARTIFACT.DETAILS, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE, (SelectField)Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME).from((TableLike)Tables.DELIVERY_ARTIFACT);
                boolean bl = false;
                boolean bl2 = false;
                SelectJoinStep $this$apply = selectJoinStep;
                boolean bl3 = false;
                if (this.$type != null) {
                    $this$apply.where(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$type.toString()));
                }
                bl = false;
                bl2 = false;
                $this$apply = selectJoinStep;
                boolean bl4 = false;
                if (this.$name != null) {
                    $this$apply.where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$name));
                }
                return selectJoinStep.fetch((RecordMapper)new RecordMapper<Record5<String, String, String, String, String>, DeliveryArtifact>(this){
                    final /* synthetic */ getAll.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final DeliveryArtifact map(Record5<String, String, String, String, String> $dstr$name$storedType$details$reference$configName) {
                        void reference;
                        void details;
                        void name;
                        void storedType;
                        String string = (String)$dstr$name$storedType$details$reference$configName.component1();
                        String string2 = (String)$dstr$name$storedType$details$reference$configName.component2();
                        String string3 = (String)$dstr$name$storedType$details$reference$configName.component3();
                        String string4 = (String)$dstr$name$storedType$details$reference$configName.component4();
                        String configName = (String)$dstr$name$storedType$details$reference$configName.component5();
                        List list = SqlArtifactRepository.access$getArtifactSuppliers$p(this.this$0.this$0);
                        void v1 = storedType;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"storedType");
                        ArtifactSupplier artifactSupplier = ArtifactSupplierKt.supporting((List)list, (String)v1);
                        void v3 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"name");
                        void var7_7 = storedType;
                        boolean bl = false;
                        String string5 = var7_7.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                        void v5 = details;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"details");
                        void v6 = reference;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"reference");
                        String string6 = configName;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"configName");
                        return ArtifactUtilsKt.mapToArtifact(artifactSupplier, (String)v3, string5, (String)v5, (String)v6, string6);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$type = string;
                this.$name = string2;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026nfigName)\n        }\n    }");
        return (List)t;
    }

    @NotNull
    public List<PublishedArtifact> versions(@NotNull DeliveryArtifact artifact, int limit) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Retry retry2 = Retry.of((String)"artifact registered", (RetryConfig)RetryConfig.custom().maxAttempts(5).waitDuration(Duration.ofMillis(100L)).retryOnResult((Predicate)new Predicate<Boolean>(this, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final boolean test(Boolean registered2) {
                boolean bl;
                if (!registered2.booleanValue()) {
                    SqlArtifactRepository.access$getLog$p(this.this$0).debug("Retrying registered check for " + this.$artifact);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
            }
        }).build());
        Boolean registered2 = (Boolean)retry2.executeSupplier((Supplier)new Supplier<Boolean>(this, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final Boolean get() {
                return this.this$0.isRegistered(this.$artifact.getName(), this.$artifact.getType());
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
            }
        });
        if (!registered2.booleanValue()) {
            throw (Throwable)new NoSuchArtifactException(artifact);
        }
        return (List)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<? extends PublishedArtifact>>(this, artifact, limit){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ int $limit;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<PublishedArtifact> invoke() {
                void $this$mapTo$iv$iv;
                SelectConditionStep selectConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from((TableLike)Tables.ARTIFACT_VERSIONS).where(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$artifact.getType()));
                Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n        .select(\n  \u2026S.TYPE.eq(artifact.type))");
                Iterable $this$map$iv = ArtifactUtilsKt.fetchSortedArtifactVersions((SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)selectConditionStep, this.$artifact, this.$limit);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PublishedArtifact publishedArtifact = (PublishedArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    PublishedArtifact publishedArtifact2 = PublishedArtifact.copy$default((PublishedArtifact)it, null, null, (String)this.$artifact.getReference(), null, null, null, null, null, null, null, null, null, (int)4091, null);
                    collection.add(publishedArtifact2);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                this.$limit = n;
                super(0);
            }
        });
    }

    @NotNull
    public List<PublishedArtifact> getVersionsWithoutMetadata(int limit, @NotNull Duration maxAge) {
        Intrinsics.checkNotNullParameter((Object)maxAge, (String)"maxAge");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<PublishedArtifact>>(this, maxAge, limit){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Duration $maxAge;
            final /* synthetic */ int $limit;

            public final List<PublishedArtifact> invoke() {
                SelectJoinStep selectJoinStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from((TableLike)Tables.ARTIFACT_VERSIONS);
                TableField<ArtifactVersionsRecord, GitMetadata> tableField = Tables.ARTIFACT_VERSIONS.GIT_METADATA;
                Intrinsics.checkNotNullExpressionValue(tableField, (String)"ARTIFACT_VERSIONS.GIT_METADATA");
                SelectConditionStep selectConditionStep = selectJoinStep.where(tableField.isNull());
                TableField<ArtifactVersionsRecord, BuildMetadata> tableField2 = Tables.ARTIFACT_VERSIONS.BUILD_METADATA;
                Intrinsics.checkNotNullExpressionValue(tableField2, (String)"ARTIFACT_VERSIONS.BUILD_METADATA");
                SelectLimitPercentStep selectLimitPercentStep = selectConditionStep.or(tableField2.isNull()).and(Tables.ARTIFACT_VERSIONS.CREATED_AT.ge((Object)SqlArtifactRepository.access$getClock$p(this.this$0).instant().minus(this.$maxAge))).limit(this.$limit);
                Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"jooq\n        .select(\n  \u2026)))\n        .limit(limit)");
                return ArtifactUtilsKt.fetchArtifactVersions((ResultQuery<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)((ResultQuery)selectLimitPercentStep));
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$maxAge = duration;
                this.$limit = n;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026hArtifactVersions()\n    }");
        return (List)t;
    }

    public boolean storeArtifactVersion(@NotNull PublishedArtifact artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        boolean bl = false;
        boolean bl2 = false;
        PublishedArtifact $this$with = artifactVersion;
        boolean bl3 = false;
        if (!this.isRegistered($this$with.getName(), $this$with.getType())) {
            throw (Throwable)new NoSuchArtifactException($this$with.getName(), $this$with.getType());
        }
        return ((Number)this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>($this$with, this){
            final /* synthetic */ PublishedArtifact $this_with;
            final /* synthetic */ SqlArtifactRepository this$0;
            {
                this.$this_with = publishedArtifact;
                this.this$0 = sqlArtifactRepository;
                super(0);
            }

            public final int invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.ARTIFACT_VERSIONS).set((Field)Tables.ARTIFACT_VERSIONS.NAME, (Object)this.$this_with.getName()).set((Field)Tables.ARTIFACT_VERSIONS.TYPE, (Object)this.$this_with.getType()).set((Field)Tables.ARTIFACT_VERSIONS.VERSION, (Object)this.$this_with.getVersion()).set((Field)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (Object)this.$this_with.getStatus()).set((Field)Tables.ARTIFACT_VERSIONS.CREATED_AT, (Object)this.$this_with.getCreatedAt()).set((Field)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (Object)this.$this_with.getGitMetadata()).set((Field)Tables.ARTIFACT_VERSIONS.BUILD_METADATA, (Object)this.$this_with.getBuildMetadata()).onDuplicateKeyIgnore().execute();
            }
        })).intValue() == 1;
    }

    @Nullable
    public PublishedArtifact getArtifactVersion(@NotNull DeliveryArtifact artifact, @NotNull String version, @Nullable ArtifactStatus status) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return (PublishedArtifact)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<PublishedArtifact>(this, artifact, version, status){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;
            final /* synthetic */ ArtifactStatus $status;

            public final PublishedArtifact invoke() {
                SelectConditionStep selectConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from((TableLike)Tables.ARTIFACT_VERSIONS).where(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$artifact.getType())).and(Tables.ARTIFACT_VERSIONS.VERSION.eq((Object)this.$version));
                boolean bl = false;
                boolean bl2 = false;
                SelectConditionStep $this$apply = selectConditionStep;
                boolean bl3 = false;
                if (this.$status != null) {
                    $this$apply.and(Tables.ARTIFACT_VERSIONS.RELEASE_STATUS.eq((Object)this.$status));
                }
                return (PublishedArtifact)selectConditionStep.fetchOne((RecordMapper)getArtifactVersion.2.INSTANCE);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                this.$status = artifactStatus;
                super(0);
            }
        });
    }

    public void updateArtifactMetadata(@NotNull PublishedArtifact artifact, @NotNull ArtifactMetadata artifactMetadata) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)artifactMetadata, (String)"artifactMetadata");
        boolean bl = false;
        boolean bl2 = false;
        PublishedArtifact $this$with = artifact;
        boolean bl3 = false;
        if (!this.isRegistered($this$with.getName(), $this$with.getType())) {
            throw (Throwable)new NoSuchArtifactException($this$with.getName(), $this$with.getType());
        }
        ((Number)this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>($this$with, this, artifactMetadata){
            final /* synthetic */ PublishedArtifact $this_with;
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ ArtifactMetadata $artifactMetadata$inlined;
            {
                this.$this_with = publishedArtifact;
                this.this$0 = sqlArtifactRepository;
                this.$artifactMetadata$inlined = artifactMetadata;
                super(0);
            }

            public final int invoke() {
                UpdateConditionStep updateConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).update((Table)Tables.ARTIFACT_VERSIONS).set((Field)Tables.ARTIFACT_VERSIONS.BUILD_METADATA, (Object)this.$artifactMetadata$inlined.getBuildMetadata()).set((Field)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (Object)this.$artifactMetadata$inlined.getGitMetadata()).where(new Condition[]{Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$this_with.getName()), Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$this_with.getType()), Tables.ARTIFACT_VERSIONS.VERSION.eq((Object)this.$this_with.getVersion()).or(Tables.ARTIFACT_VERSIONS.VERSION.eq((Object)(this.$this_with.getName() + '-' + this.$this_with.getVersion())))});
                boolean bl = false;
                boolean bl2 = false;
                UpdateConditionStep $this$apply = updateConditionStep;
                boolean bl3 = false;
                if (this.$this_with.getStatus() != null) {
                    $this$apply.and(Tables.ARTIFACT_VERSIONS.RELEASE_STATUS.eq((Object)this.$this_with.getStatus()));
                }
                return updateConditionStep.execute();
            }
        })).intValue();
    }

    @Nullable
    public ArtifactStatus getReleaseStatus(@NotNull DeliveryArtifact artifact, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.isRegistered(artifact.getName(), artifact.getType())) {
            throw (Throwable)new NoSuchArtifactException(artifact);
        }
        return (ArtifactStatus)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<ArtifactStatus>(this, artifact, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;

            public final ArtifactStatus invoke() {
                return (ArtifactStatus)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS).from((TableLike)Tables.ARTIFACT_VERSIONS).where(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$artifact.getType())).and(Tables.ARTIFACT_VERSIONS.VERSION.eq((Object)this.$version)).fetchOne((Field)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                super(0);
            }
        });
    }

    @Nullable
    public String latestVersionApprovedIn(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        Select<Record1<String>> envUid = this.getUidFor(deliveryConfig, environment);
        Select<Record1<String>> artifactId = this.getUid(artifact);
        String string = (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, envUid, artifactId){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Select $envUid;
            final /* synthetic */ Select $artifactId;

            public final String invoke() {
                return (String)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq(this.$envUid), Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq(this.$artifactId)}).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$envUid = select;
                this.$artifactId = select2;
                super(0);
            }
        });
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return it;
        }
        return (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, envUid, artifactId, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Select $envUid;
            final /* synthetic */ Select $artifactId;
            final /* synthetic */ DeliveryArtifact $artifact;

            @Nullable
            public final String invoke() {
                SelectConditionStep selectConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from(new TableLike[]{(TableLike)Tables.ARTIFACT_VERSIONS, (TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS}).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Field)Tables.ARTIFACT_VERSIONS.VERSION)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.$envUid)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(this.$artifactId));
                TableField<EnvironmentArtifactVersionsRecord, Instant> tableField = Tables.ENVIRONMENT_ARTIFACT_VERSIONS.APPROVED_AT;
                Intrinsics.checkNotNullExpressionValue(tableField, (String)"ENVIRONMENT_ARTIFACT_VERSIONS.APPROVED_AT");
                SelectLimitPercentStep selectLimitPercentStep = selectConditionStep.and(tableField.isNotNull()).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.ne((Object)PromotionStatus.VETOED)).orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.APPROVED_AT.desc()).limit(20);
                Intrinsics.checkNotNullExpressionValue((Object)selectLimitPercentStep, (String)"jooq\n        .select(\n  \u2026esc())\n        .limit(20)");
                List<PublishedArtifact> list = ArtifactUtilsKt.fetchArtifactVersions((ResultQuery<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)((ResultQuery)selectLimitPercentStep));
                Intrinsics.checkNotNullExpressionValue(list, (String)"jooq\n        .select(\n  \u2026 .fetchArtifactVersions()");
                PublishedArtifact publishedArtifact = (PublishedArtifact)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)list, (Comparator)this.$artifact.getSortingStrategy().getComparator()));
                return publishedArtifact != null ? publishedArtifact.getVersion() : null;
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$envUid = select;
                this.$artifactId = select2;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    public boolean approveVersionFor(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        return ((Number)this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, deliveryConfig, environment, artifact, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ Environment $environment;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;

            public final int invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID, SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environment)).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact)).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (Object)this.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.APPROVED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0).instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.APPROVED).onDuplicateKeyIgnore().execute();
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environment = environment;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                super(0);
            }
        })).intValue() > 0;
    }

    public boolean isApprovedFor(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        return (Boolean)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Boolean>(this, deliveryConfig, environment, artifact, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ Environment $environment;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;

            public final boolean invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).fetchExists((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS, Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environment)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$version)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.ne((Object)PromotionStatus.VETOED)));
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environment = environment;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                super(0);
            }
        });
    }

    public boolean wasSuccessfullyDeployedTo(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        return (Boolean)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Boolean>(this, deliveryConfig, environment, artifact, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ Environment $environment;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;

            public final boolean invoke() {
                DSLContext dSLContext = SqlArtifactRepository.access$getJooq$p(this.this$0);
                Table table = (Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS;
                Condition condition = Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environment)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$version));
                TableField<EnvironmentArtifactVersionsRecord, Instant> tableField = Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT;
                Intrinsics.checkNotNullExpressionValue(tableField, (String)"ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT");
                return dSLContext.fetchExists(table, condition.and(tableField.isNotNull()).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.in((Collection)CollectionsKt.listOf((Object[])new PromotionStatus[]{PromotionStatus.CURRENT, PromotionStatus.PREVIOUS}))));
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environment = environment;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                super(0);
            }
        });
    }

    public boolean isCurrentlyDeployedTo(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        return (Boolean)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Boolean>(this, deliveryConfig, environment, artifact, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ Environment $environment;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;

            public final boolean invoke() {
                DSLContext dSLContext = SqlArtifactRepository.access$getJooq$p(this.this$0);
                Table table = (Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS;
                Condition condition = Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environment)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$version));
                TableField<EnvironmentArtifactVersionsRecord, Instant> tableField = Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT;
                Intrinsics.checkNotNullExpressionValue(tableField, (String)"ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT");
                return dSLContext.fetchExists(table, condition.and(tableField.isNotNull()).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.CURRENT)));
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environment = environment;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                super(0);
            }
        });
    }

    public void markAsDeployingTo(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        Select<Record1<String>> environmentUid = this.getUidFor(deliveryConfig, environment);
        Instant now = this.clock.instant();
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, environmentUid, artifact, version, deliveryConfig, now){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Select $environmentUid;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ Instant $now;

            public final void invoke() {
                SqlArtifactRepository.access$getJooq$p(this.this$0).transaction(new TransactionalRunnable(this){
                    final /* synthetic */ markAsDeployingTo.1 this$0;

                    public final void run(Configuration config) {
                        List stuckVersions;
                        DSLContext txn = DSL.using((Configuration)config);
                        List list = stuckVersions = txn.select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.DEPLOYING)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.ne((Object)this.this$0.$version)).fetch((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stuckVersions");
                        Collection collection = list;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            SqlArtifactRepository.access$getLog$p(this.this$0.this$0).error("Stuck deploying versions " + CollectionsKt.joinToString$default((Iterable)stuckVersions, null, null, null, (int)0, null, null, (int)63, null) + " for artifact '" + this.this$0.$artifact.getReference() + "' in delivery config " + this.this$0.$deliveryConfig.getName() + " found when deploying version " + this.this$0.$version);
                            txn.update((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.SKIPPED).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (Object)this.this$0.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT, (Object)this.this$0.$now).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.DEPLOYING)).execute();
                        }
                        txn.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID, this.this$0.$environmentUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact)).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (Object)this.this$0.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.DEPLOYING).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.DEPLOYING).execute();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$environmentUid = select;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                this.$deliveryConfig = deliveryConfig;
                this.$now = instant;
                super(0);
            }
        });
    }

    public boolean isDeployingTo(@NotNull DeliveryConfig deliveryConfig, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        return ((Number)this.jooq.selectCount().from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.getUidFor(deliveryConfig, targetEnvironment))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.DEPLOYING)).fetchOneInto(Integer.TYPE)).intValue() > 0;
    }

    public void markAsSuccessfullyDeployedTo(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        Select<Record1<String>> environmentUid = this.getUidFor(deliveryConfig, environment);
        String environmentUidString = this.getUidStringFor(deliveryConfig, environment);
        String artifactUid = this.getUidString(artifact);
        PublishedArtifact publishedArtifact = ArtifactRepository.DefaultImpls.getArtifactVersion$default((ArtifactRepository)this, (DeliveryArtifact)artifact, (String)version, null, (int)4, null);
        if (publishedArtifact == null) {
            throw (Throwable)new NoSuchArtifactVersionException(artifact, version);
        }
        PublishedArtifact artifactVersion = publishedArtifact;
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, artifact, version, targetEnvironment, environmentUid, artifactVersion, deliveryConfig, environmentUidString, artifactUid){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;
            final /* synthetic */ String $targetEnvironment;
            final /* synthetic */ Select $environmentUid;
            final /* synthetic */ PublishedArtifact $artifactVersion;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentUidString;
            final /* synthetic */ String $artifactUid;

            public final void invoke() {
                SqlArtifactRepository.access$getJooq$p(this.this$0).transaction(new TransactionalRunnable(this){
                    final /* synthetic */ markAsSuccessfullyDeployedTo.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run(Configuration config) {
                        String[] $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        Collection $this$map$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        String[] $this$toTypedArray$iv2;
                        String string;
                        Collection collection;
                        void $this$mapTo$iv$iv2;
                        Collection $this$map$iv2;
                        PublishedArtifact it;
                        void $this$filterTo$iv$iv2;
                        Iterable $this$filter$iv2;
                        DSLContext txn = DSL.using((Configuration)config);
                        SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: start transaction. name: " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        int currentUpdates = txn.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID, this.this$0.$environmentUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact)).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (Object)this.this$0.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0.this$0).instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.CURRENT).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0.this$0).instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.CURRENT).execute();
                        SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of records marked CURRENT: " + currentUpdates + ". name: " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        int previousUpdates = txn.update((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.PREVIOUS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (Object)this.this$0.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0.this$0).instant()).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.CURRENT)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.ne((Object)this.this$0.$version)).execute();
                        SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of records marked PREVIOUS: " + previousUpdates + ". name: " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        SelectConditionStep selectConditionStep = txn.select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from(new TableLike[]{(TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS, (TableLike)Tables.DELIVERY_ARTIFACT, (TableLike)Tables.ARTIFACT_VERSIONS}).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.APPROVED)).and(Tables.DELIVERY_ARTIFACT.UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID)).and(Tables.ARTIFACT_VERSIONS.NAME.eq((Field)Tables.DELIVERY_ARTIFACT.NAME)).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Field)Tables.DELIVERY_ARTIFACT.TYPE)).and(Tables.ARTIFACT_VERSIONS.VERSION.eq((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION));
                        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"txn.select(\n          AR\u2026RSIONS.ARTIFACT_VERSION))");
                        List approved = ArtifactUtilsKt.fetchSortedArtifactVersions$default(selectConditionStep, this.this$0.$artifact, null, 2, null);
                        SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of records marked APPROVED: " + approved.size() + ". name: " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        Iterable iterable = approved;
                        boolean $i$f$filter = false;
                        void var9_12 = $this$filter$iv2;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv2) {
                            it = (PublishedArtifact)element$iv$iv;
                            boolean bl = false;
                            if (!this.this$0.this$0.isOlder(this.this$0.$artifact, it, this.this$0.$artifactVersion)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv2 = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv2 = $this$map$iv2;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            it = (PublishedArtifact)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            string = it.getVersion();
                            collection.add(string);
                        }
                        $this$map$iv2 = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray22 = false;
                        String[] thisCollection$iv = $this$toTypedArray$iv2;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] approvedButOld = stringArray;
                        SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of approvedButOld: " + approvedButOld.length + ". " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        $this$toTypedArray$iv2 = approvedButOld;
                        $i$f$toTypedArray22 = false;
                        thisCollection$iv = $this$toTypedArray$iv2;
                        boolean destination$iv$iv32 = false;
                        if (!(thisCollection$iv.length == 0)) {
                            int skippedUpdates = txn.update((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.SKIPPED).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (Object)this.this$0.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0.this$0).instant()).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$environmentUid)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.this$0.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.APPROVED)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.in((Object[])Arrays.copyOf(approvedButOld, approvedButOld.length))).execute();
                            SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of records marked SKIPPED: " + skippedUpdates + ". name: " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        }
                        Iterable $i$f$toTypedArray22 = this.this$0.this$0.getPendingVersionsInEnvironment(this.this$0.$deliveryConfig, this.this$0.$artifact.getReference(), this.this$0.$targetEnvironment);
                        boolean $i$f$filter2 = false;
                        void destination$iv$iv32 = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>();
                        boolean $i$f$filterTo2 = false;
                        for (E element$iv$iv : $this$filterTo$iv$iv) {
                            PublishedArtifact it2 = (PublishedArtifact)element$iv$iv;
                            boolean bl = false;
                            if (!this.this$0.this$0.isOlder(this.this$0.$artifact, it2, this.this$0.$artifactVersion)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv2;
                        boolean $i$f$map2 = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            PublishedArtifact it2 = (PublishedArtifact)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl = false;
                            string = it2.getVersion();
                            collection.add(string);
                        }
                        $this$map$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv2), (int)100);
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv2 = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
                        if (stringArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        String[] pendingButOld = stringArray2;
                        SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of pendingButOld: " + pendingButOld.length + ". " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        $this$toTypedArray$iv = pendingButOld;
                        boolean bl = false;
                        String[] stringArray3 = $this$toTypedArray$iv;
                        boolean bl2 = false;
                        if (!(stringArray3.length == 0)) {
                            InsertValuesStep6 insertValuesStep6 = txn.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS, (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID, (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT);
                            boolean bl3 = false;
                            bl2 = false;
                            InsertValuesStep6 $this$apply = insertValuesStep6;
                            boolean bl4 = false;
                            String[] $this$forEach$iv = pendingButOld;
                            boolean $i$f$forEach = false;
                            String[] stringArray4 = $this$forEach$iv;
                            int n = stringArray4.length;
                            for (int i = 0; i < n; ++i) {
                                String element$iv;
                                String it3 = element$iv = stringArray4[i];
                                boolean bl5 = false;
                                $this$apply.values((Object)this.this$0.$environmentUidString, (Object)this.this$0.$artifactUid, (Object)it3, (Object)PromotionStatus.SKIPPED, (Object)this.this$0.$version, (Object)SqlArtifactRepository.access$getClock$p(this.this$0.this$0).instant());
                            }
                            int skippedUpdates = insertValuesStep6.execute();
                            SqlArtifactRepository.access$getLog$p(this.this$0.this$0).debug("markAsSuccessfullyDeployedTo: # of pending versions marked SKIPPED: " + skippedUpdates + ". name: " + this.this$0.$artifact.getName() + ". version: " + this.this$0.$version + ". env: " + this.this$0.$targetEnvironment);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                this.$targetEnvironment = string2;
                this.$environmentUid = select;
                this.$artifactVersion = publishedArtifact;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentUidString = string3;
                this.$artifactUid = string4;
                super(0);
            }
        });
        this.getLog().debug("markAsSuccessfullyDeployedTo complete. name: " + artifact.getName() + ". version: " + version + ". env: " + targetEnvironment);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<EnvironmentArtifactVetoes> vetoedEnvironmentVersions(@NotNull DeliveryConfig deliveryConfig) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Iterable $this$associateBy$iv = deliveryConfig.getArtifacts();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DeliveryArtifact deliveryArtifact = (DeliveryArtifact)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = this.getUidString((DeliveryArtifact)it);
            map.put(string, element$iv$iv);
        }
        Map artifactsById = destination$iv$iv;
        boolean bl = false;
        Map vetoes = new LinkedHashMap();
        this.jooq.select((SelectField)Tables.ENVIRONMENT.NAME, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT).innerJoin((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).on(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq((Field)Tables.ENVIRONMENT.UID)).where(new Condition[]{Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq(this.getUid(deliveryConfig)), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)PromotionStatus.VETOED)}).fetch((RecordMapper)new RecordMapper<Record3<String, String, String>, Unit>(this, artifactsById, vetoes, deliveryConfig){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Map $artifactsById;
            final /* synthetic */ Map $vetoes;
            final /* synthetic */ DeliveryConfig $deliveryConfig;

            /*
             * WARNING - void declaration
             */
            public final void map(Record3<String, String, String> $dstr$envName$artifactId$version) {
                void artifactId;
                String string = (String)$dstr$envName$artifactId$version.component1();
                String string2 = (String)$dstr$envName$artifactId$version.component2();
                String version = (String)$dstr$envName$artifactId$version.component3();
                if (this.$artifactsById.containsKey(artifactId)) {
                    Object object;
                    void key$iv;
                    void $this$getOrPut$iv;
                    void envName;
                    Map map = this.$vetoes;
                    void v0 = envName;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"envName");
                    void v1 = artifactId;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"artifactId");
                    String string3 = SqlArtifactRepository.access$vetoKey(this.this$0, (String)v0, (String)v1);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        DeliveryArtifact deliveryArtifact = (DeliveryArtifact)this.$artifactsById.get(artifactId);
                        if (deliveryArtifact == null) {
                            String string4 = "Invalid artifactId " + (String)artifactId + " for deliveryConfig " + this.$deliveryConfig.getName();
                            boolean bl2 = false;
                            throw (Throwable)new IllegalStateException(string4.toString());
                        }
                        boolean bl3 = false;
                        EnvironmentArtifactVetoes answer$iv = new EnvironmentArtifactVetoes(this.$deliveryConfig.getName(), (String)envName, deliveryArtifact, (Set)new LinkedHashSet<E>());
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Set set = ((EnvironmentArtifactVetoes)object).getVersions();
                    String string5 = version;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"version");
                    set.add(string5);
                }
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifactsById = map;
                this.$vetoes = map2;
                this.$deliveryConfig = deliveryConfig;
            }
        });
        return CollectionsKt.toList((Iterable)vetoes.values());
    }

    /*
     * WARNING - void declaration
     */
    public boolean markAsVetoedIn(@NotNull DeliveryConfig deliveryConfig, @NotNull EnvironmentArtifactVeto veto, boolean force) {
        void envUid;
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)veto, (String)"veto");
        DeliveryArtifact deliveryArtifact = deliveryConfig.matchingArtifactByReference(veto.getReference());
        if (deliveryArtifact == null) {
            throw (Throwable)new ArtifactNotFoundException(veto.getReference(), deliveryConfig.getName());
        }
        DeliveryArtifact artifact = deliveryArtifact;
        Object object = this.environmentAndArtifactIds(deliveryConfig, veto.getTargetEnvironment(), artifact);
        String string = (String)object.component1();
        String artUid = (String)object.component2();
        if (this.isPinned((String)envUid, artUid, veto.getVersion())) {
            this.getLog().warn("Pinned artifact version cannot be vetoed: " + "deliveryConfig=" + deliveryConfig.getName() + ", " + "environment=" + veto.getTargetEnvironment() + ", " + "artifactVersion=" + veto.getVersion());
            return false;
        }
        String string2 = (String)this.selectPromotionReference((String)envUid, artUid, veto.getVersion()).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE);
        if (string2 != null) {
            object = string2;
            boolean bl = false;
            boolean bl2 = false;
            Object reference = object;
            boolean bl3 = false;
            if (!force) {
                this.getLog().warn("Not vetoing artifact version as it appears to have already been an automated rollback target: " + "deliveryConfig=" + deliveryConfig.getName() + ", " + "environment=" + veto.getTargetEnvironment() + ", " + "artifactVersion=" + veto.getVersion() + ", " + "priorVersionReference=" + reference);
                return false;
            }
        }
        String prior = this.priorVersionDeployedIn((String)envUid, artUid, veto.getVersion());
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, prior, veto, (String)envUid, artUid){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $prior;
            final /* synthetic */ EnvironmentArtifactVeto $veto;
            final /* synthetic */ String $envUid;
            final /* synthetic */ String $artUid;

            public final void invoke() {
                SqlArtifactRepository.access$getJooq$p(this.this$0).transaction(new TransactionalRunnable(this){
                    final /* synthetic */ markAsVetoedIn.2 this$0;

                    public final void run(Configuration config) {
                        block0: {
                            DSLContext txn = DSL.using((Configuration)config);
                            SqlArtifactRepository sqlArtifactRepository = this.this$0.this$0;
                            DSLContext dSLContext = txn;
                            Intrinsics.checkNotNullExpressionValue((Object)dSLContext, (String)"txn");
                            SqlArtifactRepository.access$upsertAsVetoedInEnvironmentArtifactVersionsTable(sqlArtifactRepository, dSLContext, this.this$0.$prior, this.this$0.$veto, this.this$0.$envUid, this.this$0.$artUid);
                            SqlArtifactRepository.access$addRecordToEnvironmentArtifactVetoTable(this.this$0.this$0, txn, this.this$0.$envUid, this.this$0.$artUid, this.this$0.$veto);
                            String string = this.this$0.$prior;
                            if (string == null) break block0;
                            String string2 = string;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string2;
                            boolean bl3 = false;
                            SqlArtifactRepository.access$setPromotionReference(this.this$0.this$0, txn, this.this$0.$veto.getVersion(), this.this$0.$envUid, this.this$0.$artUid, it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$prior = string;
                this.$veto = environmentArtifactVeto;
                this.$envUid = string2;
                this.$artUid = string3;
                super(0);
            }
        });
        return true;
    }

    private final void setPromotionReference(DSLContext $this$setPromotionReference, String version, String envUid, String artUid, String prior) {
        $this$setPromotionReference.update((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE, (Object)version).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq((Object)envUid), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Object)artUid), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)prior)}).execute();
    }

    private final void addRecordToEnvironmentArtifactVetoTable(DSLContext $this$addRecordToEnvironmentArtifactVetoTable, String envUid, String artUid, EnvironmentArtifactVeto veto) {
        $this$addRecordToEnvironmentArtifactVetoTable.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VETO).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.ENVIRONMENT_UID, (Object)envUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_UID, (Object)artUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_VERSION, (Object)veto.getVersion()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_AT, (Object)this.clock.instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_BY, (Object)veto.getVetoedBy()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.COMMENT, (Object)veto.getComment()).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_AT, (Object)this.clock.instant()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_BY, (Object)veto.getVetoedBy()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VETO.COMMENT, (Object)veto.getComment()).execute();
    }

    private final void upsertAsVetoedInEnvironmentArtifactVersionsTable(DSLContext $this$upsertAsVetoedInEnvironmentArtifactVersionsTable, String prior, EnvironmentArtifactVeto veto, String envUid, String artUid) {
        InsertSetMoreStep insertSetMoreStep = $this$upsertAsVetoedInEnvironmentArtifactVersionsTable.insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID, (Object)envUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, (Object)artUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (Object)veto.getVersion()).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.VETOED);
        Field field = (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE;
        String string = prior;
        if (string == null) {
            string = veto.getVersion();
        }
        InsertOnDuplicateSetMoreStep insertOnDuplicateSetMoreStep = insertSetMoreStep.set(field, (Object)string).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.VETOED);
        Field field2 = (Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE;
        String string2 = prior;
        if (string2 == null) {
            string2 = veto.getVersion();
        }
        insertOnDuplicateSetMoreStep.set(field2, (Object)string2).execute();
    }

    private final SelectConditionStep<Record1<String>> selectPromotionReference(String envUid, String artUid, String version) {
        SelectConditionStep selectConditionStep = this.jooq.select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq((Object)envUid), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Object)artUid), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)version)});
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n      .select(ENVIR\u2026RSION.eq(version)\n      )");
        return selectConditionStep;
    }

    private final boolean isPinned(String envUid, String artUid, String version) {
        return (Boolean)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Boolean>(this, envUid, artUid, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $envUid;
            final /* synthetic */ String $artUid;
            final /* synthetic */ String $version;

            public final boolean invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).fetchExists((Table)Tables.ENVIRONMENT_ARTIFACT_PIN, Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq((Object)this.$envUid).and(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq((Object)this.$artUid)).and(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION.eq((Object)this.$version)));
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$envUid = string;
                this.$artUid = string2;
                this.$version = string3;
                super(0);
            }
        });
    }

    private final Pair<String, String> environmentAndArtifactIds(DeliveryConfig deliveryConfig, String targetEnvironment, DeliveryArtifact artifact) {
        return (Pair)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Pair<? extends String, ? extends String>>(this, deliveryConfig, targetEnvironment, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $targetEnvironment;
            final /* synthetic */ DeliveryArtifact $artifact;

            @NotNull
            public final Pair<String, String> invoke() {
                return new Pair((Object)SqlArtifactRepository.access$getUidStringFor(this.this$0, this.$deliveryConfig, SqlArtifactRepository.access$environmentNamed(this.this$0, this.$deliveryConfig, this.$targetEnvironment)), (Object)SqlArtifactRepository.access$getUidString$p(this.this$0, this.$artifact));
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$targetEnvironment = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
    }

    public void deleteVeto(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Select<Record1<String>> envId = this.getUidFor(deliveryConfig, this.environmentNamed(deliveryConfig, targetEnvironment));
        String artId = this.getUidString(artifact);
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Unit>(this, envId, artifact, version, artId){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Select $envId;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;
            final /* synthetic */ String $artId;

            public final void invoke() {
                String referenceVersion = (String)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.$envId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact)), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$version)}).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE);
                String string = referenceVersion;
                String referencesReferenceVersion = string == null ? null : (String)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.$envId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Object)this.$artId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)referenceVersion)}).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE);
                SqlArtifactRepository.access$getJooq$p(this.this$0).transaction(new TransactionalRunnable(this, referencesReferenceVersion, referenceVersion){
                    final /* synthetic */ deleteVeto.1 this$0;
                    final /* synthetic */ String $referencesReferenceVersion;
                    final /* synthetic */ String $referenceVersion;

                    public final void run(Configuration config) {
                        DSLContext txn = DSL.using((Configuration)config);
                        txn.update((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.APPROVED).setNull((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$envId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Object)this.this$0.$artId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.this$0.$version)}).execute();
                        if (this.$referencesReferenceVersion != null && Intrinsics.areEqual((Object)this.$referenceVersion, (Object)this.$referencesReferenceVersion)) {
                            txn.update((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).setNull((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_REFERENCE).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(this.this$0.$envId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Object)this.this$0.$artId), Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$referenceVersion)}).execute();
                        }
                        txn.deleteFrom((Table)Tables.ENVIRONMENT_ARTIFACT_VETO).where(Tables.ENVIRONMENT_ARTIFACT_VETO.ENVIRONMENT_UID.eq(this.this$0.$envId)).and(Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_UID.eq((Object)this.this$0.$artId)).and(Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_VERSION.eq((Object)this.this$0.$version)).execute();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$referencesReferenceVersion = string;
                        this.$referenceVersion = string2;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$envId = select;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                this.$artId = string2;
                super(0);
            }
        });
    }

    public void markAsSkipped(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String targetEnvironment, @Nullable String supersededByVersion) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Environment environment = this.environmentNamed(deliveryConfig, targetEnvironment);
        Select<Record1<String>> environmentUid = this.getUidFor(deliveryConfig, environment);
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, environmentUid, artifact, version, supersededByVersion){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Select $environmentUid;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;
            final /* synthetic */ String $supersededByVersion;

            public final int invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID, this.$environmentUid).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID, SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact)).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (Object)this.$version).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.SKIPPED).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (Object)this.$supersededByVersion).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0).instant()).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (Object)PromotionStatus.SKIPPED).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (Object)this.$supersededByVersion).set((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT, (Object)SqlArtifactRepository.access$getClock$p(this.this$0).instant()).execute();
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$environmentUid = select;
                this.$artifact = deliveryArtifact;
                this.$version = string;
                this.$supersededByVersion = string2;
                super(0);
            }
        });
    }

    @NotNull
    public List<PublishedArtifact> getArtifactVersionsByStatus(@NotNull DeliveryConfig deliveryConfig, @NotNull String environmentName, @NotNull List<? extends PromotionStatus> statuses) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<PublishedArtifact>>(this, deliveryConfig, environmentName, statuses){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ List $statuses;

            public final List<PublishedArtifact> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).innerJoin((TableLike)Tables.DELIVERY_ARTIFACT).on(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Field)Tables.DELIVERY_ARTIFACT.UID)).innerJoin((TableLike)Tables.ARTIFACT_VERSIONS).on(Tables.DELIVERY_ARTIFACT.NAME.eq((Field)Tables.ARTIFACT_VERSIONS.NAME)).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Field)Tables.ARTIFACT_VERSIONS.TYPE)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Field)Tables.ARTIFACT_VERSIONS.VERSION)).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.in((Collection)this.$statuses)).fetch((RecordMapper)getArtifactVersionsByStatus.1.INSTANCE);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$statuses = list;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    @NotNull
    public List<PublishedArtifactInEnvironment> getAllVersionsForEnvironment(@NotNull DeliveryArtifact artifact, @NotNull DeliveryConfig config, @NotNull String environmentName) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<PublishedArtifactInEnvironment>>(this, artifact, environmentName){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $environmentName;

            public final List<PublishedArtifactInEnvironment> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).innerJoin((TableLike)Tables.DELIVERY_ARTIFACT).on(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Field)Tables.DELIVERY_ARTIFACT.UID)).innerJoin((TableLike)Tables.ARTIFACT_VERSIONS).on(Tables.DELIVERY_ARTIFACT.NAME.eq((Field)Tables.ARTIFACT_VERSIONS.NAME)).innerJoin((TableLike)Tables.LATEST_ENVIRONMENT).on(Tables.LATEST_ENVIRONMENT.UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID)).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Field)Tables.ARTIFACT_VERSIONS.TYPE)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Field)Tables.ARTIFACT_VERSIONS.VERSION)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).where(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)this.$environmentName)).fetch((RecordMapper)new RecordMapper<Record11<String, String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata, PromotionStatus, Instant, String>, PublishedArtifactInEnvironment>(this){
                    final /* synthetic */ getAllVersionsForEnvironment.existingVersions.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final PublishedArtifactInEnvironment map(Record11<String, String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata, PromotionStatus, Instant, String> $dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy) {
                        void deployedAt;
                        void promotionStatus;
                        void buildMetadata;
                        void gitMetadata;
                        void createdAt;
                        void status;
                        void reference;
                        void version;
                        void type;
                        void name;
                        String string = (String)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component1();
                        String string2 = (String)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component2();
                        String string3 = (String)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component3();
                        String string4 = (String)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component4();
                        ArtifactStatus artifactStatus = (ArtifactStatus)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component5();
                        Instant instant = (Instant)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component6();
                        GitMetadata gitMetadata2 = (GitMetadata)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component7();
                        BuildMetadata buildMetadata2 = (BuildMetadata)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component8();
                        PromotionStatus promotionStatus2 = (PromotionStatus)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component9();
                        Instant instant2 = (Instant)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component10();
                        String replacedBy = (String)$dstr$name$type$version$reference$status$createdAt$gitMetadata$buildMetadata$promotionStatus$deployedAt$replacedBy.component11();
                        void v0 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"name");
                        void v1 = type;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"type");
                        void v2 = version;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"version");
                        void v3 = reference;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"reference");
                        PublishedArtifact publishedArtifact = new PublishedArtifact((String)v0, (String)v1, (String)v2, (String)v3, (ArtifactStatus)status, (Instant)createdAt, (GitMetadata)gitMetadata, (BuildMetadata)buildMetadata);
                        void v4 = promotionStatus;
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"promotionStatus");
                        return new PublishedArtifactInEnvironment(publishedArtifact, (PromotionStatus)v4, this.this$0.$environmentName, (Instant)deployedAt, replacedBy);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                this.$environmentName = string;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        List existingVersions2 = (List)t;
        List<PublishedArtifactInEnvironment> pending = this.getPendingVersions(artifact, config, environmentName);
        return CollectionsKt.plus((Collection)existingVersions2, (Iterable)pending);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PublishedArtifactInEnvironment> getPendingVersions(DeliveryArtifact artifact, DeliveryConfig config, String environmentName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getPendingVersionsInEnvironment(config, artifact.getReference(), environmentName);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void publishedArtifact;
            PublishedArtifact publishedArtifact2 = (PublishedArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PublishedArtifactInEnvironment publishedArtifactInEnvironment = new PublishedArtifactInEnvironment((PublishedArtifact)publishedArtifact, PromotionStatus.PENDING, environmentName, null, null, 24, null);
            collection.add(publishedArtifactInEnvironment);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<PublishedArtifact> getPendingVersionsInEnvironment(@NotNull DeliveryConfig deliveryConfig, @NotNull String artifactReference, @NotNull String environmentName) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifactReference, (String)"artifactReference");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        DeliveryArtifact deliveryArtifact = deliveryConfig.matchingArtifactByReference(artifactReference);
        if (deliveryArtifact == null) {
            throw (Throwable)new ArtifactNotFoundException(artifactReference, deliveryConfig.getName());
        }
        DeliveryArtifact artifact = deliveryArtifact;
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<PublishedArtifact>>(this, artifact, deliveryConfig, environmentName, artifactReference){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $artifactReference;

            public final List<PublishedArtifact> invoke() {
                SelectConditionStep selectConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA).from(new TableLike[]{(TableLike)Tables.ARTIFACT_VERSIONS, (TableLike)Tables.DELIVERY_ARTIFACT, (TableLike)Tables.LATEST_ENVIRONMENT, (TableLike)Tables.DELIVERY_CONFIG}).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$artifact.getName())).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$artifact.getType())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$artifact.getReference())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$deliveryConfig.getName())).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).and(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfig.getName())).and(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)this.$environmentName)).and(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)this.$artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)this.$artifact.getType()));
                boolean bl = false;
                boolean bl2 = false;
                SelectConditionStep $this$apply = selectConditionStep;
                boolean bl3 = false;
                Collection collection = this.$artifact.getStatuses();
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    Collection $this$toTypedArray$iv = this.$artifact.getStatuses();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ArtifactStatus[] artifactStatusArray = thisCollection$iv.toArray(new ArtifactStatus[0]);
                    if (artifactStatusArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    $this$apply.and(Tables.ARTIFACT_VERSIONS.RELEASE_STATUS.in((Object[])Arrays.copyOf(artifactStatusArray, artifactStatusArray.length)));
                }
                return selectConditionStep.andNotExists((Select)DSL.selectOne().from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Field)Tables.ARTIFACT_VERSIONS.VERSION)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq((Field)Tables.LATEST_ENVIRONMENT.UID)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Field)Tables.DELIVERY_ARTIFACT.UID))).fetch((RecordMapper)new RecordMapper<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>, PublishedArtifact>(this){
                    final /* synthetic */ getPendingVersionsInEnvironment.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final PublishedArtifact map(Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata> $dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata) {
                        void gitMetadata;
                        void createdAt;
                        void status;
                        void version;
                        void type;
                        void name;
                        String string = (String)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component1();
                        String string2 = (String)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component2();
                        String string3 = (String)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component3();
                        ArtifactStatus artifactStatus = (ArtifactStatus)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component4();
                        Instant instant = (Instant)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component5();
                        GitMetadata gitMetadata2 = (GitMetadata)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component6();
                        BuildMetadata buildMetadata = (BuildMetadata)$dstr$name$type$version$status$createdAt$gitMetadata$buildMetadata.component7();
                        void v0 = name;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"name");
                        void v1 = type;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"type");
                        void v2 = version;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"version");
                        return new PublishedArtifact((String)v0, (String)v1, (String)v2, this.this$0.$artifactReference, (ArtifactStatus)status, (Instant)createdAt, (GitMetadata)gitMetadata, buildMetadata);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$artifact = deliveryArtifact;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifactReference = string2;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    /*
     * WARNING - void declaration
     */
    public int getNumPendingToBePromoted(@NotNull DeliveryConfig deliveryConfig, @NotNull String artifactReference, @NotNull String environmentName, @NotNull String version) {
        Object v1;
        List pendingVersions;
        DeliveryArtifact artifact;
        block3: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
            Intrinsics.checkNotNullParameter((Object)artifactReference, (String)"artifactReference");
            Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            DeliveryArtifact deliveryArtifact = deliveryConfig.matchingArtifactByReference(artifactReference);
            if (deliveryArtifact == null) {
                throw (Throwable)new ArtifactNotFoundException(artifactReference, deliveryConfig.getName());
            }
            artifact = deliveryArtifact;
            Iterable iterable = this.getPendingVersions(artifact, deliveryConfig, environmentName);
            boolean $i$f$map22 = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PublishedArtifactInEnvironment publishedArtifactInEnvironment = (PublishedArtifactInEnvironment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PublishedArtifact publishedArtifact = it.getPublishedArtifact();
                collection.add(publishedArtifact);
            }
            pendingVersions = (List)destination$iv$iv;
            Iterable $i$f$map22 = this.getArtifactVersionsByStatus(deliveryConfig, environmentName, CollectionsKt.listOf((Object)PromotionStatus.CURRENT));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PublishedArtifact it = (PublishedArtifact)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getReference(), (Object)artifactReference)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        PublishedArtifact currentVersion = v1;
        return this.removeExtra(pendingVersions, artifact, version, currentVersion).size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PublishedArtifact> removeExtra(@NotNull List<PublishedArtifact> versions2, @NotNull DeliveryArtifact artifact, @NotNull String mjVersion, @Nullable PublishedArtifact currentVersion) {
        List list;
        Object v0;
        List sortedVersions;
        block11: {
            Intrinsics.checkNotNullParameter(versions2, (String)"versions");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)mjVersion, (String)"mjVersion");
            if (versions2.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            List fullVersions = currentVersion != null ? CollectionsKt.plus((Collection)versions2, (Object)currentVersion) : versions2;
            sortedVersions = CollectionsKt.sortedWith((Iterable)fullVersions, (Comparator)artifact.getSortingStrategy().getComparator());
            Iterable iterable = sortedVersions;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object object : iterable2) {
                PublishedArtifact it = (PublishedArtifact)object;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)mjVersion)) continue;
                v0 = object;
                break block11;
            }
            v0 = null;
        }
        PublishedArtifact publishedArtifact = v0;
        if (publishedArtifact == null) {
            return sortedVersions;
        }
        PublishedArtifact mjArtifact = publishedArtifact;
        Iterable $this$dropWhile$iv = sortedVersions;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PublishedArtifact it = (PublishedArtifact)item$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)mjArtifact) ^ true) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        List newerRemoved = list$iv;
        if (currentVersion != null) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            List list2;
            Iterable $this$dropLastWhile$iv = newerRemoved;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    PublishedArtifact it = (PublishedArtifact)iterator$iv.previous();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)currentVersion) ^ true) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                PublishedArtifact it = (PublishedArtifact)element$iv$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)currentVersion)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = newerRemoved;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<EnvironmentSummary> getEnvironmentSummaries(@NotNull DeliveryConfig deliveryConfig) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        List<PinnedEnvironment> pinnedEnvs = this.getPinnedEnvironments(deliveryConfig);
        Iterable $this$map$iv = deliveryConfig.getEnvironments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void environment;
            void $this$mapTo$iv$iv2;
            Environment environment2 = (Environment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = deliveryConfig.getArtifacts();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                Iterator<Object> iterator;
                ArtifactVersionStatus artifactVersionStatus;
                String string;
                String string2;
                String string3;
                Set set;
                Collection collection2;
                block20: {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    PublishedArtifact it;
                    Collection<String> collection3;
                    Iterable $this$mapTo$iv$iv3;
                    Iterable $this$map$iv3;
                    PublishedArtifact $dstr$artifactVersion$_u24__u24;
                    void $this$groupByTo$iv$iv;
                    void $this$groupBy$iv;
                    void $this$mapNotNullTo$iv$iv22;
                    void $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void artifact;
                    DeliveryArtifact deliveryArtifact = (DeliveryArtifact)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    SelectConditionStep selectConditionStep = this.jooq.select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS).from(new TableLike[]{(TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS, (TableLike)Tables.ARTIFACT_VERSIONS, (TableLike)Tables.DELIVERY_ARTIFACT, (TableLike)Tables.LATEST_ENVIRONMENT, (TableLike)Tables.DELIVERY_CONFIG}).where(Tables.DELIVERY_ARTIFACT.UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID)).and(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)artifact.getName())).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)artifact.getType())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)artifact.getReference())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)deliveryConfig.getName())).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Field)Tables.ARTIFACT_VERSIONS.VERSION)).and(Tables.LATEST_ENVIRONMENT.UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID)).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).and(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)environment.getName())).and(Tables.DELIVERY_CONFIG.NAME.eq((Object)deliveryConfig.getName())).and(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)artifact.getType()));
                    boolean bl3 = false;
                    boolean bl4 = false;
                    SelectConditionStep $this$apply22 = selectConditionStep;
                    boolean bl5 = false;
                    Iterable iterable3 = artifact.getStatuses();
                    boolean bl6 = false;
                    if (!iterable3.isEmpty()) {
                        Collection $this$toTypedArray$iv = artifact.getStatuses();
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        ArtifactStatus[] artifactStatusArray = thisCollection$iv.toArray(new ArtifactStatus[0]);
                        if (artifactStatusArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        $this$apply22.and(Tables.ARTIFACT_VERSIONS.RELEASE_STATUS.in((Object[])Arrays.copyOf(artifactStatusArray, artifactStatusArray.length)));
                    }
                    SelectConditionStep versionsInEnvironment = selectConditionStep;
                    SelectConditionStep selectConditionStep2 = this.jooq.select((SelectField)Tables.ARTIFACT_VERSIONS.NAME, (SelectField)Tables.ARTIFACT_VERSIONS.TYPE, (SelectField)Tables.ARTIFACT_VERSIONS.VERSION, (SelectField)Tables.ARTIFACT_VERSIONS.RELEASE_STATUS, (SelectField)Tables.ARTIFACT_VERSIONS.CREATED_AT, (SelectField)Tables.ARTIFACT_VERSIONS.GIT_METADATA, (SelectField)Tables.ARTIFACT_VERSIONS.BUILD_METADATA, (SelectField)DSL.val((Object)PromotionStatus.PENDING)).from(new TableLike[]{(TableLike)Tables.ARTIFACT_VERSIONS, (TableLike)Tables.DELIVERY_ARTIFACT, (TableLike)Tables.LATEST_ENVIRONMENT, (TableLike)Tables.DELIVERY_CONFIG}).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)artifact.getName())).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)artifact.getType())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)artifact.getReference())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)deliveryConfig.getName())).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).and(Tables.DELIVERY_CONFIG.NAME.eq((Object)deliveryConfig.getName())).and(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)environment.getName())).and(Tables.ARTIFACT_VERSIONS.NAME.eq((Object)artifact.getName())).and(Tables.ARTIFACT_VERSIONS.TYPE.eq((Object)artifact.getType()));
                    bl4 = false;
                    boolean $this$apply22 = false;
                    SelectConditionStep $this$apply = selectConditionStep2;
                    boolean bl7 = false;
                    Collection $i$f$toTypedArray = artifact.getStatuses();
                    boolean thisCollection$iv = false;
                    if (!$i$f$toTypedArray.isEmpty()) {
                        Collection $this$toTypedArray$iv = artifact.getStatuses();
                        boolean $i$f$toTypedArray2 = false;
                        Collection thisCollection$iv2 = $this$toTypedArray$iv;
                        ArtifactStatus[] artifactStatusArray = thisCollection$iv2.toArray(new ArtifactStatus[0]);
                        if (artifactStatusArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        $this$apply.and(Tables.ARTIFACT_VERSIONS.RELEASE_STATUS.in((Object[])Arrays.copyOf(artifactStatusArray, artifactStatusArray.length)));
                    }
                    SelectConditionStep pendingVersions = selectConditionStep2.andNotExists((Select)DSL.selectOne().from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Field)Tables.ARTIFACT_VERSIONS.VERSION)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq((Field)Tables.LATEST_ENVIRONMENT.UID)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Field)Tables.DELIVERY_ARTIFACT.UID)));
                    Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<Pair<? extends PublishedArtifact, ? extends PromotionStatus>>>(versionsInEnvironment, pendingVersions){
                        final /* synthetic */ SelectConditionStep $versionsInEnvironment;
                        final /* synthetic */ SelectConditionStep $pendingVersions;

                        public final List<Pair<PublishedArtifact, PromotionStatus>> invoke() {
                            return this.$versionsInEnvironment.unionAll((Select)this.$pendingVersions).fetch((RecordMapper)getEnvironmentSummaries.1.artifactVersions.1.unionedVersions.1.INSTANCE);
                        }
                        {
                            this.$versionsInEnvironment = selectConditionStep;
                            this.$pendingVersions = selectConditionStep2;
                            super(0);
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026s\n            }\n        }");
                    Iterable iterable4 = (Iterable)t;
                    boolean $i$f$filter22 = false;
                    $this$apply = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Pair $dstr$artifactVersion$_u24__u242 = (Pair)element$iv$iv;
                        boolean bl8 = false;
                        PublishedArtifact artifactVersion = (PublishedArtifact)$dstr$artifactVersion$_u24__u242.component1();
                        boolean bl9 = artifact instanceof DockerArtifact ? ArtifactUtilsKt.filterDockerTag(artifactVersion.getVersion(), (DockerArtifact)artifact) : true;
                        if (!bl9) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List unionedVersions2 = (List)destination$iv$iv3;
                    Iterable $i$f$filter22 = unionedVersions2;
                    boolean $i$f$mapNotNull22 = false;
                    destination$iv$iv3 = $this$mapNotNull$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
                    boolean $i$f$forEach = false;
                    Iterator bl8 = $this$forEach$iv$iv$iv.iterator();
                    while (bl8.hasNext()) {
                        ArtifactStatus artifactStatus;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = bl8.next();
                        boolean bl10 = false;
                        Pair $dstr$artifactVersion$_u24__u243 = (Pair)element$iv$iv;
                        boolean bl11 = false;
                        PublishedArtifact artifactVersion = (PublishedArtifact)$dstr$artifactVersion$_u24__u243.component1();
                        if (artifactVersion.getStatus() == null) continue;
                        boolean bl12 = false;
                        boolean bl13 = false;
                        ArtifactStatus it$iv$iv = artifactStatus;
                        boolean bl14 = false;
                        destination$iv$iv4.add(it$iv$iv);
                    }
                    Set releaseStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
                    Object $i$f$mapNotNull22 = artifact.getSortingStrategy().getComparator();
                    boolean $this$mapNotNullTo$iv$iv22 = false;
                    $i$f$mapNotNull22 = CollectionsKt.sortedWith((Iterable)unionedVersions2, (Comparator)new Comparator<T>((Comparator)$i$f$mapNotNull22){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = comparator;
                        }

                        public final int compare(T a, T b) {
                            Pair $dstr$artifactVersion$_u24__u24;
                            PublishedArtifact artifactVersion;
                            Comparator comparator = this.$comparator;
                            boolean bl = false;
                            Pair pair = (Pair)a;
                            Comparator comparator2 = comparator;
                            boolean bl2 = false;
                            PublishedArtifact publishedArtifact = artifactVersion = (PublishedArtifact)$dstr$artifactVersion$_u24__u24.component1();
                            $dstr$artifactVersion$_u24__u24 = (Pair)b;
                            bl2 = false;
                            PublishedArtifact publishedArtifact2 = artifactVersion = (PublishedArtifact)$dstr$artifactVersion$_u24__u24.component1();
                            return comparator2.compare(publishedArtifact, publishedArtifact2);
                        }
                    });
                    boolean $i$f$groupBy22 = false;
                    destination$iv$iv4 = $this$groupBy$iv;
                    Map destination$iv$iv5 = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        PublishedArtifact artifactVersion;
                        Object object5;
                        PromotionStatus promotionStatus;
                        Pair $dstr$_u24__u24$promotionStatus = (Pair)element$iv$iv;
                        boolean $i$a$-groupBy-SqlArtifactRepository$getEnvironmentSummaries$1$artifactVersions$1$versions$42 = false;
                        PromotionStatus key$iv$iv = promotionStatus = (PromotionStatus)$dstr$_u24__u24$promotionStatus.component2();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl15 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object5 = answer$iv$iv$iv;
                        } else {
                            object5 = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object5;
                        Pair $i$a$-groupBy-SqlArtifactRepository$getEnvironmentSummaries$1$artifactVersions$1$versions$42 = (Pair)element$iv$iv;
                        List list = list$iv$iv;
                        boolean bl16 = false;
                        PublishedArtifact publishedArtifact = artifactVersion = (PublishedArtifact)$dstr$artifactVersion$_u24__u24.component1();
                        list.add(publishedArtifact);
                    }
                    Map versions2 = destination$iv$iv5;
                    List list = (List)versions2.get(PromotionStatus.CURRENT);
                    PublishedArtifact currentVersion = list != null ? (PublishedArtifact)CollectionsKt.firstOrNull((List)list) : null;
                    PublishedArtifact publishedArtifact = currentVersion;
                    Iterable $i$f$groupBy22 = this.removeOlderIfCurrentExists((DeliveryArtifact)artifact, currentVersion, (List)versions2.get(PromotionStatus.PENDING));
                    List list2 = (List)versions2.get(PromotionStatus.DEPLOYING);
                    String string4 = list2 != null && (list2 = (PublishedArtifact)CollectionsKt.firstOrNull((List)list2)) != null ? list2.getVersion() : null;
                    String string5 = publishedArtifact != null ? publishedArtifact.getVersion() : null;
                    set = releaseStatuses;
                    string3 = artifact.getReference();
                    string2 = artifact.getType();
                    string = artifact.getName();
                    boolean $i$f$map3 = false;
                    destination$iv$iv5 = $this$map$iv3;
                    Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        $dstr$artifactVersion$_u24__u24 = (PublishedArtifact)item$iv$iv3;
                        collection3 = destination$iv$iv6;
                        boolean bl17 = false;
                        object4 = it.getVersion();
                        collection3.add((String)object4);
                    }
                    collection3 = (List)destination$iv$iv6;
                    List list3 = (List)versions2.get(PromotionStatus.APPROVED);
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    $this$map$iv3 = list3;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        it = (PublishedArtifact)item$iv$iv3;
                        object4 = destination$iv$iv6;
                        boolean bl18 = false;
                        object3 = it.getVersion();
                        object4.add(object3);
                    }
                    object4 = (List)destination$iv$iv6;
                    List list4 = (List)versions2.get(PromotionStatus.PREVIOUS);
                    if (list4 == null) {
                        list4 = CollectionsKt.emptyList();
                    }
                    $this$map$iv3 = list4;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        it = (PublishedArtifact)item$iv$iv3;
                        object3 = destination$iv$iv6;
                        boolean bl19 = false;
                        object2 = it.getVersion();
                        object3.add(object2);
                    }
                    object3 = (List)destination$iv$iv6;
                    List list5 = (List)versions2.get(PromotionStatus.VETOED);
                    if (list5 == null) {
                        list5 = CollectionsKt.emptyList();
                    }
                    $this$map$iv3 = list5;
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        it = (PublishedArtifact)item$iv$iv3;
                        object2 = destination$iv$iv6;
                        boolean bl20 = false;
                        object = it.getVersion();
                        object2.add(object);
                    }
                    object2 = (List)destination$iv$iv6;
                    List list6 = (List)versions2.get(PromotionStatus.SKIPPED);
                    $this$map$iv3 = CollectionsKt.plus((Collection)this.removeNewerIfCurrentExists((DeliveryArtifact)artifact, currentVersion, (List)versions2.get(PromotionStatus.PENDING)), (Iterable)(list6 != null ? (Iterable)list6 : (Iterable)CollectionsKt.emptyList()));
                    $i$f$map3 = false;
                    $this$mapTo$iv$iv3 = $this$map$iv3;
                    destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        it = (PublishedArtifact)item$iv$iv3;
                        object = destination$iv$iv6;
                        boolean bl21 = false;
                        String string6 = it.getVersion();
                        object.add(string6);
                    }
                    Object object6 = object = (List)destination$iv$iv6;
                    Object object7 = object2;
                    Object object8 = object3;
                    Object object9 = object4;
                    Collection<String> collection4 = collection3;
                    String string7 = string4;
                    String string8 = string5;
                    iterable3 = pinnedEnvs;
                    artifactVersionStatus = new ArtifactVersionStatus(string8, string7, collection4, (List)object9, (List)object8, (List)object7, (List)object6);
                    bl6 = false;
                    Iterable iterable5 = iterable3;
                    boolean bl22 = false;
                    for (Iterator<Object> iterator2 : iterable5) {
                        PinnedEnvironment it2 = (PinnedEnvironment)iterator2;
                        boolean bl23 = false;
                        if (!Intrinsics.areEqual((Object)it2.getTargetEnvironment(), (Object)environment.getName())) continue;
                        iterator = iterator2;
                        break block20;
                    }
                    iterator = null;
                }
                Iterator<Object> iterator3 = iterator;
                PinnedEnvironment pinnedEnvironment = (PinnedEnvironment)iterator3;
                String string9 = pinnedEnvironment != null ? pinnedEnvironment.getVersion() : null;
                ArtifactVersionStatus artifactVersionStatus2 = artifactVersionStatus;
                Set set2 = set;
                String string10 = string3;
                String string11 = string2;
                String string12 = string;
                ArtifactVersions artifactVersions2 = new ArtifactVersions(string12, string11, string10, set2, artifactVersionStatus2, string9);
                collection2.add(artifactVersions2);
            }
            Set artifactVersions3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            EnvironmentSummary environmentSummary = new EnvironmentSummary((Environment)environment, artifactVersions3);
            collection.add(environmentSummary);
        }
        return (List)destination$iv$iv;
    }

    public void pinEnvironment(@NotNull DeliveryConfig deliveryConfig, @NotNull EnvironmentArtifactPin environmentArtifactPin) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environmentArtifactPin, (String)"environmentArtifactPin");
        boolean bl = false;
        boolean bl2 = false;
        EnvironmentArtifactPin $this$with = environmentArtifactPin;
        boolean bl3 = false;
        Environment environment = this.environmentNamed(deliveryConfig, $this$with.getTargetEnvironment());
        DeliveryArtifact artifact = this.get(deliveryConfig.getName(), $this$with.getReference());
        Instant now = this.clock.instant();
        ((Number)this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>($this$with, environment, artifact, now, this, deliveryConfig){
            final /* synthetic */ EnvironmentArtifactPin $this_with;
            final /* synthetic */ Environment $environment;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ Instant $now;
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig$inlined;
            {
                this.$this_with = environmentArtifactPin;
                this.$environment = environment;
                this.$artifact = deliveryArtifact;
                this.$now = instant;
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig$inlined = deliveryConfig;
                super(0);
            }

            public final int invoke() {
                InsertSetMoreStep insertSetMoreStep = SqlArtifactRepository.access$getJooq$p(this.this$0).insertInto((Table)Tables.ENVIRONMENT_ARTIFACT_PIN).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID, SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig$inlined, this.$environment)).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID, SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact)).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION, (Object)this.$this_with.getVersion()).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_AT, (Object)this.$now);
                Field field = (Field)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_BY;
                String string = this.$this_with.getPinnedBy();
                if (string == null) {
                    string = "anonymous";
                }
                InsertOnDuplicateSetMoreStep insertOnDuplicateSetMoreStep = insertSetMoreStep.set(field, (Object)string).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.COMMENT, (Object)this.$this_with.getComment()).onDuplicateKeyUpdate().set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION, (Object)this.$this_with.getVersion()).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_AT, (Object)this.$now);
                Field field2 = (Field)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_BY;
                String string2 = this.$this_with.getPinnedBy();
                if (string2 == null) {
                    string2 = "anonymous";
                }
                return insertOnDuplicateSetMoreStep.set(field2, (Object)string2).set((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.COMMENT, MySQLDSL.values((Field)((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.COMMENT))).execute();
            }
        })).intValue();
    }

    @NotNull
    public List<PinnedEnvironment> getPinnedEnvironments(@NotNull DeliveryConfig deliveryConfig) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<PinnedEnvironment>>(this, deliveryConfig){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;

            public final List<PinnedEnvironment> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT.NAME, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.COMMENT, (SelectField)Tables.DELIVERY_ARTIFACT.NAME, (SelectField)Tables.DELIVERY_ARTIFACT.TYPE, (SelectField)Tables.DELIVERY_ARTIFACT.DETAILS, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE).from((TableLike)Tables.ENVIRONMENT).innerJoin((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).on(Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq((Field)Tables.ENVIRONMENT.UID)).innerJoin((TableLike)Tables.DELIVERY_ARTIFACT).on(Tables.DELIVERY_ARTIFACT.UID.eq((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID)).innerJoin((TableLike)Tables.DELIVERY_CONFIG).on(Tables.DELIVERY_CONFIG.UID.eq((Field)Tables.ENVIRONMENT.DELIVERY_CONFIG_UID)).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)this.$deliveryConfig.getName())).fetch((RecordMapper)new RecordMapper<Record9<String, String, Instant, String, String, String, String, String, String>, PinnedEnvironment>(this){
                    final /* synthetic */ getPinnedEnvironments.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final PinnedEnvironment map(Record9<String, String, Instant, String, String, String, String, String, String> $dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference) {
                        void pinnedAt;
                        void pinnedBy;
                        void comment;
                        void version;
                        void details;
                        void artifactName;
                        void type;
                        void environmentName;
                        String string = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component1();
                        String string2 = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component2();
                        Instant instant = (Instant)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component3();
                        String string3 = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component4();
                        String string4 = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component5();
                        String string5 = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component6();
                        String string6 = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component7();
                        String string7 = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component8();
                        String reference = (String)$dstr$environmentName$version$pinnedAt$pinnedBy$comment$artifactName$type$details$reference.component9();
                        String string8 = this.this$0.$deliveryConfig.getName();
                        void v1 = environmentName;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"environmentName");
                        List list = SqlArtifactRepository.access$getArtifactSuppliers$p(this.this$0.this$0);
                        void v3 = type;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"type");
                        ArtifactSupplier artifactSupplier = ArtifactSupplierKt.supporting((List)list, (String)v3);
                        void v5 = artifactName;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"artifactName");
                        void var11_11 = type;
                        boolean bl = false;
                        String string9 = var11_11.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                        void v7 = details;
                        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"details");
                        String string10 = reference;
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"reference");
                        DeliveryArtifact deliveryArtifact = ArtifactUtilsKt.mapToArtifact(artifactSupplier, (String)v5, string9, (String)v7, string10, this.this$0.$deliveryConfig.getName());
                        void v10 = version;
                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"version");
                        var11_11 = comment;
                        void var12_13 = pinnedBy;
                        void var13_14 = pinnedAt;
                        return new PinnedEnvironment(string8, (String)v1, deliveryArtifact, (String)v10, (String)var12_13, (Instant)var13_14, (String)var11_11);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    public void deletePin(@NotNull DeliveryConfig deliveryConfig, @NotNull String targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<List<Unit>>(this, targetEnvironment, deliveryConfig){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $targetEnvironment;
            final /* synthetic */ DeliveryConfig $deliveryConfig;

            public final List<Unit> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).innerJoin((TableLike)Tables.ENVIRONMENT).on(Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq((Field)Tables.ENVIRONMENT.UID)).where(new Condition[]{Tables.ENVIRONMENT.NAME.eq((Object)this.$targetEnvironment), Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$deliveryConfig))}).fetch((RecordMapper)new RecordMapper<Record2<String, String>, Unit>(this){
                    final /* synthetic */ deletePin.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void map(Record2<String, String> $dstr$envUid$artUid) {
                        void envUid;
                        String string = (String)$dstr$envUid$artUid.component1();
                        String artUid = (String)$dstr$envUid$artUid.component2();
                        SqlArtifactRepository sqlArtifactRepository = this.this$0.this$0;
                        void v1 = envUid;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"envUid");
                        String string2 = artUid;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artUid");
                        SqlArtifactRepository.access$deletePin(sqlArtifactRepository, (String)v1, string2);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$targetEnvironment = string;
                this.$deliveryConfig = deliveryConfig;
                super(0);
            }
        });
    }

    @Nullable
    public String getPinnedVersion(@NotNull DeliveryConfig deliveryConfig, @NotNull String targetEnvironment, @NotNull String reference) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        return (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, deliveryConfig, reference, targetEnvironment){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $reference;
            final /* synthetic */ String $targetEnvironment;

            @Nullable
            public final String invoke() {
                List list = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION).from((TableLike)Tables.DELIVERY_ARTIFACT).innerJoin((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).on(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq((Field)Tables.DELIVERY_ARTIFACT.UID)).innerJoin((TableLike)Tables.ENVIRONMENT).on(Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq((Field)Tables.ENVIRONMENT.UID)).where(new Condition[]{Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$deliveryConfig.getName()), Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$reference), Tables.ENVIRONMENT.NAME.eq((Object)this.$targetEnvironment), Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$deliveryConfig))}).fetch((Field)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(ENVIRONMENT_\u2026ACT_PIN.ARTIFACT_VERSION)");
                return (String)CollectionsKt.firstOrNull((List)list);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$reference = string;
                this.$targetEnvironment = string2;
                super(0);
            }
        });
    }

    public void deletePin(@NotNull DeliveryConfig deliveryConfig, @NotNull String targetEnvironment, @NotNull String reference) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<List<Unit>>(this, deliveryConfig, reference, targetEnvironment){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $reference;
            final /* synthetic */ String $targetEnvironment;

            public final List<Unit> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID).from((TableLike)Tables.DELIVERY_ARTIFACT).innerJoin((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).on(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq((Field)Tables.DELIVERY_ARTIFACT.UID)).innerJoin((TableLike)Tables.ENVIRONMENT).on(Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq((Field)Tables.ENVIRONMENT.UID)).where(new Condition[]{Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$deliveryConfig.getName()), Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$reference), Tables.ENVIRONMENT.NAME.eq((Object)this.$targetEnvironment), Tables.ENVIRONMENT.DELIVERY_CONFIG_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$deliveryConfig))}).fetch((RecordMapper)new RecordMapper<Record2<String, String>, Unit>(this){
                    final /* synthetic */ deletePin.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void map(Record2<String, String> $dstr$envUid$artUid) {
                        void envUid;
                        String string = (String)$dstr$envUid$artUid.component1();
                        String artUid = (String)$dstr$envUid$artUid.component2();
                        SqlArtifactRepository sqlArtifactRepository = this.this$0.this$0;
                        void v1 = envUid;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"envUid");
                        String string2 = artUid;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"artUid");
                        SqlArtifactRepository.access$deletePin(sqlArtifactRepository, (String)v1, string2);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$reference = string;
                this.$targetEnvironment = string2;
                super(0);
            }
        });
    }

    @Nullable
    public PublishedArtifact getArtifactVersionByPromotionStatus(@NotNull DeliveryConfig deliveryConfig, @NotNull String environmentName, @NotNull DeliveryArtifact artifact, @NotNull PromotionStatus promotionStatus, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)promotionStatus, (String)"promotionStatus");
        boolean bl = CollectionsKt.listOf((Object[])new PromotionStatus[]{PromotionStatus.CURRENT, PromotionStatus.PREVIOUS}).contains(promotionStatus);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid promotion status used to query";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (PublishedArtifact)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<PublishedArtifact>(this, deliveryConfig, environmentName, artifact, promotionStatus, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ PromotionStatus $promotionStatus;
            final /* synthetic */ String $version;

            @Nullable
            public final PublishedArtifact invoke() {
                SelectConditionStep selectConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.eq((Object)this.$promotionStatus));
                boolean bl = false;
                boolean bl2 = false;
                SelectConditionStep $this$apply = selectConditionStep;
                boolean bl3 = false;
                if (this.$version != null) {
                    $this$apply.and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY.eq((Object)this.$version));
                }
                List list = selectConditionStep.orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT.desc()).fetch((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq\n        .select(ENV\u2026ERSIONS.ARTIFACT_VERSION)");
                String fetchedVersion = (String)CollectionsKt.firstOrNull((List)list);
                return fetchedVersion != null ? ArtifactRepository.DefaultImpls.getArtifactVersion$default((ArtifactRepository)this.this$0, (DeliveryArtifact)this.$artifact, (String)fetchedVersion, null, (int)4, null) : null;
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifact = deliveryArtifact;
                this.$promotionStatus = promotionStatus;
                this.$version = string2;
                super(0);
            }
        });
    }

    @NotNull
    public List<StatusInfoForArtifactInEnvironment> getVersionInfoInEnvironment(@NotNull DeliveryConfig deliveryConfig, @NotNull String environmentName, @NotNull DeliveryArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<StatusInfoForArtifactInEnvironment>>(this, deliveryConfig, environmentName, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final List<StatusInfoForArtifactInEnvironment> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.in((Collection)CollectionsKt.listOf((Object[])new PromotionStatus[]{PromotionStatus.CURRENT, PromotionStatus.PREVIOUS}))).orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT.desc()).fetch((RecordMapper)getVersionInfoInEnvironment.1.INSTANCE);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    @NotNull
    public List<ArtifactSummaryInEnvironment> getArtifactSummariesInEnvironment(@NotNull DeliveryConfig deliveryConfig, @NotNull String environmentName, @NotNull String artifactReference, @NotNull List<String> versions2) {
        Object v0;
        boolean $i$f$firstOrNull;
        Object $this$firstOrNull$iv;
        block2: {
            Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
            Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
            Intrinsics.checkNotNullParameter((Object)artifactReference, (String)"artifactReference");
            Intrinsics.checkNotNullParameter(versions2, (String)"versions");
            $this$firstOrNull$iv = deliveryConfig.getArtifacts();
            $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                DeliveryArtifact it = (DeliveryArtifact)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getReference(), (Object)artifactReference)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        DeliveryArtifact deliveryArtifact = v0;
        if (deliveryArtifact == null) {
            $this$firstOrNull$iv = "Artifact not found: name=" + artifactReference + ", deliveryConfig=" + deliveryConfig.getName();
            $i$f$firstOrNull = false;
            throw (Throwable)new IllegalStateException($this$firstOrNull$iv.toString());
        }
        DeliveryArtifact artifact = deliveryArtifact;
        Pair pinned2 = (Pair)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Pair<? extends String, ? extends ActionMetadata>>(this, deliveryConfig, environmentName, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ DeliveryArtifact $artifact;

            public final Pair<String, ActionMetadata> invoke() {
                return (Pair)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).where(Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).fetchOne((RecordMapper)getArtifactSummariesInEnvironment.pinned.1.INSTANCE);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
        Map vetoed2 = (Map)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Map<String, ? extends ActionMetadata>>(this, deliveryConfig, environmentName, artifact){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ DeliveryArtifact $artifact;

            @NotNull
            public final Map<String, ActionMetadata> invoke() {
                List list = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.COMMENT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VETO).where(Tables.ENVIRONMENT_ARTIFACT_VETO.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).fetch((RecordMapper)getArtifactSummariesInEnvironment.vetoed.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jooq.select(\n          E\u2026ment = comment)\n        }");
                return MapsKt.toMap((Iterable)list);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifact = deliveryArtifact;
                super(0);
            }
        });
        Object t = this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<List<ArtifactSummaryInEnvironment>>(this, deliveryConfig, environmentName, artifact, versions2, pinned2, vetoed2){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ List $versions;
            final /* synthetic */ Pair $pinned;
            final /* synthetic */ Map $vetoed;

            public final List<ArtifactSummaryInEnvironment> invoke() {
                return SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.in((Collection)this.$versions)).orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT.desc()).fetch((RecordMapper)new RecordMapper<Record5<String, Instant, PromotionStatus, String, Instant>, ArtifactSummaryInEnvironment>(this){
                    final /* synthetic */ getArtifactSummariesInEnvironment.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final ArtifactSummaryInEnvironment map(Record5<String, Instant, PromotionStatus, String, Instant> $dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt) {
                        void replacedBy;
                        void deployedAt;
                        void promotionStatus;
                        void version;
                        String string = (String)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component1();
                        Instant instant = (Instant)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component2();
                        PromotionStatus promotionStatus2 = (PromotionStatus)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component3();
                        String string2 = (String)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component4();
                        Instant replacedAt = (Instant)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component5();
                        String string3 = this.this$0.$environmentName;
                        void v1 = version;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"version");
                        String string4 = promotionStatus.name();
                        boolean bl = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                        return new ArtifactSummaryInEnvironment(string3, (String)v1, string6, (Instant)deployedAt, replacedAt, (String)replacedBy, this.this$0.$pinned != null && Intrinsics.areEqual((Object)((String)this.this$0.$pinned.getFirst()), (Object)version) ? (ActionMetadata)this.this$0.$pinned.getSecond() : null, (ActionMetadata)this.this$0.$vetoed.get(version), null, null, null, 1792, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifact = deliveryArtifact;
                this.$versions = list;
                this.$pinned = pair;
                this.$vetoed = map;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(READ)\u2026        )\n        }\n    }");
        return (List)t;
    }

    @Nullable
    public ArtifactSummaryInEnvironment getArtifactSummaryInEnvironment(@NotNull DeliveryConfig deliveryConfig, @NotNull String environmentName, @NotNull String artifactReference, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        Intrinsics.checkNotNullParameter((Object)artifactReference, (String)"artifactReference");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return (ArtifactSummaryInEnvironment)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<ArtifactSummaryInEnvironment>(this, deliveryConfig, artifactReference, environmentName, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $artifactReference;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ String $version;

            public final ArtifactSummaryInEnvironment invoke() {
                Object v0;
                block2: {
                    Iterable $this$firstOrNull$iv = this.$deliveryConfig.getArtifacts();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        DeliveryArtifact it = (DeliveryArtifact)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getReference(), (Object)this.$artifactReference)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                DeliveryArtifact deliveryArtifact = v0;
                if (deliveryArtifact == null) {
                    String string = "Artifact not found: name=" + this.$artifactReference + ", deliveryConfig=" + this.$deliveryConfig.getName();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                DeliveryArtifact artifact = deliveryArtifact;
                return (ArtifactSummaryInEnvironment)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.REPLACED_AT).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$version)).orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT.desc()).fetchOne((RecordMapper)new RecordMapper<Record5<String, Instant, PromotionStatus, String, Instant>, ArtifactSummaryInEnvironment>(this, artifact){
                    final /* synthetic */ getArtifactSummaryInEnvironment.1 this$0;
                    final /* synthetic */ DeliveryArtifact $artifact;

                    /*
                     * WARNING - void declaration
                     */
                    public final ArtifactSummaryInEnvironment map(Record5<String, Instant, PromotionStatus, String, Instant> $dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt) {
                        void replacedBy;
                        void deployedAt;
                        void promotionStatus;
                        void version;
                        String string = (String)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component1();
                        Instant instant = (Instant)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component2();
                        PromotionStatus promotionStatus2 = (PromotionStatus)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component3();
                        String string2 = (String)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component4();
                        Instant replacedAt = (Instant)$dstr$version$deployedAt$promotionStatus$replacedBy$replacedAt.component5();
                        ActionMetadata vetoed2 = (ActionMetadata)SqlArtifactRepository.access$getJooq$p(this.this$0.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.VETOED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_VETO.COMMENT).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VETO).where(Tables.ENVIRONMENT_ARTIFACT_VETO.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0.this$0, this.this$0.$deliveryConfig, this.this$0.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VETO.ARTIFACT_VERSION.eq((Object)version)).fetchOne((RecordMapper)getArtifactSummaryInEnvironment.vetoed.1.INSTANCE);
                        ActionMetadata pinned2 = null;
                        if (vetoed2 == null) {
                            pinned2 = (ActionMetadata)SqlArtifactRepository.access$getJooq$p(this.this$0.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_BY, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.PINNED_AT, (SelectField)Tables.ENVIRONMENT_ARTIFACT_PIN.COMMENT).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_PIN).where(Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0.this$0, this.this$0.$deliveryConfig, this.this$0.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_VERSION.eq((Object)version)).fetchOne((RecordMapper)getArtifactSummaryInEnvironment.1.INSTANCE);
                        }
                        String string3 = this.this$0.$environmentName;
                        void v1 = version;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"version");
                        String string4 = promotionStatus.name();
                        boolean bl = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string6 = string5.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                        return new ArtifactSummaryInEnvironment(string3, (String)v1, string6, (Instant)deployedAt, replacedAt, (String)replacedBy, pinned2, vetoed2, null, null, null, 1792, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$artifact = deliveryArtifact;
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$artifactReference = string;
                this.$environmentName = string2;
                this.$version = string3;
                super(0);
            }
        });
    }

    @Nullable
    public PromotionStatus getArtifactPromotionStatus(@NotNull DeliveryConfig deliveryConfig, @NotNull DeliveryArtifact artifact, @NotNull String version, @NotNull String environmentName) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        return (PromotionStatus)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<PromotionStatus>(this, deliveryConfig, environmentName, artifact, version){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryConfig $deliveryConfig;
            final /* synthetic */ String $environmentName;
            final /* synthetic */ DeliveryArtifact $artifact;
            final /* synthetic */ String $version;

            public final PromotionStatus invoke() {
                return (PromotionStatus)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq(SqlArtifactRepository.access$getUidFor(this.this$0, this.$deliveryConfig, this.$environmentName))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq(SqlArtifactRepository.access$getUid$p(this.this$0, this.$artifact))).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.eq((Object)this.$version)).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$deliveryConfig = deliveryConfig;
                this.$environmentName = string;
                this.$artifact = deliveryArtifact;
                this.$version = string2;
                super(0);
            }
        });
    }

    @NotNull
    public Collection<DeliveryArtifact> itemsDueForCheck(@NotNull Duration minTimeSinceLastCheck, int limit) {
        Intrinsics.checkNotNullParameter((Object)minTimeSinceLastCheck, (String)"minTimeSinceLastCheck");
        Instant now = this.clock.instant();
        Instant cutoff = now.minus(minTimeSinceLastCheck);
        Object t = this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<List<DeliveryArtifact>>(this, cutoff, limit, now){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ Instant $cutoff;
            final /* synthetic */ int $limit;
            final /* synthetic */ Instant $now;

            public final List<DeliveryArtifact> invoke() {
                return (List)JooqKt.inTransaction(SqlArtifactRepository.access$getJooq$p(this.this$0), (Function1)new Function1<DSLContext, List<DeliveryArtifact>>(this){
                    final /* synthetic */ itemsDueForCheck.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final List<DeliveryArtifact> invoke(@NotNull DSLContext $this$inTransaction) {
                        Intrinsics.checkNotNullParameter((Object)$this$inTransaction, (String)"$receiver");
                        Result result = $this$inTransaction.select((SelectField)Tables.DELIVERY_ARTIFACT.UID, (SelectField)Tables.DELIVERY_ARTIFACT.NAME, (SelectField)Tables.DELIVERY_ARTIFACT.TYPE, (SelectField)Tables.DELIVERY_ARTIFACT.DETAILS, (SelectField)Tables.DELIVERY_ARTIFACT.REFERENCE, (SelectField)Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME, (SelectField)Tables.ARTIFACT_LAST_CHECKED.AT).from(new TableLike[]{(TableLike)Tables.DELIVERY_ARTIFACT, (TableLike)Tables.ARTIFACT_LAST_CHECKED}).where(Tables.DELIVERY_ARTIFACT.UID.eq((Field)Tables.ARTIFACT_LAST_CHECKED.ARTIFACT_UID)).and(Tables.ARTIFACT_LAST_CHECKED.AT.lessOrEqual((Object)this.this$0.$cutoff)).orderBy((OrderField)Tables.ARTIFACT_LAST_CHECKED.AT).limit(this.this$0.$limit).forUpdate().fetch();
                        boolean bl = false;
                        boolean bl2 = false;
                        Result it = result;
                        boolean bl3 = false;
                        Result result2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"it");
                        Iterable $this$forEach$iv = (Iterable)result2;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void deliveryConfigName;
                            void uid2;
                            Record7 $dstr$uid$_u24__u24$_u24__u24$_u24__u24$_u24__u24$deliveryConfigName$lastCheckedAt = (Record7)element$iv;
                            boolean bl4 = false;
                            String string = (String)$dstr$uid$_u24__u24$_u24__u24$_u24__u24$_u24__u24$deliveryConfigName$lastCheckedAt.component1();
                            String string2 = (String)$dstr$uid$_u24__u24$_u24__u24$_u24__u24$_u24__u24$deliveryConfigName$lastCheckedAt.component6();
                            Instant lastCheckedAt = (Instant)$dstr$uid$_u24__u24$_u24__u24$_u24__u24$_u24__u24$deliveryConfigName$lastCheckedAt.component7();
                            $this$inTransaction.insertInto((Table)Tables.ARTIFACT_LAST_CHECKED).set((Field)Tables.ARTIFACT_LAST_CHECKED.ARTIFACT_UID, (Object)uid2).set((Field)Tables.ARTIFACT_LAST_CHECKED.AT, (Object)this.this$0.$now).onDuplicateKeyUpdate().set((Field)Tables.ARTIFACT_LAST_CHECKED.AT, (Object)this.this$0.$now).execute();
                            ApplicationEventPublisher applicationEventPublisher = SqlArtifactRepository.access$getPublisher$p(this.this$0.this$0);
                            Instant instant = lastCheckedAt;
                            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastCheckedAt");
                            applicationEventPublisher.publishEvent((Object)new AboutToBeChecked(instant, "artifact", "deliveryConfig:" + (String)deliveryConfigName));
                        }
                        return result.map((RecordMapper)new RecordMapper<Record7<String, String, String, String, String, String, Instant>, DeliveryArtifact>(this){
                            final /* synthetic */ itemsDueForCheck.1 this$0;

                            /*
                             * WARNING - void declaration
                             */
                            public final DeliveryArtifact map(Record7<String, String, String, String, String, String, Instant> $dstr$_u24__u24$name$type$details$reference$deliveryConfigName) {
                                void reference;
                                void details;
                                void name;
                                void type;
                                String string = (String)$dstr$_u24__u24$name$type$details$reference$deliveryConfigName.component2();
                                String string2 = (String)$dstr$_u24__u24$name$type$details$reference$deliveryConfigName.component3();
                                String string3 = (String)$dstr$_u24__u24$name$type$details$reference$deliveryConfigName.component4();
                                String string4 = (String)$dstr$_u24__u24$name$type$details$reference$deliveryConfigName.component5();
                                String deliveryConfigName = (String)$dstr$_u24__u24$name$type$details$reference$deliveryConfigName.component6();
                                List list = SqlArtifactRepository.access$getArtifactSuppliers$p(this.this$0.this$0.this$0);
                                void v1 = type;
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"type");
                                ArtifactSupplier artifactSupplier = ArtifactSupplierKt.supporting((List)list, (String)v1);
                                void v3 = name;
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"name");
                                void v4 = details;
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"details");
                                void v5 = reference;
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"reference");
                                String string5 = deliveryConfigName;
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"deliveryConfigName");
                                return ArtifactUtilsKt.mapToArtifact(artifactSupplier, (String)v3, (String)type, (String)v4, (String)v5, string5);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$cutoff = instant;
                this.$limit = n;
                this.$now = instant2;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"sqlRetry.withRetry(WRITE\u2026          }\n      }\n    }");
        return (Collection)t;
    }

    private final String priorVersionDeployedIn(String environmentId, String artifactId, String currentVersion) {
        return (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, environmentId, artifactId, currentVersion){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ String $environmentId;
            final /* synthetic */ String $artifactId;
            final /* synthetic */ String $currentVersion;

            public final String invoke() {
                SelectConditionStep selectConditionStep = SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION).from((TableLike)Tables.ENVIRONMENT_ARTIFACT_VERSIONS).where(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ENVIRONMENT_UID.eq((Object)this.$environmentId)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_UID.eq((Object)this.$artifactId)).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION.ne((Object)this.$currentVersion));
                TableField<EnvironmentArtifactVersionsRecord, Instant> tableField = Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT;
                Intrinsics.checkNotNullExpressionValue(tableField, (String)"ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT");
                return (String)selectConditionStep.and(tableField.isNotNull()).and(Tables.ENVIRONMENT_ARTIFACT_VERSIONS.PROMOTION_STATUS.ne((Object)PromotionStatus.VETOED)).orderBy((OrderField)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.DEPLOYED_AT.desc()).limit(1).fetchOne((Field)Tables.ENVIRONMENT_ARTIFACT_VERSIONS.ARTIFACT_VERSION);
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$environmentId = string;
                this.$artifactId = string2;
                this.$currentVersion = string3;
                super(0);
            }
        });
    }

    private final void deletePin(String envUid, String artUid) {
        this.jooq.deleteFrom((Table)Tables.ENVIRONMENT_ARTIFACT_PIN).where(new Condition[]{Tables.ENVIRONMENT_ARTIFACT_PIN.ENVIRONMENT_UID.eq((Object)envUid), Tables.ENVIRONMENT_ARTIFACT_PIN.ARTIFACT_UID.eq((Object)artUid)}).execute();
    }

    private final Environment environmentNamed(DeliveryConfig $this$environmentNamed, String name) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$environmentNamed.getEnvironments();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Environment it = (Environment)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Object var3_3 = v0;
        boolean bl = false;
        boolean bl2 = false;
        if (var3_3 == null) {
            boolean bl3 = false;
            String string = "No environment named " + name + " exists in the configuration " + $this$environmentNamed.getName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return var3_3;
    }

    private final Select<Record1<String>> getUidFor(DeliveryConfig $this$getUidFor, Environment environment) {
        SelectConditionStep selectConditionStep = DSL.select((SelectField)((SelectField)Tables.LATEST_ENVIRONMENT.UID)).from((TableLike)Tables.LATEST_ENVIRONMENT).where(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)environment.getName())).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq(this.getUid($this$getUidFor)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select(LATEST_ENVIRONMEN\u2026IVERY_CONFIG_UID.eq(uid))");
        return (Select)selectConditionStep;
    }

    private final Select<Record1<String>> getUidFor(DeliveryConfig $this$getUidFor, String environmentName) {
        SelectConditionStep selectConditionStep = DSL.select((SelectField)((SelectField)Tables.LATEST_ENVIRONMENT.UID)).from((TableLike)Tables.LATEST_ENVIRONMENT).where(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)environmentName)).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq(this.getUid($this$getUidFor)));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select(LATEST_ENVIRONMEN\u2026IVERY_CONFIG_UID.eq(uid))");
        return (Select)selectConditionStep;
    }

    private final String getUidStringFor(DeliveryConfig $this$getUidStringFor, Environment environment) {
        String string = (String)this.jooq.select((SelectField)Tables.LATEST_ENVIRONMENT.UID).from((TableLike)Tables.LATEST_ENVIRONMENT).where(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)environment.getName())).and(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq(this.getUid($this$getUidStringFor))).fetchOne((Field)Tables.LATEST_ENVIRONMENT.UID);
        if (string == null) {
            String string2 = "environment not found for " + $this$getUidStringFor.getName() + " / " + environment.getName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private final Select<Record1<String>> getUid(DeliveryArtifact $this$uid) {
        SelectConditionStep selectConditionStep = DSL.select((SelectField)((SelectField)Tables.DELIVERY_ARTIFACT.UID)).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)$this$uid.getName()).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)$this$uid.getType())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)$this$uid.getDeliveryConfigName())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)$this$uid.getReference())));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select(DELIVERY_ARTIFACT\u2026CE.eq(reference))\n      )");
        return (Select)selectConditionStep;
    }

    private final String getUidString(DeliveryArtifact $this$uidString) {
        return (String)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<String>(this, $this$uidString){
            final /* synthetic */ SqlArtifactRepository this$0;
            final /* synthetic */ DeliveryArtifact $this_uidString;

            @NotNull
            public final String invoke() {
                String string = (String)SqlArtifactRepository.access$getJooq$p(this.this$0).select((SelectField)Tables.DELIVERY_ARTIFACT.UID).from((TableLike)Tables.DELIVERY_ARTIFACT).where(Tables.DELIVERY_ARTIFACT.NAME.eq((Object)this.$this_uidString.getName()).and(Tables.DELIVERY_ARTIFACT.TYPE.eq((Object)this.$this_uidString.getType())).and(Tables.DELIVERY_ARTIFACT.DELIVERY_CONFIG_NAME.eq((Object)this.$this_uidString.getDeliveryConfigName())).and(Tables.DELIVERY_ARTIFACT.REFERENCE.eq((Object)this.$this_uidString.getReference()))).fetchOne((Field)Tables.DELIVERY_ARTIFACT.UID);
                if (string == null) {
                    String string2 = "artifact not found for " + "name=" + this.$this_uidString.getName() + ", " + "type=" + this.$this_uidString.getType() + ", " + "deliveryConfig=" + this.$this_uidString.getDeliveryConfigName() + ", " + "reference=" + this.$this_uidString.getReference();
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                return string;
            }
            {
                this.this$0 = sqlArtifactRepository;
                this.$this_uidString = deliveryArtifact;
                super(0);
            }
        });
    }

    private final Select<Record1<String>> getUid(DeliveryConfig $this$uid) {
        SelectConditionStep selectConditionStep = DSL.select((SelectField)((SelectField)Tables.DELIVERY_CONFIG.UID)).from((TableLike)Tables.DELIVERY_CONFIG).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)$this$uid.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"select(DELIVERY_CONFIG.U\u2026ERY_CONFIG.NAME.eq(name))");
        return (Select)selectConditionStep;
    }

    private final String fingerprint(DeliveryArtifact $this$fingerprint) {
        String string = $this$fingerprint.getName();
        String string2 = $this$fingerprint.getType();
        String string3 = $this$fingerprint.getDeliveryConfigName();
        if (string3 == null) {
            string3 = "_pending";
        }
        return this.fingerprint(string, string2, string3, $this$fingerprint.getReference());
    }

    private final String fingerprint(String name, String type, String deliveryConfigName, String reference) {
        String data = name + type + deliveryConfigName + reference;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        String string3 = DatatypeConverter.printHexBinary((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DatatypeConverter.printHexBinary(bytes)");
        string = string3;
        boolean bl2 = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        return string5;
    }

    private final String vetoKey(String envName, String artifactId) {
        return envName + ':' + artifactId;
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SqlArtifactRepository sqlArtifactRepository = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public SqlArtifactRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull ObjectMapper objectMapper, @NotNull SqlRetry sqlRetry, @NotNull List<? extends ArtifactSupplier<?, ?>> artifactSuppliers, @NotNull ApplicationEventPublisher publisher) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        Intrinsics.checkNotNullParameter(artifactSuppliers, (String)"artifactSuppliers");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        this.jooq = jooq;
        this.clock = clock;
        this.objectMapper = objectMapper;
        this.sqlRetry = sqlRetry;
        this.artifactSuppliers = artifactSuppliers;
        this.publisher = publisher;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SqlArtifactRepository this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = sqlArtifactRepository;
                super(0);
            }
        }));
    }

    public /* synthetic */ SqlArtifactRepository(DSLContext dSLContext, Clock clock, ObjectMapper objectMapper, SqlRetry sqlRetry, List list, ApplicationEventPublisher applicationEventPublisher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(dSLContext, clock, objectMapper, sqlRetry, list, applicationEventPublisher);
    }

    public boolean isNewer(@NotNull DeliveryArtifact artifact, @NotNull PublishedArtifact version, @NotNull PublishedArtifact existingVersion) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)existingVersion, (String)"existingVersion");
        return ArtifactRepository.DefaultImpls.isNewer((ArtifactRepository)this, (DeliveryArtifact)artifact, (PublishedArtifact)version, (PublishedArtifact)existingVersion);
    }

    public boolean isOlder(@NotNull DeliveryArtifact artifact, @NotNull PublishedArtifact publishedArtifact, @NotNull PublishedArtifact existingVersion) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)publishedArtifact, (String)"new");
        Intrinsics.checkNotNullParameter((Object)existingVersion, (String)"existingVersion");
        return ArtifactRepository.DefaultImpls.isOlder((ArtifactRepository)this, (DeliveryArtifact)artifact, (PublishedArtifact)publishedArtifact, (PublishedArtifact)existingVersion);
    }

    public void markCheckComplete(@NotNull DeliveryArtifact deliveryConfig) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        ArtifactRepository.DefaultImpls.markCheckComplete((ArtifactRepository)this, (DeliveryArtifact)deliveryConfig);
    }

    @NotNull
    public List<PublishedArtifact> removeNewerIfCurrentExists(@NotNull DeliveryArtifact artifact, @Nullable PublishedArtifact currentVersion, @Nullable List<PublishedArtifact> pending) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return ArtifactRepository.DefaultImpls.removeNewerIfCurrentExists((ArtifactRepository)this, (DeliveryArtifact)artifact, (PublishedArtifact)currentVersion, pending);
    }

    @NotNull
    public List<PublishedArtifact> removeOlderIfCurrentExists(@NotNull DeliveryArtifact artifact, @Nullable PublishedArtifact currentVersion, @Nullable List<PublishedArtifact> pending) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return ArtifactRepository.DefaultImpls.removeOlderIfCurrentExists((ArtifactRepository)this, (DeliveryArtifact)artifact, (PublishedArtifact)currentVersion, pending);
    }

    public static final /* synthetic */ DSLContext access$getJooq$p(SqlArtifactRepository $this) {
        return $this.jooq;
    }

    public static final /* synthetic */ String access$fingerprint(SqlArtifactRepository $this, DeliveryArtifact $this$access_u24fingerprint) {
        return $this.fingerprint($this$access_u24fingerprint);
    }

    public static final /* synthetic */ String access$detailsAsJson(SqlArtifactRepository $this, DeliveryArtifact $this$access_u24detailsAsJson) {
        return $this.detailsAsJson($this$access_u24detailsAsJson);
    }

    public static final /* synthetic */ List access$getArtifactSuppliers$p(SqlArtifactRepository $this) {
        return $this.artifactSuppliers;
    }

    public static final /* synthetic */ Select access$getUid$p(SqlArtifactRepository $this, DeliveryArtifact $this$access_u24uid_u24p) {
        return $this.getUid($this$access_u24uid_u24p);
    }

    public static final /* synthetic */ Logger access$getLog$p(SqlArtifactRepository $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ Clock access$getClock$p(SqlArtifactRepository $this) {
        return $this.clock;
    }

    public static final /* synthetic */ Select access$getUidFor(SqlArtifactRepository $this, DeliveryConfig $this$access_u24getUidFor, Environment environment) {
        return $this.getUidFor($this$access_u24getUidFor, environment);
    }

    public static final /* synthetic */ String access$vetoKey(SqlArtifactRepository $this, String envName, String artifactId) {
        return $this.vetoKey(envName, artifactId);
    }

    public static final /* synthetic */ void access$upsertAsVetoedInEnvironmentArtifactVersionsTable(SqlArtifactRepository $this, DSLContext $this$access_u24upsertAsVetoedInEnvironmentArtifactVersionsTable, String prior, EnvironmentArtifactVeto veto, String envUid, String artUid) {
        $this.upsertAsVetoedInEnvironmentArtifactVersionsTable($this$access_u24upsertAsVetoedInEnvironmentArtifactVersionsTable, prior, veto, envUid, artUid);
    }

    public static final /* synthetic */ void access$addRecordToEnvironmentArtifactVetoTable(SqlArtifactRepository $this, DSLContext $this$access_u24addRecordToEnvironmentArtifactVetoTable, String envUid, String artUid, EnvironmentArtifactVeto veto) {
        $this.addRecordToEnvironmentArtifactVetoTable($this$access_u24addRecordToEnvironmentArtifactVetoTable, envUid, artUid, veto);
    }

    public static final /* synthetic */ void access$setPromotionReference(SqlArtifactRepository $this, DSLContext $this$access_u24setPromotionReference, String version, String envUid, String artUid, String prior) {
        $this.setPromotionReference($this$access_u24setPromotionReference, version, envUid, artUid, prior);
    }

    public static final /* synthetic */ String access$getUidStringFor(SqlArtifactRepository $this, DeliveryConfig $this$access_u24getUidStringFor, Environment environment) {
        return $this.getUidStringFor($this$access_u24getUidStringFor, environment);
    }

    public static final /* synthetic */ Environment access$environmentNamed(SqlArtifactRepository $this, DeliveryConfig $this$access_u24environmentNamed, String name) {
        return $this.environmentNamed($this$access_u24environmentNamed, name);
    }

    public static final /* synthetic */ String access$getUidString$p(SqlArtifactRepository $this, DeliveryArtifact $this$access_u24uidString_u24p) {
        return $this.getUidString($this$access_u24uidString_u24p);
    }

    public static final /* synthetic */ Select access$getUidFor(SqlArtifactRepository $this, DeliveryConfig $this$access_u24getUidFor, String environmentName) {
        return $this.getUidFor($this$access_u24getUidFor, environmentName);
    }

    public static final /* synthetic */ Select access$getUid$p(SqlArtifactRepository $this, DeliveryConfig $this$access_u24uid_u24p) {
        return $this.getUid($this$access_u24uid_u24p);
    }

    public static final /* synthetic */ void access$deletePin(SqlArtifactRepository $this, String envUid, String artUid) {
        $this.deletePin(envUid, artUid);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getPublisher$p(SqlArtifactRepository $this) {
        return $this.publisher;
    }
}

